 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;                                                                       ;;
 ;;                Centre for Speech Technology Research                  ;;
 ;;                     University of Edinburgh, UK                       ;;
 ;;                       Copyright (c) 1996,1997                         ;;
 ;;                        All Rights Reserved.                           ;;
 ;;                                                                       ;;
 ;;  Permission to use, copy, modify, distribute this software and its    ;;
 ;;  documentation for research, educational and individual use only, is  ;;
 ;;  hereby granted without fee, subject to the following conditions:     ;;
 ;;   1. The code must retain the above copyright notice, this list of    ;;
 ;;      conditions and the following disclaimer.                         ;;
 ;;   2. Any modifications must be clearly marked as such.                ;;
 ;;   3. Original authors' names are not deleted.                         ;;
 ;;  This software may not be used for commercial purposes without        ;;
 ;;  specific prior written permission from the authors.                  ;;
 ;;                                                                       ;;
 ;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
 ;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
 ;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
 ;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
 ;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
 ;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
 ;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
 ;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
 ;;  THIS SOFTWARE.                                                       ;;
 ;;                                                                       ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;                                                                       ;;
 ;;                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             ;;
 ;;                   Date: Wed Nov  5 1997                               ;;
 ;; -------------------------------------------------------------------   ;;
 ;; Voice definition for GSW voice, new synthesis.                        ;;
 ;;                                                                       ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(print "load gsw_new init")
(require 'unitdatabase)
(require 'mrpa_phones)
(require 'pos)
(require 'phrase)
(require 'tobi)
(require 'f2bf0lr)
(require 'mrpa_durs)


(set! voice_dir "/projects/festival/data/gsw_new_diphone")

(set! load-path (append
		   load-path
		   (list (path-append  voice_dir "festvox/"))
		   ))

(set! us_abs_offset 0.0)
(set! window_factor 1.0)
(set! us_rel_offset 0.0)
(set! us_gain 0.5)

(require 'mrpa_allophones)
(require 'gswdurtreeZ)

(set! gsw_us_psola_sep '((name "gsw_us_psola_sep")
  (index_file "/projects/festival/data/gsw_diphone/dic/diphdic.play.est")
  (grouped "false")
  (coef_dir "/projects/festival/data/gsw_diphone/work_pm/exp1_pm")
  (sig_dir  "/projects/festival/data/gsw_diphone/vox")
  (coef_ext ".pm")
  (sig_ext ".vox")))

(set! gsw_us_psola_group '((name "us_gsw_psola_group")
  (index_file "/home/pault/projects/festival/src/main/zz3.dic")
  (grouped "true")))

;;(us_diphone_init gsw_us_psola_group)
(us_diphone_init gsw_us_psola_sep)

(define (voice_gsw_us_diphone)
  "(voice_gsw_b_diphone)
    Set up the current voice to be a British male RP (Gordon) speaker using
    the gsw diphone set. New Synthesis scheme"
  (voice_reset)

  (Parameter.set 'Language 'britishenglish)

  ;; Phone set
  (Parameter.set 'PhoneSet 'mrpa)
  (PhoneSet.select 'mrpa)

  ;; Tokenization rules
  (set! token_to_words english_token_to_words)

  ;; POS tagger
  (set! pos_lex_name "english_poslex")
  (set! pos_ngram_name 'english_pos_ngram)
  (set! pos_supported t)
  (set! guess_pos english_guess_pos);; need this for accents

  ;; Lexicon selection
  (lex.select "oald")
  (set! postlex_rules_hooks (list postlex_apos_s_check))

  ;; Phrase prediction
  (Parameter.set 'Phrase_Method 'prob_models)
  (set! break_pos_ngram_name 'english_break_pos_ngram)
  (set! break_ngram_name 'english_break_ngram)
  (set! phrase_type_tree english_phrase_type_tree)

  ;; Accent and tone prediction
  (set! int_tone_cart_tree f2b_int_tone_cart_tree)
  (set! int_accent_cart_tree f2b_int_accent_cart_tree)
  (Parameter.set 'Int_Method Intonation_Tree)

  ;; F0 prediction
  (set! f0_lr_start f2b_f0_lr_start)
  (set! f0_lr_mid f2b_f0_lr_mid)
  (set! f0_lr_end f2b_f0_lr_end)
  (set! int_lr_params
	'((target_f0_mean 80) (target_f0_std 15)
	  (model_f0_mean 145) (model_f0_std 34)))
  (Parameter.set 'Int_Target_Method Int_Targets_LR)

  ;; Duration prediction
  (set! duration_cart_tree gsw_duration_cart_tree)
  (set! duration_ph_info gsw_durs)
  (Parameter.set 'Duration_Method Duration_Tree_ZScores)
  (Parameter.set 'Duration_Stretch 1.3)

  (Parameter.set 'Synth_Method 'UniSyn)
  (Parameter.set 'us_sigpr 'psola)

  (set! current-voice 'gsw_us_diphone)
  )


(provide 'gsw_us_diphone)



