#include "sort.h"                                          /*    SWRITE.C  */
#include "cs.h"

static int    lincnt, pcnt;

static SRTBLK *nxtins(SRTBLK *), *prvins(SRTBLK *);
static char   *pfout(SRTBLK *, char *), *nextp(SRTBLK *, char *);
static char   *prevp(SRTBLK *, char *), *ramp(SRTBLK *, char *);
static char   *pfstr(char *), *fpnum(char *);
static void   fltout(float);
/* #define fltout(n) fprintf(SCOREOUT, "%.6f", n) */

void swrite(void)
{
	SRTBLK *bp;
	char *p, c;

	if ((bp = frstbp) == NULL)
		return;
        lincnt = 0;
	if ((c = bp->text[0]) != 'w'
	  && c != 's' && c != 'e') {     /* if no warp stmnt but real data,  */
		fprintf(SCOREOUT,"w 0 60\n");/* create warp-format indicator */
		lincnt++;
	}
nxtlin: lincnt++;                       /* now for each line:           */
	p = bp->text;
	c = *p++;
	putc(c,SCOREOUT);
	switch(c) {
	case 'i':
	case 'f':
	case 'a':
		putc(*p++,SCOREOUT);
		while ((c = *p++) != SP && c != LF)
			putc(c,SCOREOUT);               /* put p1       */
		putc(c,SCOREOUT);
		if (c == LF)
			break;
		fltout(bp->p2val);                      /* put p2val,   */
		putc(SP,SCOREOUT);
		fltout(bp->newp2);                      /*   newp2,     */
		while ((c = *p++) != SP && c != LF)
			;
		putc(c,SCOREOUT);                       /*   and delim  */
		if (c == LF)
			break;
                fltout(bp->p3val);                      /* put p3val,   */
		putc(SP,SCOREOUT);
		fltout(bp->newp3);                      /*   newp3,     */
		while ((c = *p++) != SP && c != LF)
			;
		putc(c,SCOREOUT);                       /*   and delim  */
		pcnt = 3;
		while (c != LF) {
			pcnt++;
			p = pfout(bp,p);        /* now put each pfield  */
			c = *p++;
			putc(c,SCOREOUT);       /*  and its delimiter   */
		}
		break;
	case 'w':
	case 't':
	case 's':
	case 'e':
		while ((c = *p++) != LF)        /* put entire line      */
			putc(c,SCOREOUT);
		putc(LF,SCOREOUT);
		break;
	default:
		err_printf("swrite: unexpected opcode, section %d line %d\n",
		  sectcnt,lincnt);
                break;
	}
	if ((bp = bp->nxtblk) != NULL)
		goto nxtlin;
}

static char *pfout(SRTBLK *bp, char *p)
{
	switch(*p) {
	case 'n':
		p = nextp(bp,p);
		break;
	case 'p':
		p = prevp(bp,p);
		break;
	case '<':
	case '>':
		p = ramp(bp,p);
		break;
	case '"':
		p = pfstr(p);
		break;
	default:
		p = fpnum(p);
		break;
	}
	return(p);
}

static SRTBLK *nxtins(SRTBLK *bp)                        /* find nxt note with same p1 */
{
	float p1;

	p1 = bp->p1val;
	while ((bp = bp->nxtblk) != NULL
	    && (bp->p1val != p1 || bp->text[0] != 'i'))
		;
	return(bp);
}

static SRTBLK *prvins(SRTBLK *bp)                        /* find prv note with same p1 */
{
	float p1;

	p1 = bp->p1val;
	while ((bp = bp->prvblk) != NULL
	    && (bp->p1val != p1 || bp->text[0] != 'i'))
                ;              
	return(bp);
}

static char *nextp(SRTBLK *bp, char *p)
{
	char *q;
	int n;

	q = p;
	p++;                                    /* 1st char     */
	if (*p++ != 'p')                        /* 2nd char     */
		goto error;
	n = 999;
	if (*p >= '0' && *p <= '9')
		n = *p++ - '0';
	if (*p >= '0' && *p <= '9')             /* n is np subscript no */
		n = 10*n + (*p++ - '0');
	if (*p != SP && *p != LF)
		goto error;
	if ((bp = nxtins(bp)) != NULL           /* for nxtins, same p1  */
	  && n <= bp->pcnt) {
		q = bp->text;
		while (n--)
			while (*q++ != SP)      /*   go find the pfield */
				;
		pfout(bp,q);                    /*   and put it out     */
	}
	else {
	 error: err_printf(
		  "swrite: output, sect%d line%d p%d makes illegal reference to ",
		  sectcnt,lincnt,pcnt);
		while (q < p)
			err_printf("%c", *q++);
		while (*p != SP && *p != LF)
			err_printf("%c", *p++);
		err_printf("   Zero substituted\n");
		putc('0',SCOREOUT);
	}
	return(p);
}

static char *prevp(SRTBLK *bp, char *p)
{
	char *q;
	int n;

	q = p;
	p++;                                    /* 1st char     */
	if (*p++ != 'p')                        /* 2nd char     */
		goto error;
	n = 999;
	if (*p >= '0' && *p <= '9')
		n = *p++ - '0';
	if (*p >= '0' && *p <= '9')             /* n is np subscript no */
		n = 10*n + (*p++ - '0');
	if (*p != SP && *p != LF)
		goto error;
	if ((bp = prvins(bp)) != NULL           /* for prvins, same p1, */
	  && n <= bp->pcnt) {
		q = bp->text;
		while (n--)
			while (*q++ != SP)      /*   go find the pfield */
				;
		pfout(bp,q);                    /*   and put it out     */
	}
	else {
	 error: err_printf(
		  "swrite: output, sect%d line%d p%d makes illegal reference to ",
		  sectcnt,lincnt,pcnt);
		while (q < p)
			err_printf("%c", *q++);
		while (*p != SP && *p != LF)
			err_printf("%c", *p++);
		err_printf("   Zero substituted\n");
		putc('0',SCOREOUT);
	}
	return(p);
}

static char *ramp(SRTBLK *bp, char *p) /*     NB np's may reference a ramp  */
				/*  but ramps must terminate in valid nums */
{
        char *q;
	char   *psav;
	SRTBLK *prvbp, *nxtbp;
	float pval, qval, rval, p2span;
extern  float stof(char*);
        int pnum, n;

	psav = ++p;
	if (*psav != SP && *psav != LF)
		goto error1;
	pnum = 0;
	q = bp->text;
	while (q < p)
		if (*q++ == SP)
			pnum++;
	prvbp = bp;
backup: if ((prvbp = prvins(prvbp)) != NULL) {
		p = prvbp->text;
		n = pnum;
		while (n--)
			while (*p++ != SP)
				;
		if (*p == '>' || *p == '<')
			goto backup;
	}
	else goto error2;
	nxtbp = bp;
forwrd: if ((nxtbp = nxtins(nxtbp)) != NULL) {
		q = nxtbp->text;
		n = pnum;
		while (n--)
			while (*q++ != SP)
				;
		if (*q == '>' || *q == '<')
			goto forwrd;
	}
	else goto error2;
	pval = stof(p);         /* the error msgs generated by stof     */
	qval = stof(q);                                 /* are misleading */
	if ((p2span = nxtbp->newp2 - prvbp->newp2) <= 0)
		goto error2;
	rval = (qval - pval) * (bp->newp2 - prvbp->newp2) / p2span + pval;
	fltout(rval);
	return(psav);

error1: err_printf("swrite: output, sect%d line%d p%d has illegal ramp symbol\n",
	 sectcnt,lincnt,pcnt);
	goto put0;
error2: err_printf(
	"swrite: output, sect%d line%d p%d ramp has illegal forward or backward ref\n",
	 sectcnt,lincnt,pcnt);
put0:   putc('0',SCOREOUT);
        return(psav);
}

static char *pfstr(char *p)	/*   moves quoted ascii string to SCOREOUT file */
				/*      with no internal format chk             */
{
	char *q = p;
	putc(*p++,SCOREOUT);
	while (*p != '"')
		putc(*p++,SCOREOUT);
	putc(*p++,SCOREOUT);
	if (*p != SP && *p != LF) {
		err_printf(
		"swrite: output, sect%d line%d p%d has illegally terminated string   ",
			sectcnt,lincnt,pcnt);
		while (q < p)
			err_printf("%c", *q++);
		while (*p != SP && *p != LF)
			err_printf("%c", *p++);
		err_printf("\n");
        }                                
	return(p);
}

static char *fpnum(char *p)	/*   moves ascii string to SCOREOUT file */
				/*      with fpnum format chk            */
{
	char *q;
	int dcnt;
                
	q = p;
	if (*p == '+')
		p++;
	if (*p == '-')
		putc(*p++,SCOREOUT);
	dcnt = 0;
	while (*p >= '0' && *p <= '9') {
		putc(*p++,SCOREOUT);
		dcnt++;
	}
	if (*p == '.')
		putc(*p++,SCOREOUT);
	while (*p >= '0' && *p <= '9') {
		putc(*p++,SCOREOUT);
		dcnt++;
	}
	if (*p != SP && *p != LF || !dcnt) {
		err_printf(
		"swrite: output, sect%d line%d p%d has illegal number  ",
			sectcnt,lincnt,pcnt);
		while (q < p)
			err_printf("%c", *q++);
		while (*p != SP && *p != LF)
			err_printf("%c", *p++);
		err_printf("    String truncated\n");
		if (!dcnt)
			putc('0',SCOREOUT);
        }                                
	return(p);
}

/* #ifdef NEVER */
static void fltout(float num)	/* float to ascii on SCOREOUT file  */
{
        double incnum, precision /*, precmult*/;
	int tenpower, printcnt, digit;
	double dnum = (double) num; /* Work in doubles for large tables */

/* These are the original values  */
/*	precision = .000001; */
/*	precmult = 1.0000005; */ /* is this ok for float without double? */

/* These are new, changed by Richard Karpen to make large table sizes work */
/* The variable incnum, precision, and precmult were changed to */
/* from floats doubles above to make this work right  */
	precision = .0000001;
/* 	precmult = 1.000000;   */

	tenpower = printcnt = 0;

	if (dnum == 0.0)
		goto done;
	if (dnum < 0.0) {
		putc('-',SCOREOUT);
		dnum = -dnum;
	}
#ifdef LINUX
 	dnum *= 1.0000005;
#endif
	while (dnum >= 1.0) {
		dnum /= 10.0;
		tenpower++;
	}
	incnum = dnum;
	while (dnum/incnum > precision) {
		if (!tenpower--)
			putc('.',SCOREOUT);
		incnum *= 10.0;
		dnum *= 10.0;
		digit = (int) dnum;
		dnum -= (float) digit;
		putc((char)(digit + '0'),SCOREOUT);
		printcnt++;
	}
	while (tenpower-- > 0) {
		putc('0',SCOREOUT);
		printcnt++;
	}
done:   if (!printcnt)
		putc('0',SCOREOUT);
}
/* #endif */
