/********************************************************************************
 * Copyright (c) Erik Kunze 1995 - 1998
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char rcsid[] = "$Id: tap.c,v 4.5 1998/01/06 21:15:59 erik Rel $";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "config.h"
#include "z80.h"
#include "debug.h"
#include "resource.h"
#include "mem.h"
#include "util.h"
#include "loadsave.h"
#ifdef REGISTERED
#include "vtp.h"
#endif
#include "tap.h"

typedef struct _tapRecord {
	uns8 *pos;
	char *str;
	uns8 id;
	uns8 type;
	char name[11];
	uns16 length;
} tapRecord;

static void tapScanFile(void);




int
TapNewFile(void)
{
	tapScanFile();
#ifdef REGISTERED
	VtpNewFile();
#endif
	return 0;
}

void
TapLoadBlock(void)
{
	uns16 length;
	uns8 *data;
	int byte, crc, error = 0;
	tapRecord *tr;
	if (TpInBlockCurrent >= TpInBlockCount - 1)
	{
#ifdef DEBUG
		if (GETCFG(debug) & D_TAPE)
		{
			Msg(M_DEBUG, "TAP: end of tape reached");
		}
#endif
		if (TpInsertTape("Load Tape", TO_READ | TO_TAP) == -1)
		{
			PC = 0x0552;
			return;
		}
	}
	tr = (tapRecord *)RetrieveElemList(TpInBlockList, TpInBlockCurrent);
	assert(tr != NULL);
	if (tr->length)
	{
		length = tr->length;
		data = tr->pos + 3;
		if (tr->id == A)
		{
#ifdef DEBUG
			if (GETCFG(debug) & D_TAPE)
			{
				Msg(M_DEBUG, "TAP: %s, id = %02x, pos = %6d, block = %5d",
					F & C_FLAG ? "loading" : "verifying", tr->id,
					(int)(tr->pos - TpInBegin), length);
			}
#endif
			if (DE > length)
			{
				DE = length;
				error = 1;
			}
			crc = tr->id;
			while (DE--)
			{
				byte = *data++;
				if (F & C_FLAG)
				{
					WR_BYTE(IX, (uns8)byte);
				}
				else
				{
					if (byte != RD_BYTE(IX))
					{
						error = 1;
					}
				}
				IX++;
				crc ^= byte;
			}
			if (!error)
			{
				byte = *data++;
				if ((crc ^= byte) != 0)
				{
#ifdef DEBUG
					if (GETCFG(debug) & D_TAPE)
					{
						Msg(M_DEBUG, "TAP: checksum error");
					}
#endif
					error = 1;
				}
			}
		}
		else
		{
			error = 1;
		}
	}
#ifdef DEBUG
	else
	{

		if (GETCFG(debug) & D_TAPE)
		{
			Msg(M_DEBUG, "TAP:%s, id = ff, pos = %6d, block =     0",
				F & C_FLAG ? "loading" : "verifying",
				(int)(tr->pos - TpInBegin));
		}
	}
#endif
	if (error)
	{
		F &= Z_FLAG | C_FLAG;
	}
	else
	{
		F |= Z_FLAG | C_FLAG;
	}
	IX += DE;
	DE = 0;

	IFF1 = 1;
	IFF2 = 1;
	RET();

	TpInBlockCurrent++;
#ifdef REGISTERED
	VtpUpdate();
#endif
}

void
TapSaveBlock(FILE *fp)
{
	uns16 length;
	int byte, crc;
	length = DE + 2;
	(void)putc(length & 255, fp);
	(void)putc(length / 256, fp);
	(void)putc((int)A, fp);
	crc = A;
	while (DE--)
	{
		byte = RD_BYTE(IX);
		(void)putc(byte, fp);
		IX++;
		crc ^= byte;
	}
	(void)putc(crc, fp);
	(void)fflush(fp);
	F |= C_FLAG;
	IX += DE;
	DE = 0;

	IFF1 = 1;
	IFF2 = 1;
	RET();
}

static void
tapScanFile(void)
{
	static char *types[] = { "Program", "Num.Array", "Char.Array", "Bytes", ""};
	char buf[30];
	uns8 *scanPtr = TpInBegin;
	tapRecord *tr;
	int i;
	for (;;)
	{
		tr = Malloc(sizeof(tapRecord), "tapScanFile");
		TpInBlockList = AppendElemList(TpInBlockList, (void *)tr);
		TpInBlockCount++;
		tr->pos = scanPtr;
		if (scanPtr >= TpInEnd)
		{
			tr->str = Strdup("     *** End Of Tape ***", "tapScanFile");
			break;
		}
		tr->length = GET2(scanPtr, 0);
		scanPtr += 2;
		if (!(tr->length))
		{

			tr->id = 0xff;
		}
		else
		{

			tr->length -= 2;
			tr->id = *scanPtr++;
		}
#ifdef DEBUG
		if (GETCFG(debug) & D_TAPE)
		{
			Msg(M_DEBUG, "TAP: scaning, id = %02x, pos = %6d, block = %5d",
				tr->id, tr->pos - TpInBegin, tr->length);
		}
#endif
		if (!tr->id)
		{
			tr->type = *scanPtr++;
			for (i = 0; i < 10; i++)
			{
				tr->name[i] = (*scanPtr < ' ' || *scanPtr > 0x7f) ? '?'
																  : *scanPtr;
				scanPtr++;
			}
			tr->name[10] = '\0';
			scanPtr += tr->length - 10;
		}
		else
		{
			tr->type = 4;
			tr->name[0] = '\0';
			scanPtr += tr->length ? tr->length + 1 : 0;
		}
		(void)sprintf(buf, "%-12s%-12s%5d", tr->name, types[tr->type],
					  (int)tr->length);
		tr->str = Strdup(buf, "tapScanFile");
	}
}

