//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef CARTRIDGEF6_HXX
#define CARTRIDGEF6_HXX

class CartridgeF6;

#include "machine.hxx"
#include "Cart.hxx"

/**
  The 16K cartridge class used by Atari cartridges.  There             
  are 4 4K banks.

  @author  Bradford W. Mott
  @version $Id: CartF6.hxx,v 1.2 1997/05/17 19:00:04 bwmott Exp $
*/
class CartridgeF6 : public Cartridge
{
  public:
    /// Constructor
    CartridgeF6(System& system, uByte* image);
 
    /// Destructor
    virtual ~CartridgeF6();

    /// Reset to power on state
    void reset();

    /// Answer the byte at the given address
    virtual uByte peek(uWord addr);

    /// Store value in the given address
    virtual void poke(uWord addr, uByte value);
 
  private:
    // Bank addressing offsets
    uWord myImageOffset;

    // 16K ROM Image of the cartridge
    uByte myImage[16384];
};
#endif

