//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

/**
  The 8K cartridge class for Parker Brothers' cartridges.  There
  are 4 1K slices under indepenant control.  There are 8 1K blocks that
  you can use.

  @author  Bradford W. Mott
  @version $Id: CartE0.cxx,v 1.2 1997/05/17 19:00:03 bwmott Exp $
*/

#include "CartE0.hxx"
#include "System.hxx"

//============================================================================
// Constructor
//============================================================================
CartridgeE0::CartridgeE0(System& system, uByte* image)
    : Cartridge(system)
{
  // Copy the image into my image buffer
  for(uWord t = 0; t < 8192; ++t)
    myImage[t] = image[t];

  // Map all of my addresses in the system
  for(uWord addr = 0; addr < 8192; ++addr)
  {
    if(addr & 0x1000)
    {
      if(((addr & 0x0FFF) >= 0x0FE0) && ((addr & 0x0FFF) <= 0x0FF7))
        mySystem.mapPeek(addr, *this);
      else if((addr & 0x0C00) == 0x0000)
        mySystem.mapPeek(addr, *this, 
            &myImage[addr & 0x03ff], &myImageOffset[0]);
      else if((addr & 0x0C00) == 0x0400)
        mySystem.mapPeek(addr, *this, 
            &myImage[addr & 0x03ff], &myImageOffset[1]);
      else if((addr & 0x0C00) == 0x0800)
        mySystem.mapPeek(addr, *this, 
            &myImage[addr & 0x03ff], &myImageOffset[2]);
      else
        mySystem.mapPeek(addr, *this, 
            &myImage[addr & 0x03ff], &myImageOffset[3]);

      mySystem.mapPoke(addr, *this);
    }
  }

  // Reset myself
  reset();
}

//============================================================================
// Destructor
//============================================================================
CartridgeE0::~CartridgeE0()
{
}

//============================================================================
// Reset to power on state
//============================================================================
void CartridgeE0::reset()
{
  myImageOffset[0] = 4 * 1024;
  myImageOffset[1] = 5 * 1024;
  myImageOffset[2] = 6 * 1024;
  myImageOffset[3] = 7 * 1024;
}

//============================================================================
// Answer the byte at the given address
//============================================================================
uByte CartridgeE0::peek(uWord addr)
{
  if((addr >= 0x1fe0) && (addr <= 0x1fe7))
    myImageOffset[0] = (addr & 07) * 1024;
  else if((addr >= 0x1fe8) && (addr <= 0x1fef))
    myImageOffset[1] = (addr & 07) * 1024;
  else if((addr >= 0x1ff0) && (addr <= 0x1ff7))
    myImageOffset[2] = (addr & 07) * 1024;

  return myImage[(addr & 0x03ff) + 7 * 1024];
}

//============================================================================
// Store value in the given address
//============================================================================
void CartridgeE0::poke(uWord addr, uByte value)
{
  // All we really do is switch banks
  if((addr >= 0x1fe0) && (addr <= 0x1fe7))
    myImageOffset[0] = (addr & 07) * 1024;
  else if((addr >= 0x1fe8) && (addr <= 0x1fef))
    myImageOffset[1] = (addr & 07) * 1024;
  else if((addr >= 0x1ff0) && (addr <= 0x1ff7))
    myImageOffset[2] = (addr & 07) * 1024;
}
 
