
/*
 * DREADERD/MAIN.C	- newsreader backend for diablo
 *
 *	dreaderd manages the READER BACKEND for diablo.  It's description is
 *	complex, but implementation is relatively streamlined.  dreaderd
 *	operates in three parts:
 *
 *	(1) dreaderd takes a full-feed OR [ a header-only and a
 *	    control-message ] feed from one or more remote diablo
 *	    servers.  It assigns message-id's to (group,artno) pairs in the
 *	    group/article database and processes control messages.
 *
 *	    dreaderd forks for each connection.
 *
 *	(2) dreaderd actively maintains connections to remote diablo or INN
 *	    servers (really any server) for the purposes of retrieving 
 *	    articles on demand.
 *
 *	    dreaderd forks for each connection.
 *
 *	(3) dreaderd supplies a simple backend interface to dnntpd servers,
 *	    allowing them to request overview and article data as well as
 *	    post, and caches the retrieved data in a local spool.
 *
 *	    dreaderd uses a combination of forking and multi-threading to
 *	    perform these operations.
 *
 *	dreaderd employs a shared-memory interface, various databases, and 
 *	locks to allow fully tandem operation, load sharing, and prioritization
 *	of remote connections.
 *
 *	A simple dnntpd interface utilized.
 *
 * (c)Copyright 1997, Matthew Dillon, All Rights Reserved.  Refer to
 *    the COPYRIGHT file in the base directory of this distribution 
 *    for specific rights granted.
 */

#include "defs.h"

int	NetPort = 1800;
int     TxBufSize;
int     RxBufSize;
struct in_addr	NewsBindHost;

int
main(int ac, char **av)
{
    int i;
    int lfd = -1;

    NewsBindHost.s_addr = INADDR_ANY;

    /*
     * options
     */

    for (i = 1; i < ac; ++i) {
	char *ptr = av[i];

	if (*ptr == '-') {
	    char c;

	    ptr += 2;
	    switch((c = ptr[-1])) {
            case 'P':  
		{
		    int port;

		    if (*ptr == 0)
			ptr = av[++i];
		    if ((port = strtol(ptr, NULL, 0)) == 0) {
			struct servent *sen;
			if ((sen = getservbyname(ptr, "tcp")) != NULL) {
			    port = ntohl(sen->s_port);
			} else {
			    fprintf(stderr, "Unknown service: %s\n", ptr);
			    exit(1);
			}
		    } 
		    NetPort = port;
		}
                break;
            case 'H':
                if (*ptr == 0)
                    ptr = av[++i];
                if (strtol(ptr, NULL, 0) > 0) {
                    NewsBindHost.s_addr = inet_addr(ptr);
                } else {
                    struct hostent *he;

                    if ((he = gethostbyname(ptr)) != NULL) {
                        NewsBindHost = *(struct in_addr *)he->h_addr;
                    } else {
                        fprintf(stderr, "Unknown host for bindhost option: %s\n"
, ptr);
                        exit(1);
                    }
                }
                break;
            case 'T':
                TxBufSize = strtol(((*ptr) ? ptr : av[++i]), NULL, 0);
                if (RxBufSize < 4096)
                    RxBufSize = 4096;
                break;
            case 'R':
                RxBufSize = strtol(((*ptr) ? ptr : av[++i]), NULL, 0);
                if (RxBufSize < 4096)
                    RxBufSize = 4096;
                break;
	    case 'd':
                --ptr;
                while (*ptr == 'd') {
                    ++DebugOpt;
                    ++ptr;
                }
                break;

	    default:
		break;
	    }
	}
    }

    /*
     * Make bindings
     */

    {
	int fd;

        if ((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
            perror("socket");
            exit(1);
        }               
        sin.sin_addr = NewsBindHost;
        sin.sin_port = htons(FeedInPort);
        {       
            int on = 1;
            setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, (void *)&on, sizeof(on));
            setsockopt(fd, SOL_SOCKET, SO_KEEPALIVE, (void *)&on, sizeof(on));
        }
        if (TxBufSize) {
            setsockopt(fd, SOL_SOCKET, SO_SNDBUF, (void *)&TxBufSize, sizeof(in
t));            
        }           
        if (RxBufSize) {
            setsockopt(fd, SOL_SOCKET, SO_RCVBUF, (void *)&RxBufSize, sizeof(in
t));                    
        }
        if (bind(fd, (struct sockaddr *)&sin, sizeof(sin)) < 0) { 
            perror("bind/feedin-port");
            exit(1);    
        }
                
        fcntl(fd, F_SETFL, O_NONBLOCK);
            
        if (listen(fd, 10) < 0) {
            perror("listen/feedin-port");
            exit(1);
        }           
	lfd = fd;
    }

    /*
     * Detach
     */

    if (DebugOpt == 0) {
        pid_t pid = fork();

        if (pid < 0) {
            perror("fork");
            exit(1);
        }
        if (pid > 0) {
            exit(0);
        }

        /*
         * Child continues
         */

        freopen("/dev/null", "w", stdout);
        freopen("/dev/null", "w", stderr);
        freopen("/dev/null", "r", stdin);
        {
            int fd = open("/dev/tty", O_RDWR);
            if (fd >= 0) {
                ioctl(fd, TIOCNOTTY, 0);
                close(fd);
            }
        }
#if USE_SYSV_SETPGRP
        setpgrp();
#else
        setpgrp(0, 0);
#endif
    }

    RunMaster(lfd);
}

