/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1995-1998.  The Regents of the University of California.  All     */
/*   rights reserved.                                                      */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XDIR shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XDIR for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <sys/param.h>
#include <Xm/Xm.h>
#include "xdir.h"
#include "resources.h"

#define MAXRECT 32

extern Display *display;
extern GC gcv1;
extern GC gcv2;
extern GC gcf1;
extern GC gcf2;
extern Pixmap exec12_pixmap;
extern Pixmap file12_pixmap;
extern Pixmap folder12_pixmap;
extern Pixmap link12_pixmap;
extern Pixmap socket12_pixmap;
extern Pixmap unknown12_pixmap;
extern Pixmap exec12_inv_pixmap;
extern Pixmap file12_inv_pixmap;
extern Pixmap folder12_inv_pixmap;
extern Pixmap link12_inv_pixmap;
extern Pixmap socket12_inv_pixmap;
extern Pixmap unknown12_inv_pixmap;
extern Pixmap hidedir12_pixmap;
extern Pixmap viewdir12_pixmap;
extern AppData app_data;
extern int safe_to_redraw;


/*
 * redraw_dir - Redraw portion of drawing area.  Set "clear_first" to True
 *              if redrawn portion should first be cleared.  "clip_rects"
 *              is an array of rectangles used for clipping the region to
 *              be drawn.  "clip_rects" is unused if "nclip_rects" is zero.
 */
void
redraw_dir(dirwin, x, y, width, height, clear_first, clip_rects, nclip_rects)
struct dirwin_st *dirwin;
int x;
int y;
int width;
int height;
int clear_first;
XRectangle clip_rects[];
int nclip_rects;
{
	int start_col;
	int end_col;
	int start_row;
	int end_row;
	int col;
	int row;
	int nrows;
	int last_visible_row;

	/* First clear area */
	if (clear_first)
		XClearArea(display, XtWindow(dirwin->w_drawingArea),
			actual_x(dirwin, x), actual_y(dirwin, y), width, height, False);

	/* Determine which rows to redraw */
	start_row = y/(dirwin->entry_height+VSPACING);
	if (start_row < dirwin->first_visible_row)
		start_row = dirwin->first_visible_row;
	end_row = (y+height)/(dirwin->entry_height+VSPACING);
	last_visible_row = dirwin->first_visible_row+dirwin->nrows_visible-1;
	end_row = MIN(end_row, last_visible_row);
	if (start_row > end_row)
		return;

	/* Apply clip rectangles to the GCs */
	if (nclip_rects) {
		XSetClipRectangles(display, gcv1, 0, 0, clip_rects, nclip_rects,
			Unsorted);
		XCopyGC(display, gcv1, (GCClipMask|GCClipXOrigin|GCClipYOrigin), gcv2);
		XCopyGC(display, gcv1, (GCClipMask|GCClipXOrigin|GCClipYOrigin), gcf1);
		XCopyGC(display, gcv1, (GCClipMask|GCClipXOrigin|GCClipYOrigin), gcf2);
	}

	/* Redraw entries */
	switch (dirwin->layout) {
	case TABULAR:
	case ICONIC:
		nrows = dirwin->nrows;
		if (end_row >= nrows)
			end_row = nrows-1;
		start_col = (x-HMARGIN)/(dirwin->max_entry_width+HSPACING);
		if (start_col < 0)
			start_col = 0;
		end_col = (x-HMARGIN+width)/(dirwin->max_entry_width+HSPACING);
		if (end_col >= dirwin->ncols)
			end_col = dirwin->ncols-1;
		for (col=start_col; col<=end_col; col++)
			for (row=start_row; row<=end_row; row++) {
				if (col*nrows+row >= dirwin->nentries)
					break;
				draw_entry(&dirwin->entries[col*nrows+row]);
			}
		break;
	case FULL_INFO:
	case TREE:
		nrows = dirwin->nentries;
		if (end_row >= nrows)
			end_row = nrows-1;
		for (row=start_row; row<=end_row; row++)
			draw_entry(&dirwin->entries[row]);
	}

	/* Get rid of clip masks */
	if (nclip_rects) {
		XSetClipMask(display, gcv1, None);
		XSetClipMask(display, gcv2, None);
		XSetClipMask(display, gcf1, None);
		XSetClipMask(display, gcf2, None);
	}
}


void
HandleExposeEvents(widget, client_data, event, continue_to_dispatch_return)
Widget widget;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch_return;
{
	static XRectangle rect[MAXRECT];
	static nrects = 0;
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;
	int x;
	int y;
	Dimension drawing_area_width;
	Dimension drawing_area_height;
	int event_x;
	int event_y;
	int event_width;
	int event_height;
	int event_count;

	/* Make sure that the data structures are consistent */
	if (!safe_to_redraw)
		return;

	/* Handle both Expose and GraphicsExpose events */
	if (event->type == Expose) {
		event_x = event->xexpose.x;
		event_y = event->xexpose.y;
		event_width = event->xexpose.width;
		event_height = event->xexpose.height;
		event_count = event->xexpose.count;
	} else if (event->type == GraphicsExpose) {
		event_x = event->xgraphicsexpose.x;
		event_y = event->xgraphicsexpose.y;
		event_width = event->xgraphicsexpose.width;
		event_height = event->xgraphicsexpose.height;
		event_count = event->xgraphicsexpose.count;
	} else
		return;

	/* Accumulate all expose rectangles of a series */
	if (nrects < MAXRECT) {
		rect[nrects].x = event_x;
		rect[nrects].y = event_y;
		rect[nrects].width = event_width;
		rect[nrects].height = event_height;
	}
	nrects++;

	/* If end of series, redraw display */
	if (event_count == 0) {
		XtVaGetValues(dirwin->w_drawingArea,
			XmNwidth,   &drawing_area_width,
			XmNheight,  &drawing_area_height,
			NULL
		);
		x = virtual_x(dirwin, 0);
		y = virtual_y(dirwin, 0);
		if (nrects <= MAXRECT)
			redraw_dir(dirwin, x, y, drawing_area_width, drawing_area_height,
				False, rect, nrects);
		else
			redraw_dir(dirwin, x, y, drawing_area_width, drawing_area_height,
				False, NULL, 0);
		nrects = 0;
	}
}


/*
 * draw_entry - Draw the entry in the drawing area.  If the entry is
 *              flagged as "selected" it is displayed in inverse video.
 */
draw_entry(einfo)
struct entry_info *einfo;
{
	struct dirwin_st *dirwin = einfo->dirwin;
	Window window = XtWindow(dirwin->w_drawingArea);
	int x;
	int y;
	Pixmap icon_pixmap;
	Pixmap icon_inv_pixmap;
	Pixmap pixmap;
	int col = einfo->indx/dirwin->nrows;
	int row = einfo->indx%dirwin->nrows;

	/* Select pixmaps for icons */
	if (dirwin->layout == ICONIC || dirwin->layout == TREE)
		switch (einfo->type) {
		case UNKNOWN_TYPE:
			icon_pixmap = unknown12_pixmap;
			icon_inv_pixmap = unknown12_inv_pixmap;
			break;
		case DIRECTORY_TYPE:
			icon_pixmap = folder12_pixmap;
			icon_inv_pixmap = folder12_inv_pixmap;
			break;
		case FILE_TYPE:
			icon_pixmap = file12_pixmap;
			icon_inv_pixmap = file12_inv_pixmap;
			break;
		case LINK_TYPE:
			icon_pixmap = link12_pixmap;
			icon_inv_pixmap = link12_inv_pixmap;
			break;
		case SOCKET_TYPE:
			icon_pixmap = socket12_pixmap;
			icon_inv_pixmap = socket12_inv_pixmap;
			break;
		case EXECUTABLE_TYPE:
			icon_pixmap = exec12_pixmap;
			icon_inv_pixmap = exec12_inv_pixmap;
			break;
		}

	switch (dirwin->layout) {
	case TABULAR:
		x = actual_x(dirwin,
			HMARGIN+col*(dirwin->max_entry_width+HSPACING));
		y = actual_y(dirwin, row*(dirwin->entry_height+VSPACING));
	    if (einfo->state == UNSELECTED) {
			XFillRectangle(display, window, gcv2, x, y, einfo->width,
				dirwin->entry_height);
   	 		XDrawString(display, window, gcv1, x+TMARGIN,
				y+app_data.variable_width_layout_font->ascent+TMARGIN,
				einfo->name, strlen(einfo->name));
		} else {
			XFillRectangle(display, window, gcv1, x, y, einfo->width,
				dirwin->entry_height);
   	 		XDrawString(display, window, gcv2, x+TMARGIN,
				y+app_data.variable_width_layout_font->ascent+TMARGIN,
				einfo->name, strlen(einfo->name));
		}
		break;
	case ICONIC:
		x = actual_x(dirwin,
			HMARGIN+col*(dirwin->max_entry_width+HSPACING));
		y = actual_y(dirwin, row*(dirwin->entry_height+VSPACING));
	    if (einfo->state == UNSELECTED) {
			XFillRectangle(display, window, gcv2, x, y, einfo->width,
				dirwin->entry_height);
			XCopyArea(display, icon_pixmap, window, gcv1, 0, 0, IWIDTH, IHEIGHT,
				x+TMARGIN, y+TMARGIN);
   	 		XDrawString(display, window, gcv1, x+TMARGIN+IWIDTH+IMARGIN,
				y+app_data.variable_width_layout_font->ascent+TMARGIN,
				einfo->name, strlen(einfo->name));
		} else {
			XFillRectangle(display, window, gcv1, x, y, einfo->width,
				dirwin->entry_height);
			XCopyArea(display, icon_inv_pixmap, window, gcv2, 0, 0, IWIDTH,
				IHEIGHT, x+TMARGIN, y+TMARGIN);
   	 		XDrawString(display, window, gcv2, x+TMARGIN+IWIDTH+IMARGIN,
				y+app_data.variable_width_layout_font->ascent+TMARGIN,
				einfo->name, strlen(einfo->name));
		}
		break;
	case TREE:
		x = actual_x(dirwin, HMARGIN);
		y = actual_y(dirwin, row*(dirwin->entry_height+VSPACING));
		XFillRectangle(display, window, gcv2, x, y,
			einfo->level*INDENT+CWIDTH+CMARGIN, dirwin->entry_height);
		if (einfo->type == DIRECTORY_TYPE) {
			x = actual_x(dirwin, HMARGIN+einfo->level*INDENT);
			if (einfo->expanded)
				pixmap = hidedir12_pixmap;
			else
				pixmap = viewdir12_pixmap;
			XCopyArea(display, pixmap, window, gcv1, 0, 0, CWIDTH, CHEIGHT,
				x, y);
		}
		x = actual_x(dirwin, HMARGIN+CWIDTH+CMARGIN+einfo->level*INDENT);
	    if (einfo->state == UNSELECTED) {
			XFillRectangle(display, window, gcv2, x, y, einfo->width,
				dirwin->entry_height);
   			XCopyArea(display, icon_pixmap, window, gcv1, 0, 0, IWIDTH, IHEIGHT,
				x+TMARGIN, y+TMARGIN);
   	 		XDrawString(display, window, gcv1, x+TMARGIN+IWIDTH+IMARGIN,
				y+app_data.variable_width_layout_font->ascent+TMARGIN,
				einfo->name, strlen(einfo->name));
		} else {
			XFillRectangle(display, window, gcv1, x, y, einfo->width,
				dirwin->entry_height);
			XCopyArea(display, icon_inv_pixmap, window, gcv2, 0, 0, IWIDTH,
				IHEIGHT, x+TMARGIN, y+TMARGIN);
   	 		XDrawString(display, window, gcv2, x+TMARGIN+IWIDTH+IMARGIN,
				y+app_data.variable_width_layout_font->ascent+TMARGIN,
				einfo->name, strlen(einfo->name));
		}
		break;
	case FULL_INFO:
		x = actual_x(dirwin, HMARGIN);
		y = actual_y(dirwin, row*(dirwin->entry_height+VSPACING));
	    if (einfo->state == UNSELECTED) {
			XFillRectangle(display, window, gcf2, x, y, einfo->width,
				dirwin->entry_height);
   	 		XDrawString(display, window, gcf1, x+TMARGIN,
				y+app_data.fixed_width_layout_font->ascent+TMARGIN,
				einfo->info, strlen(einfo->info));
		} else {
			XFillRectangle(display, window, gcf1, x, y, einfo->width,
				dirwin->entry_height);
   	 		XDrawString(display, window, gcf2, x+TMARGIN,
				y+app_data.fixed_width_layout_font->ascent+TMARGIN,
				einfo->info, strlen(einfo->info));
		}
		break;
	}
}


/*
 * redraw_entire_dir - Redraw entire visible portion of drawing area of
 *                     specified directory window.
 */
redraw_entire_dir(dirwin)
struct dirwin_st *dirwin;
{
	Dimension drawing_area_width;
	Dimension drawing_area_height;
	int x;
	int y;

	XtVaGetValues(dirwin->w_drawingArea,
		XmNwidth,	&drawing_area_width,
		XmNheight,	&drawing_area_height,
		NULL
	);
	x = virtual_x(dirwin, 0);
	y = virtual_y(dirwin, 0);
	redraw_dir(dirwin, x, y, drawing_area_width, drawing_area_height, True,
		NULL, 0);
}


/*
 * redraw_dir_rows - Redraw visible portion of drawing area of specified
 *                   directory window starting at specified virtual row.
 */
redraw_dir_rows(dirwin, starting_row)
struct dirwin_st *dirwin;
int starting_row;
{
	Dimension drawing_area_width;
	Dimension drawing_area_height;
	int x;
	int y;
	int height;
	int width;

	XtVaGetValues(dirwin->w_drawingArea,
		XmNwidth,	&drawing_area_width,
		XmNheight,	&drawing_area_height,
		NULL
	);

	x = virtual_x(dirwin, 0);
	y = starting_row*(dirwin->entry_height+VSPACING);
	width = drawing_area_width;
	height = virtual_y(dirwin, drawing_area_height)-y;
	redraw_dir(dirwin, x, y, width, height, True, NULL, 0);
}

