/*
** This is the header file for qpage.  It should not necessary to change
** any of these defines.  All customizations should be made either in
** the Makefile or in the run-time configuration file.
*/
#include	<stdio.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/stat.h>
#include	<sys/time.h>
#include	<sys/utsname.h>
#include	<time.h>
#include	<ctype.h>
#include	<errno.h>
#include	<termios.h>
#include	<fcntl.h>
#include	<string.h>
#include	<signal.h>
#include	<dirent.h>
#include	<sys/wait.h>
#include	<stdarg.h>
#include	<pwd.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>
#include	<netdb.h>


#ifndef CLIENT_ONLY
#include	<syslog.h>
#include	<setjmp.h>
#endif


/*
** Solaris 2.x specific includes
*/
#ifdef SOLARIS
#include	<sys/mkdev.h>
#include	<sys/systeminfo.h>
#endif


/*
** AIX specific includes (I can't verify these but people tell me
** they are required).
*/
#ifdef _AIX
#include	<sys/select.h>
#include	<sys/ioctl.h>
#endif


/*
** HP-UX 10 includes (I can't verify these but people tell me
** they are required).
*/
#ifdef HPUX10
#include	<sys/modem.h>
#endif


/*
** tell lint to shut up
*/
#ifdef lint
#define		printf			(void)printf
#define		fprintf			(void)fprintf
#endif

#define		VERSION			"3.2"
#define		COMMENTS_ANYWHERE

#ifndef		SYSTEM_CONFIG
#define		SYSTEM_CONFIG		"/etc/qpage.cf"
#endif

#ifndef		LOCKDIR
#ifdef		_AIX
#define		LOCKDIR			"/etc/locks"
#else
#define		LOCKDIR			"/var/spool/locks"
#endif
#endif

#ifndef		_PATH_SENDMAIL
#define		_PATH_SENDMAIL		"/usr/lib/sendmail"
#endif

#ifdef		NEED_STRERROR
extern char	*sys_errlist[];
#define		strerror(x)		sys_errlist[x]
#endif

#ifndef		SNPP_SERVER
#define		SNPP_SERVER		"localhost"
#endif

#ifndef		FACILITY
#define		FACILITY		LOG_DAEMON
#endif

#ifndef		DAEMONUSER
#define		DAEMONUSER		1
#endif

#define		SNPP_SVC_NAME		"snpp"
#define		SNPP_SVC_PORT		444

#define		MAXBADCOMMANDS		10
#define		BUFCHUNKSIZE		1024

#define		DEFAULT_LEVEL		1
#define		DEFAULT_IDENTTIMEOUT	10
#define		DEFAULT_SNPPTIMEOUT	60

#define		DEFAULT_PASSWORD	""
#define		DEFAULT_BAUDRATE	B300
#define		DEFAULT_MAXMSGSIZE	80
#define		DEFAULT_MAXPAGES	9
#define		DEFAULT_MAXTRIES	6

#define		LEVEL_SENDMAIL		0

#define		F_SENT			0x0001 /* msg sent successfully */
#define		F_FAILED		0x0002 /* msg failed */
#define		F_BUSY			0x0004 /* modem got BUSY */
#define		F_NOCARRIER		0x0008 /* modem got NO CARRIER */
#define		F_NOMODEM		0x0010 /* modem was unavailable */
#define		F_FORCED		0x0020 /* remote sent <RS> */
#define		F_NOPROMPT		0x0040 /* didn't find ID= prompt */
#define		F_UNKNOWN		0x0080 /* unknown error */
#define		F_REJECT		0x0100 /* page rejected by service */
#define		F_RAWPID		0x0200 /* user specified a PID */
#define		F_SENDMAIL		0x0400 /* send mail to sender */
#define		F_SENTMAIL		0x0800 /* sent mail to sender */
#define		F_SENTADMIN		0x1000 /* sent mail to administrator */

#define		CALLSTATUSFLAGS		0x01ff /* per-call status flags */

#define		CHAR_STX		'\002'
#define		CHAR_ETX		'\003'

#ifndef		TRUE
#define		TRUE			1
#endif
#ifndef		FALSE
#define		FALSE			0
#endif

#define		INVALID_TIME		((time_t)-1)


struct service {
	struct service		*next;		/* next node in the list */
	char			*name;		/* name of the service */
	char			*device;	/* where the modem is */
	char			*dialcmd;	/* modem dial command */
	char			*password;	/* service password */
	int			baudrate;	/* modem speed */
	int			parity;		/* modem parity */
	int			maxmsgsize;	/* max length of a page */
	int			maxpages;	/* max segments per page */
	int			maxtries;	/* max tries per page */
	int			identfrom;	/* who page is from */
	int			allowpid;	/* page must be in qpage.cf? */ 
	int			flags;		/* not used at this time */
};
typedef struct service service_t;


struct pager {
	struct pager		*next;
	char			*name;
	char			*pagerid;
	service_t		*service;
	int			flags;
};
typedef struct pager pager_t;


struct member {
	struct member		*next;
	pager_t			*pager;
	char			*schedule;
	int			flags;
};
typedef struct member member_t;


struct pgroup {
	struct pgroup		*next;
	char			*name;
	member_t		*members;
	int			flags;
};
typedef struct pgroup pgroup_t;


struct rcpt {
	struct rcpt		*next;
	char			*pager;
	char			*coverage;
	time_t			holduntil;
	time_t			lasttry;
	int			goodtries;
	int			tries;
	int			level;
	int			flags;
};
typedef struct rcpt rcpt_t;


typedef struct page {
	struct page		*next;
	FILE			*peer;
	char			*filename;
	rcpt_t			*rcpts;
	time_t			created;
	char			*message;
	char			*messageid;
	char			*auth;
	char			*ident;
	char			*from;
	char			*hostname;
	char			*status;
	int			flags;
} PAGE;


struct job {
	struct job		*next;
	PAGE			*p;
	rcpt_t			*rcpt;
	service_t		*service;
	pager_t			*pager;
};
typedef struct job job_t;


struct msgtext {
	struct msgtext		*next;
	char			*data;
};
typedef struct msgtext msgtext_t;


/*
** global variables
*/
extern int		Debug;
extern int		Interactive;
extern int		IdentTimeout;
extern int		SNPPTimeout;
extern char		*ConfigFile;
extern char		*Administrator;
extern char		*ForceHostname;
extern service_t	*Services;
extern pager_t		*Pagers;
extern pgroup_t		*Groups;

#ifndef CLIENT_ONLY
extern jmp_buf		TimeoutEnv;
#endif

/*
** misc functions
*/
extern void		*lookup(void *list, char *name);
extern void		*my_realloc(void *ptr, int len);
extern void		clear_page(PAGE *p, int save);
extern void		send_pages(job_t *jobs);
extern void		read_mail(PAGE *p);
extern void		qpage_log(int pri, char *fmt, ...);
extern time_t		snpptime(char *arg);
extern time_t		parse_time(char *str);
extern int		become_daemon(int sleeptime, short port);
extern int		submit_page(PAGE *p, char *server);
extern int		lock_file(int fd, int mode, int block);
extern int		lock_queue(void);
extern int		read_config_file(void);
extern int		write_page(PAGE *p);
extern int		runqueue(void);
extern int		insert_jobs(job_t **joblist, PAGE *p);
extern int		lock_modem(char *device);
extern void		unlock_modem(char *device);
extern char		*ident(int peer);
extern char		*getinput(FILE *fp, int oneline);
extern char		*get_user(void);
extern char		*safe_string(char *str);
extern int		on_duty(char *schedule, time_t when);
extern int		showqueue(void);
extern char		*my_ctime(time_t *clock);
extern char		*msgcpy(char *dst, char *src, int len);
extern void		get_sysinfo(void);
extern void		notify_submitter(PAGE *p);
extern void		notify_administrator(PAGE *p);
extern void		newmsgid(char *buff);

/*
** signal handlers
*/
extern void		sigalrm(void);
extern void		sigchld(void);
extern void		sigterm(void);
extern void		sigusr1(void);
