/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 ipvr stuttgart and thomas harrer
** -------------------------------------------------------------------- *
**
**  libhelp
**
**  a comprehensive hypertext help system for OSF/Motif(tm) applications. 
**  based on libhtmlw from NCSA Mosaic(tm) version 2.4
**
**  written by thomas harrer
**  e-mail: Thomas.Harrer@rus.uni-stuttgart.de
**  
** -------------------------------------------------------------------- *
*h  $Id: buffer.h,v 1.11 1995/06/28 12:59:30 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		buffer.h
**
**  contents:		abstract data type buffer
**			methods: create, destroy buffers
**			add text and get the text.
**
**  interface:		#include buffer.h
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
#ifndef _BUFFER_H_
#define _BUFFER_H_ 1

/* for FILE*  */
#include <stdio.h>

/* object: buffer with enlargement.  */
typedef struct _buffer_s buffer_t;

/* has these methods:  */
/* -------------------------------------------------------------------- *
*p  procedure-name:	bf_new
**
**  purpose:		returns a newly allocated and initialized 
**			buffer structure.
** -------------------------------------------------------------------- */
buffer_t*
bf_new (void);

/* -------------------------------------------------------------------- *
*p  procedure-name:	bf_clone
**
**  purpose:		return the same buffer with just incremented 
**			reference count. it is like a hard link for 
**			files.
**  note:		cloned buffers should not be accessed for writing
**			by different tasks. the result can be somewhat
**			ugly.
** -------------------------------------------------------------------- */
buffer_t*
bf_clone (/* io */ buffer_t* buf);

/* -------------------------------------------------------------------- *
*p  procedure-name:	bf_free
**
**  purpose:		drestroys the buffer
** -------------------------------------------------------------------- */
int
bf_free (/* i  */ buffer_t*	buf);

/* -------------------------------------------------------------------- *
*p  procedure-name:	bf_the_buffer
**
**  purpose:		returns the text pointer of the buffer, or NULL
**			if there is no text.
** -------------------------------------------------------------------- */
char*
bf_the_buffer (/* i  */ buffer_t* buf);

/* -------------------------------------------------------------------- *
*p  procedure-name:	bf_strcat
**
**  purpose:		adds text to the buffer.
** -------------------------------------------------------------------- */
int
bf_strcat (/* io */ buffer_t*	buf,
	   /* i  */ char*	text);

/* -------------------------------------------------------------------- *
*p  procedure-name:	bf_strcpy
**
**  purpose:		starts text in an already existent buffer.
** -------------------------------------------------------------------- */
int
bf_strcpy (/* i  */ buffer_t*	buf,
	   /* i  */ char*	text);

/* -------------------------------------------------------------------- *
*p  procedure-name:	bf_sprint
**
**  purpose:		adds text to the buffer (but with arguments like
**			sprintf).
** -------------------------------------------------------------------- *
**  caveat:		the resulting string must not be larger than
**			PAGE_SIZE bytes (4k default).
**			i found no way to make vsprintf save (unless 
**			there is no vsnprint or vasprintf :(). i could't 
**			find these on much systems.
** -------------------------------------------------------------------- */
int
bf_sprint (/* io */ buffer_t* 	buf, 
	   /* i  */ char* 	format_template,
	   /* i  */ char* 	string);

/* -------------------------------------------------------------------- *
*p  procedure-name:	bf_dprint
**
**  purpose:		adds text to the buffer (but with arguments like
**			sprintf with one decimal arg.).
** -------------------------------------------------------------------- *
**  caveat:		the resulting string must not be larger than
**			PAGE_SIZE bytes (4k default).
**			i found no way to make vsprintf save (unless 
**			there is no vsnprint or vasprintf :(). i could't 
**			find these on much systems.
** -------------------------------------------------------------------- */
int
bf_dprint (/* io */ buffer_t* 	buf, 
	   /* i  */ char* 	format_template,
	   /* i  */ int		value);

/* -------------------------------------------------------------------- *
*p  procedure-name:	bf_fread
**
**  purpose:		adds the contents of file into buffer
** -------------------------------------------------------------------- */
int
bf_fread (/* i  */ buffer_t*	buf,
	  /* i  */ FILE*	stream);

/* and small statistics functions.  */
int		bf_memory_usage (void);
int		bf_buffer_usage (void);
int		bf_memory_filled (void);
int		bf_page_size (void);

/* return values  */
#define BF_sorry -1
#define BF_is_binary -2

#endif /* !_BUFFER_H_ */
/* -------------------------------------------------------------------- *
*l  emacs:
**  local variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  end:
** -------------------------------------------------------------------- */
