/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/kernel/sources/RCS/cc_learn.ph,v $
  SHORTNAME      : 
  SNNS VERSION   : 4.1

  PURPOSE        : Header file of correspondent '.c' file
  NOTES          :

  AUTHOR         : Michael Schmalzl, Christian Wehrfritz (PCC)
  DATE           : 5.2.1993

  CHANGED BY     : Michael Schmalzl
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 2.5 $
  LAST CHANGE    : $Date: 1995/11/16 12:01:57 $

             Copyright (c) 1990-1995  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/
#ifndef _CC_LEARN_DEFINED_
#define  _CC_LEARN_DEFINED_

/* begin global definition section */
krui_err LEARN_CasCor(int StartPattern, int EndPattern,
                      float *ParameterInArray, int NoOfInParams,
                      float **ParameterOutArray, int *NoOfOutParams);
/* end   global definition section */

/* begin privat definition section */
static float cc_getErr (int StartPattern, int EndPattern);
static void cc_pruneNet(int StartPattern, int EndPattern, int pruneFunc);
static void cc_killLink (int source, int target);

static void cc_calculateSpecialUnitActivation(int startPattern,int endPattern);

static krui_err cc_generateSpecialUnits(int MaxSpecialUnitNo, int OutputXMax,
					int type);

static int  cc_test(int StartPattern,int EndPattern,float maxPixelError); 

static void  cc_propagateNetForward(int PatternNo, int sub_pat_no);

static void  cc_calculateOutputUnitError(int StartPattern,int EndPattern);

static void  cc_QPS_trainNet(int maxNoOfCovarianceUpdateCycles, 
			     float minCovarianceChange, 
                             int specialPatience, int StartPattern,
			     int EndPattern,
                             float param4, float param5, float param6, 
			     int MaxSpecialUnitNo);

static float cc_QPS_propagateNetBackward(int StartPattern, int EndPattern,
					 int counter);
static void  cc_QPS_updateNet(float epsilon,float mu, float decay);

static void  cc_QPO_trainNet(int maxNoOfErrorUpdateCycles,int backfittPatience,
 			     float minErrorChange, int outPatience, 
			     int StartPattern,int EndPattern,
                             float param1, float param2,float param3,
                             float **ParameterOutArray, int *NoOfOutParams);

static float cc_QPO_propagateNetBackward(int PatternNo, int sub_pat_no);

static void  cc_QPO_updateNet(float epsilon, float mu, float decay);

static void  cc_BPS_trainNet(int maxNoOfCovarianceUpdateCycles, 
			     float minCovarianceChange, 
                             int specialPatience,int StartPattern,
			     int EndPattern,
                             float param4, float param5, float param6, 
			     int MaxSpecialUnitNo);

static float cc_BPS_propagateNetBackward(int StartPattern, int endPattern , 
					 int counter, float eta, float mu);

static void  cc_BPO_trainNet(int maxNoOfErrorUpdateCycles,int backfittPatience,
			     float minErrorChange, 
                             int outPatience, int StartPattern,int EndPattern,
                             float param1, float param2,float param3,
                             float **ParameterOutArray,int *NoOfOutParams);

static float cc_BPO_propagateNetBackward(int PatternNo, int sub_pat_no, 
					 float eta, float mu, float fse);

static void  cc_RPS_trainNet(int maxNoOfCovarianceUpdateCycles, 
			     float minCovarianceChange, int specialPatience,
			     int StartPattern,int EndPattern,
                             float param4, float param5, float param6, 
			     int MaxSpecialUnitNo);

static float cc_RPS_propagateNetBackward(int StartPattern, int EndPattern,
					 int counter);

static void  cc_RPS_updateNet(float epsilon, float mu, float decay);

static void  cc_RPO_trainNet(int maxNoOfErrorUpdateCycles,int backfittPatience,
 			     float minErrorChange, 
                             int outPatience, int StartPattern,int EndPattern,
                             float param1, float param2,float param3,
                             float **ParameterOutArray,int *NoOfOutParams);

static float cc_RPO_propagateNetBackward(int PatternNo, int sub_pat_no);

static void  cc_RPO_updateNet(float epsilon, float mu, float decay);

static krui_err cc_generateHiddenUnit(int maxYPosOfHiddenUnit,
				      int *xPosOfLastInsertedHiddenUnit,
                                      int *yPosOfLastInsertedHiddenUnit);


/* end privat definition section */


#endif /* _CC_LEARN_DEFINED_ */
