.TH contract_edge 1 "September 1996" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
contract_edge - contracts edges between two nodes
.SH CALLING SEQUENCE
.nf
g1 = contract_edge(i,j,g)
.fi
.SH PARAMETERS
.TP 2
i
: integer, number of start or end node of edge
.TP 2
j
: integer, number of end or start node of edge
.TP 2
g
: graph list
.TP 3
g1
: graph list of the new graph 
.SH DESCRIPTION
\fVcontract_edge\fR returns the graph \fVg1\fR, the edges between the nodes
number \fVi\fR and \fVj\fR being deleted, the nodes being reduced to one
node with the same name as node \fVi\fR and located at the middle point 
between the 2 previous nodes.
.SH EXAMPLE
.nf
ta=[1 1 2 2 2 3 4 5 5 7 8 8 9 10 10 10 10 10 11 12 13 13 13 14 15 16 16 17 17];
he=[2 10 3 5 7 4 2 4 6 8 6 9 7 7 11 13 13 15 12 13 9 10 14 11 16 1 17 14 15];
g=make_graph('foo',1,17,ta,he);
g('node_x')=[283 163 63 57 164 164 273 271 339 384 504 513 439 623 631 757 642];
g('node_y')=[59 133 223 318 227 319 221 324 432 141 209 319 428 443 187 151 301];
show_graph(g);
g1=contract_edge(10,13,g);
show_graph(g1,'new');
.fi
.SH SEE ALSO
add_edge, add_node, delete_arcs, delete_nodes
