.TH cumprod 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
cumprod - cumulative product
.SH CALLING SEQUENCE
.nf
y=cumprod(x)
y=cumprod(x,'r') or y=cumprod(x,1) 
y=cumprod(x,'c') or y=cumprod(x,2) 
.fi
.SH PARAMETERS
.TP 10
x
: vector or matrix (real or complex)
.TP 10
y
: vector or matrix (real or complex)
.SH DESCRIPTION
For a vector or a matrix \fVx\fR, \fVy=cumprod(x)\fR  returns in \fVy\fR the cumulative product of all the 
entries of \fVx\fR taken columnwise. 
.LP
\fVy=cumprod(x,'c')\fR (or, equivalently, \fVy=cumprod(x,2)\fR) returns in 
\fVy\fR the cumulative elementwise product of the columns of \fVx\fR: \fV y(i,:)=cumprod(x(i,:))\fR
.LP
\fVy=cumprod(x,'r')\fR (or, equivalently, \fVy=cumprod(x,2)\fR)
returns in \fVy\fR the cumulative elementwise product of the rows of \fVx\fR: \fV y(:,i)=cumprod(x(:,i))\fR.
.SH EXAMPLE
.nf
A=[1,2;3,4];
cumprod(A)
cumprod(A,'r')
cumprod(A,'c')
rand('seed',0);
a=rand(3,4);
[m,n]=size(a);
w=zeros(a);
w(1,:)=a(1,:);
for k=2:m;w(k,:)=w(k-1,:).*a(k,:);end;w-cumprod(a,'r')
.fi
.SH SEE ALSO
cumprod, sum

