.TH gbruit 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
noisegen - noise generation 
.SH CALLING SEQUENCE
.nf
[]=noisegen(pas,Tmax,sig)
.fi 
.SH DESCRIPTION
generates a Scilab function \fV[b]=Noise(t)\fR
where \fVNoise(t)\fR is a piecewise constant function 
( constant on  \fV[k*pas,(k+1)*pas]\fR ). The value on each constant 
interval are random values from  i.i.d  Gaussian variables of 
standard deviation sig. The function is constant for \fVt<=0\fR and 
\fVt>=Tmax\fR.
.SH EXAMPLE
.nf
noisegen(0.5,30,1.0);
x=-5:0.01:35;
y=feval(x,Noise);
plot(x,y);
.fi
