/* ../options.h.  Generated automatically by configure.  */
/* --------------------------------------------------------------------------
 * Configuration options
 *
 * Copyright (c) The University of Nottingham and Yale University, 1994-1997.
 * All rights reserved. See NOTICE for details and conditions of use etc...
 * Hugs version 1.4, December 1997
 *
 * $RCSfile: options.h,v $
 * $Revision: 1.33 $
 * $Date: 1998/01/12 17:21:03 $
 * ------------------------------------------------------------------------*/

/* --------------------------------------------------------------------------
 * Version number
 * ------------------------------------------------------------------------*/

/* Define this as a string (up to 13 characters) uniquely identifying the 
 * current version.
 * Major releases from Nottingham/Yale are of the form "<month> <year>"
 * Minor releases from Nottingham/Yale are of the form "Version YYMMDD"
 * Anyone else should use a different format to avoid confusion.    
 */
#define MAJOR_RELEASE 1

#if MAJOR_RELEASE
#define HUGS_VERSION "January 1998"
#else
#define HUGS_VERSION "Version 980112"
#endif

/* --------------------------------------------------------------------------
 * Hugs paths and directories
 * ------------------------------------------------------------------------*/

/* Define this as the default setting of HUGSPATH.                        
 * Value may contain string "{Hugs}" (for which we will substitute the
 * value of HUGSDIR) and should be either colon-separated (Unix)
 * or semicolon-separated (Macintosh, Windows, DOS).  Escape
 * characters in the path string are interpreted according to normal
 * Haskell conventions.
 *
 * This value can be overridden from the command line by setting the
 * HUGSFLAGS environment variable or by storing an appropriate value
 * for HUGSFLAGS in the registry (Win32 only).  In all cases, use a 
 * string of the form -P"...".  
 */
#define HUGSPATH "{Hugs}\\lib;{Hugs}\\lib\\hugs;{Hugs}\\lib\\exts;{Hugs}\\lib\\win32"

/* The directory name which is substituted for the string "{Hugs}"
 * in a path variable.  This normally points to where the Hugs libraries
 * are installed - ie so that the file HUGSDIR/lib/Prelude.hs exists    
 * Typical values are:                                  
 *    "/usr/local/lib/hugs"                             
 *    "/usr/homes/JFHaskell/hugs"                       
 *    ".."      
 *
 * This value is ignored on Windows and Macintosh versions since
 * it is assumed that the binary is installed in HUGSDIR.
 *
 * This value cannot be overridden from the command line or by using 
 * environment variables.  This isn't quite as limiting as you'd think
 * since you can always choose _not_ to use the {Hugs} variable - however,
 * it's obviously _nicer_ to have it set correctly.
 */
#ifndef HUGSDIR
#define HUGSDIR ""
#endif

/* --------------------------------------------------------------------------
 * User interface options
 * ------------------------------------------------------------------------*/

/* Define if you want to use the "Hugs for Windows" GUI.
 * (Windows 3.1 and compatibles only)
 */
#define HUGS_FOR_WINDOWS 1

/* Define if you want filenames to be converted to normal form by:
 * o replacing relative pathnames with absolute pathnames and
 *   eliminating .. and . where possible.
 * o converting to lower case (only in case-insensitive filesystems)
 */
#define PATH_CANONICALIZATION 0

/* Define if a command line editor is available and should be used. 
 * There are two choices of command line editor that can be used with Hugs:
 * GNU readline and editline (from comp.sources.misc, vol 31, issue 71)
 */
#define USE_READLINE 0

/* Define if you want the small startup banner.
 */
#define SMALL_BANNER 0

/* --------------------------------------------------------------------------
 * Making Hugs smaller
 * ------------------------------------------------------------------------*/

/* Define one of these to select overall size of Hugs
 *   SMALL_HUGS     for 16 bit operation on a limited memory PC.
 *   REGULAR_HUGS   for 32 bit operation using largish default table sizes.
 *   LARGE_HUGS     for 32 bit operation using larger default table sizes.
 */
#define SMALL_HUGS   0
#define REGULAR_HUGS 0
#define LARGE_HUGS   1

/* Define if you want to turn off the module system to reduce memory usage.
 * Warning: some of the standard libraries and demo programs require that
 * the module system be enabled.
 */
#define IGNORE_MODULES 0

/* --------------------------------------------------------------------------
 * Fancy features
 * ------------------------------------------------------------------------*/

/* Define if T-REX; Typed Rows and EXtension should be enabled             */
#define TREX 0

/* Define if heap profiling should be used                                 */
#define PROFILING 0

/* Define if you want to use double precision floating point arithmetic    */
#define USE_DOUBLE_PRECISION 0

/* Define if you want to run Haskell code through a preprocessor
 * 
 * Note that there's the import chasing mechanism will not spot any 
 * #includes so you must :load (not :reload) if you change any
 * (non-Haskell) configurations files.
 */
#define USE_PREPROCESSOR 1

/* Define if you want to time every evaluation. 
 *
 * Timing is included in the Hugs distribution for the purpose of benchmarking
 * the Hugs interpreter, comparing its performance across a variety of
 * different machines, and with other systems for similar languages.
 *
 * It would be somewhat foolish to try to use the timings produced in this
 * way for any other purpose.  In particular, using timings to compare the
 * performance of different versions of an algorithm is likely to give very
 * misleading results.  The current implementation of Hugs as an interpreter,
 * without any significant optimizations, means that there are much more
 * significant overheads than can be accounted for by small variations in
 * Hugs code.
 */
/* #undef WANT_TIMER */


/* --------------------------------------------------------------------------
 * Debugging options (intended for use by maintainers)
 * ------------------------------------------------------------------------*/

/* Define if debugging generated bytecodes or the bytecode interpreter     */
#define DEBUG_CODE 0

/* Define if you want to use a low-level printer from within a debugger    */
#define DEBUG_PRINTER 0

/* Define if you want to perform runtime tag-checks as an internal 
 * consistency check.  This makes Hugs run very slowly - but is very
 * effective at detecting and locating subtle bugs.
 */
#define CHECK_TAGS 0


/* --------------------------------------------------------------------------
 * Experimental features
 * These are likely to disappear/change in future versions and should not
 * be used by most people..
 * ------------------------------------------------------------------------*/

/* Define if you want to use the primitives which let you examine Hugs 
 * internals.
 */
#define INTERNAL_PRIMS 0

/* Define if you want to use the primitives which let you examine Hugs
 * bytecodes (requires INTERNAL_PRIMS).
 */
#define BYTECODE_PRIMS 0

/* In a plain Hugs system, most signals (SIGBUS, SIGTERM, etc) indicate
 * some kind of error in Hugs - or maybe a stack overflow.  Rather than
 * just crash, Hugs catches these errors and returns to the main loop.
 * It does this by calling a function "panic" which longjmp's back to the
 * main loop.
 * If you're developing a GreenCard library, this may not be the right
 * behaviour - it's better if Hugs leaves them for your debugger to
 * catch rather than trapping them and "panicing".
 */
#define DONT_PANIC 0

/* If you get really desperate to understand why your Hugs programs keep
 * crashing or running out of stack, you might like to set this flag and
 * recompile Hugs.  When you hit a stack error, it will print out a list
 * of all the objects currently under evaluation.  The information isn't
 * perfect and can be pretty hard to understand but it's better than a
 * poke in the eye with a blunt stick.
 *
 * This is a very experimental feature!
 */
#define GIMME_STACK_DUMPS 0

/* ----------------------------------------------------------------------- */
