-----------------------------------------------------------------------------
-- Trex utilities:  Functions to "show" record values
--
-- Warning: This file is an integral part of the TREX implementation, and
-- should not be modified without corresponding changes in the interpreter.
--
-- Suitable for use with Hugs 1.4, if compiled with TREX support.
-----------------------------------------------------------------------------

module Trex( module Prelude ) where

instance ShowRecRow r => Show (Rec r) where
  showsPrec d = showFields . showRecRow
   where
    showFields   :: [(String, ShowS)] -> ShowS
    showFields [] = showString "EmptyRec"
    showFields xs = showChar '(' . foldr1 comma (map fld xs) . showChar ')'
     where comma a b = a . showString ", " . b
           fld (s,v) = showString s . showChar '=' . v

class ShowRecRow r where
  showRecRow :: Rec r -> [(String, ShowS)]

instance ShowRecRow EmptyRow where
  showRecRow _ = []

insertField       :: String -> ShowS -> [(String, ShowS)] -> [(String, ShowS)]
insertField n v fs = {- case fs of
                       []     -> [(n,v)]
                       (r:rs) -> if n <= fst r
                                   then (n,v):fs
                                   else r : insertField n v rs -}
                     bef ++ [(n,v)] ++ aft
 where (bef,aft) = span (\r -> n > fst r) fs

-----------------------------------------------------------------------------

