module Output where
import Board
import Graphics
--import GraphicsColor
import Array

board_x = 50
board_y = 50

block_x = 30
block_y = 30

shadow_x = 8
shadow_y = 8

exit_x = 10
exit_y = 10
restart_x = 50
restart_y= 10

board_rectangle :: (Int, Int) -> Int -> Int -> Picture
board_rectangle (x,y) w h = polygon [(board_x+x,board_y+y),(board_x+x+w,board_y+y),
                                     (board_x+x+w,board_y+y+h),(board_x+x,board_y+y+h)]

initializeOutput :: Board -> String -> IO Window
initializeOutput b filename = 
            do w <- openWindowEx ("Klotski - " ++ filename) (Just (100,100)) (Just (500,500))
                    drawBufferedPicture Nothing
               return w

display :: Board -> Window -> IO ()
display b win =
              do setPicture win (drawGameObjects b)

drawGameObjects :: Board -> Picture
drawGameObjects b = (overMany
                      [text(exit_x, exit_y) " Exit ",
                       text(restart_x, restart_y) " Restart ",
                       drawBoard b])
                     
drawBoard :: Board -> Picture
drawBoard (Board (w,h) piecelist bm) = 
  mkBrush (RGB 0 0 0) $ \ blackBrush ->
  mkBrush (RGB 200 200 200) $ \ greyBrush ->
  mkBrush (RGB 75 75 75) $ \ targetBrush ->
  mkBrush (RGB 255 0 0) $ \ mainBrush ->
  mkBrush (RGB 255 255 0) $ \ regularBrush ->
  mkBrush (RGB 0 0 255) $ \ staticBrush ->
  mkBrush (RGB 0 255 255) $ \ openingBrush ->
  let
    palette = listArray (Main,Opening) [mainBrush,targetBrush,regularBrush,staticBrush,openingBrush]


    drawPiece :: Piece -> Picture
    drawPiece (Piece typ (x,y) shape@(PieceShape (w, h) blocklist vs)) =
      if length vs > 1
        then
          withBrush (palette!typ) $ polygon (map (convToGameCoord (x,y)) vs)
        else
          empty

    drawPieceShadow :: Piece -> Picture
    drawPieceShadow (Piece typ (x,y) shape@(PieceShape (w, h) blocklist vs)) =
      let
        drawShadow [] = empty
        drawShadow ((x1,y1):(x2,y2):ps) = 
          if x1 > x2
            then
              overMany
                [withBrush greyBrush $ polygon [(x1,y1),(x1+shadow_x,y1+shadow_y),
                                                  (x2+shadow_x,y1+shadow_y),(x2,y1)],
                drawShadow ((x2,y2):ps)]

            else  if y2 > y1
                    then
                      overMany
                        [withBrush blackBrush $ polygon [(x1,y1),(x1+shadow_x,y1+shadow_y),
                                                         (x1+shadow_x,y2+shadow_y),(x1,y2)],
                         drawShadow ((x2,y2):ps)]
                    else
                      drawShadow((x2,y2):ps)
        drawShadow (p:ps) = empty

        vs' = map (convToGameCoord (x,y)) vs
      in
        drawShadow vs'

    drawPieceShadowEnd :: Piece -> Picture
    drawPieceShadowEnd (Piece typ (x,y) shape@(PieceShape (w, h) blocklist vs)) =
      let
        drawShadowEnd [] = empty
        drawShadowEnd ((x1,y1):(x2,y2):ps) = 
          if x1 > x2
            then
              overMany
                [withBrush greyBrush $ polygon [(x2,y1),(x2+shadow_x,y1+shadow_y),
                                                  (x2+shadow_x,y1)],
                 drawShadowEnd ((x2,y2):ps)]

            else  if y2 > y1
                    then
                      overMany
                        [withBrush blackBrush $ polygon [(x1,y1),(x1+shadow_x,y1+shadow_y),
                                                         (x1,y1+shadow_y)],
                         drawShadowEnd ((x2,y2):ps)]
                    else
                      drawShadowEnd((x2,y2):ps)
        drawShadowEnd (p:ps) = empty

        vs' = map (convToGameCoord (x,y)) vs

      in
        drawShadowEnd vs'


    createPieceList :: [Piece] -> [Piece]
    createPieceList [] = []
    createPieceList (x1:x2:xs) = (x1:xs)
    createPieceList (x:xs) = (x:xs)

    piecelist2 = createPieceList piecelist  

  in
    (overMany
       [(overMany (map drawPiece piecelist2)),
        (drawPiece (piecelist!!(fromEnum Target))),
        (overMany (map drawPieceShadowEnd piecelist2)),
        (drawPieceShadowEnd (piecelist!!(fromEnum Target))),
        (overMany (map drawPieceShadow piecelist2)),
        (drawPieceShadow (piecelist!!(fromEnum Target))),
        (withRGB (RGB 100 100 100) $ board_rectangle (block_x,block_y) (block_x*(w-1)) (block_y*(h-1)))])  


convToGameCoord :: Coord -> Coord -> Coord
convToGameCoord (px, py) (x,y) = (board_x+px*block_x+x*block_x, board_x+py*block_y+y*block_y)

convToBoardCoord :: Coord -> IO Coord
convToBoardCoord (x,y) = return ((x-board_x) `div` block_x, (y-board_y) `div` block_y)

getHitButton :: Coord -> IO UserAction
getHitButton (x,y) = if ((x >= exit_x) && (x <= exit_x+30) && (y >= exit_y) && (y <= exit_y+12))
                     then return UA_Exit
                     else 
                     if ((x >= restart_x) && (x <= restart_x+50) && (y >= restart_y) && (y <= restart_y+12))
                     then return UA_Restart
                     else return UA_Nothing

