module PrettyHTML where

{-
Pretty printing HTML (last modified: Friday, March 07, 1997)

Erik Meijer (erik@cs.ruu.nl)
-}

import qualified Pretty
import Mime
import HTML

(<>)  = (Pretty.<>)
nest  = Pretty.nest
sep   = Pretty.sep

instance Show HTML where
   showsPrec _ html = shows (ppHTML html)

instance Read HTML where
   readsPrec _ = error "Reading HTML not yet implemented"

instance Mime HTML where
   mimeType _ = "text/html"

ppHTML Element{tag, attributes, html}
 = ppElement tag attributes html

ppHTML Text{text}
 = Pretty.text text

ppElement tag attributes []
 = ppOpenTag tag attributes <> ppCloseTag tag

ppElement tag attributes html
 =  sep [ ppOpenTag tag attributes
        , nest indent (sep (map ppHTML html))
        , ppCloseTag tag
        ]

ppOpenTag tag attributes
 = case (ppAttributes attributes) of
      [] -> Pretty.text "<" <> Pretty.text tag <> Pretty.text ">"
      as -> sep [ Pretty.text "<" <> Pretty.text tag
                , nest indent (sep as)
                , Pretty.text ">"
                ]

ppCloseTag tag
 = Pretty.text "</" <> Pretty.text tag <> Pretty.text ">"

ppAttributes as
 = [ Pretty.text name <> Pretty.text "=" <> Pretty.text (show value)
   | (name , value) <- as
   ] -- Can be empty :-)

indent = 2 :: Int

