module HTML where

import Common

{-
HTML abstract syntax (Friday, March 07, 1997)

Erik Meijer (erik@cs.ruu.nl)
-}

-- Interface HTML --------------------------------------------
prose             :: String -> HTML
attributedElement :: Tag -> [(Name,Value)] -> [HTML] -> HTML
element           :: Tag -> [HTML] -> HTML
set               :: [(Name,Value)] -> (HTML -> HTML)
--------------------------------------------------------------

type Tag = String

data HTML
 = Element{tag :: Tag, attributes :: [(Name,Value)], html :: [HTML]}
 | Text{ text :: String }

{-
element tage html
 = <tag>html</tag>
-}

element tag html
 = attributedElement tag [] html

{-
attributedElement tag [(name1,value1),...,(namen,valuen)] html
 = <tag
      name1 = value1
      ...
      namen = valuen
   >
     html
   </tag>
-}

attributedElement tag attributes html
 = Element{tag, attributes, html}

{-
prose text
 = text
-}

prose text = Text{text}

{-
-}

set attributes' (e@Text{text})
 = e
set attributes' (e@Element{attributes})
 = e{attributes = [ (n,v) | (n,v) <- attributes, not (elem n ns) ] ++ attributes' }
   where
    ns = map fst attributes'


