#include "cthugha.h"
#include "network.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <unistd.h>
#include <netinet/in.h>
#include <string.h>
#include <netdb.h>

/* 
 * create an PF_INET socket 
 */
int make_socket(int type, short port) {
    int sock;
    struct sockaddr_in s_addr;

    /* create socket for request */
    if( (sock = socket(PF_INET, type, 0)) < 0) {
	printfee("Can not create socket.");
	return -1;
    }

    /* bind socket */
    s_addr.sin_family = AF_INET;
    s_addr.sin_port = htons(port);
    s_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    if( bind(sock, (struct sockaddr*)&s_addr, sizeof(s_addr)) < 0) {
	printfee("Can not bind socket");
	close(sock);
	return -1;
    }

    return sock;
}

/*
 * Find local address
 */
long get_local_addr() {
    char name[255];
    char domain[255];
    struct hostent * hostinfo;

    /* construct name of local machine */
    gethostname( name, 255);
    strcat(name, ".");
    getdomainname( domain, 255);
    strcat(name, domain);

    printfv(2,"  local name   : %s\n", name);

    /* lok up address */
    hostinfo = gethostbyname(name);

    printfv(2,"  local address: %lx\n", *(long*)hostinfo->h_addr);

    return *(long*)hostinfo->h_addr;
}

