#!/bin/sh
#
# Generate the default translation-tables
#
# syntax: 
#    mktab.sh [width] [height]
#

function mkcompile {
	WIDTH=$1
	HEIGHT=$2
	TABPROG=$3

	# compile TABPROG
	echo Compiling $TABPROG for $WIDTH x $HEIGHT
	gcc -m486 -O6 -fomit-frame-pointer -funroll-loops		\
	    $TABPROG.c -DBUFF_WIDTH=$WIDTH -DBUFF_HEIGHT=$HEIGHT -s	\
	    -lm -o $TABPROG
}

function mktab {
	WIDTH=$1
	HEIGHT=$2
	TABPROG=$3
	TABFILE=$4
	shift
	shift
	shift
	shift

	# create TABFILE (without header)
	$TABPROG $TABFILE.1 $*

	# create header
	echo "Creating header..."
	tabheader $TABFILE.1 $WIDTH $HEIGHT > $TABFILE

	# remove temporary file
	echo "Removing temporary file..."
	rm $TABFILE.1

	# compress the file
	gzip -f $TABFILE

	echo "OK"
	echo
}

function mktab2 {
	WIDTH=$1
	HEIGHT=$2
	TABPROG=$3
	TABFILE=$4
	shift
	shift
	shift
	shift

	# create TABFILE (including header)
	$TABPROG $TABFILE $*

	# compress the file
	gzip -f $TABFILE

	echo "OK"
	echo
}

WIDTH=$1
HEIGHT=$2

if [ -z $WIDTH ]; then
	WIDTH=320
fi
if [ -z $HEIGHT ]; then
	HEIGHT=200
fi

echo
echo Generating translation tables for $WIDTH"x"$HEIGHT ...
echo please wait ...
echo

# compile mkgentable, ...
#mkcompile $WIDTH $HEIGHT ./mkgentable 
#mkcompile $WIDTH $HEIGHT ./mkspace
#mkcompile $WIDTH $HEIGHT ./mkhuricn
#mkcompile $WIDTH $HEIGHT ./mksmoke
#mkcompile $WIDTH $HEIGHT ./mkmix_tabs
#mkcompile $WIDTH $HEIGHT ./mkbighalfwheel
#mkcompile $WIDTH $HEIGHT ./mkdownspiral
mkcompile $WIDTH $HEIGHT ./mkrandswirls

echo

if ! [ -e tab ]; then
	mkdir tab
fi

# rotating table
#mktab $WIDTH $HEIGHT ./mkgentable tab/rotate.tab.$WIDTH"x"$HEIGHT 0 0

# 10 random spirals
#mktab $WIDTH $HEIGHT ./mkgentable tab/gentable.tab.$WIDTH"x"$HEIGHT \
#	10 2.0 0.1

# yin-yang spiral
#mktab $WIDTH $HEIGHT ./mkgentable tab/yin-yang.tab.$WIDTH"x"$HEIGHT \
#	-0 60 0.0 -0.025

# fast space flight
#mktab $WIDTH $HEIGHT ./mkspace    tab/space-fast.tab.$WIDTH"x"$HEIGHT

# slow space flight
#mktab $WIDTH $HEIGHT ./mkspace    tab/space-slow.tab.$WIDTH"x"$HEIGHT 30 10

# hurricane
#mktab $WIDTH $HEIGHT ./mkhuricn   tab/huricn.tab.$WIDTH"x"$HEIGHT

# smoke
#mktab $WIDTH $HEIGHT ./mksmoke    tab/smoke.tab.$WIDTH"x"$HEIGHT

# make some of the tabs
#mktab2 $WIDTH $HEIGHT ./mkbighalfwheel	tab/bighalfwheel.tab.$WIDTH"x"$HEIGHT
#mktab2 $WIDTH $HEIGHT ./mkdownspiral	tab/mkdownspiral.tab.$WIDTH"x"$HEIGHT
mktab2 $WIDTH $HEIGHT ./mkrandswirls	tab/mkrandswirls.tab.$WIDTH"x"$HEIGHT

#	mktab.sh  320 204 ./mkmix_tabs 


#rm ./mkgentable 
#rm ./mkspace
#rm ./mkhuricn
#rm ./mksmoke
#rm ./mkmix_tabs
#rm ./mkbighalfwheel
#rm ./mkdownspiral
rm ./mkrandswirls








