/*
 * X-Mame keyboard specifics code
 *
 */
#define __KEYBOARD_C_

/*
 * Include files.
 */

#include "xmame.h"

#ifndef ggi

#ifdef svgalib
#include <vgakeyboard.h>
#define sysdep_update_keyboard keyboard_update
#endif

char tempkey[OSD_MAX_KEY];
static char *unknown = "Unknown";

/*
 * Wait until a key is pressed and return its code.
 */
int osd_read_key(void)
{
	int i;

	/* wait for all keys to be released */
	do
	{
	      sysdep_update_keyboard();
	      for (i = OSD_MAX_KEY;i >= 0; i--)
	          if (key[i]) break;
	} while (i >= 0);

	/* wait for a key press */
	for(;;)
	{
	      sysdep_update_keyboard();
	      for (i = OSD_MAX_KEY;i >= 0;i--)
	          if (key[i])
	          {
#ifdef svgalib
	             if (i==SCANCODE_RIGHTCONTROL) return OSD_KEY_RCONTROL;
	             if (i==SCANCODE_RIGHTALT)     return OSD_KEY_ALTGR;
#endif
	             return i;
	          }
	}
}

int osd_read_keyrepeat() 
{
	int i;
	memset((void *)&key[0],FALSE,OSD_MAX_KEY*sizeof(byte) );
	/* wait for a key press */
	for(;;)
	{
	      sysdep_update_keyboard();
	      for (i = OSD_MAX_KEY;i >= 0;i--)
	          if (key[i])
	          {
#ifdef svgalib
	             if (i==SCANCODE_RIGHTCONTROL) return OSD_KEY_RCONTROL;
	             if (i==SCANCODE_RIGHTALT)     return OSD_KEY_ALTGR;
#endif
	             return i;
	          }
	}
}

/* check if a key is pressed. The keycode is the standard PC keyboard code, as */
/* defined in osdepend.h. Return 0 if the key is not pressed, nonzero otherwise. */
int osd_key_pressed(int keycode)
{
   /* blames to the dos-people who want to check key states before
      the display (and under X thus the keyboard) is initialised */
   if (!key) return 0;
   
#ifdef svgalib
   if (keycode == OSD_KEY_RCONTROL) keycode = SCANCODE_RIGHTCONTROL;
   if (keycode == OSD_KEY_ALTGR) keycode = SCANCODE_RIGHTALT;
#endif
   sysdep_update_keyboard();   
   return key[keycode];
}

#endif /* #ifndef ggi */

/* return the name of a key */
const char *osd_key_name(int keycode)
{
  static char *keynames[89] = { 
    "None", "ESC", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0",
    "MINUS", "EQUAL", "BACKSPACE", "TAB", "Q", "W", "E", "R", "T", "Y",
    "U", "I", "O", "P", "OPENBRACE", "CLOSEBRACE", "ENTER", "LEFTCONTROL",
    "A", "S", "D", "F", "G", "H", "J", "K", "L", "COLON", "QUOTE",
    "TILDE", "LEFTSHIFT", "Unknow", "Z", "X", "C", "V", "B", "N", "M", "COMMA",
    "STOP", "SLASH", "RIGHTSHIFT", "ASTERISK", "ALT", "SPACE", "CAPSLOCK",
    "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "NUMLOCK",
    "SCRLOCK", "HOME", "UP", "PGUP", "MINUS PAD", "LEFT", "5 PAD", "RIGHT",
    "PLUS PAD", "END", "DOWN", "PGDN", "INS", "DEL", "RIGHTCONTROL", "ALTGR",
    "Unknown", "F11", "F12" 
  };

  if (keycode < 89) return (char*)keynames[keycode];
  return (char *)unknown;
}

/* dummy functions we will probably never be able to blink the keybleds 
   under unix anyway */
void osd_led_w(int led,int on) 
{
	return;
}
