/*
 ******************* X-Mame header file *********************
 * file "xmame.h"
 *
 * by jantonio@dit.upm.es
 *
 ************************************************************
*/

#ifndef __XMAME_H_
#define __XMAME_H_

#ifdef __MAIN_C_
#define EXTERN
#else
#define EXTERN extern
#endif

/*
 * Include files.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <ctype.h>
#include <pwd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "driver.h"


#ifdef linux
#include <fcntl.h>
#include <sys/ioctl.h>
#if defined FREEBSD && ( ! defined BSDi )
#include <machine/soundcard.h>
#else
#include <sys/soundcard.h>
#endif
#endif

#ifdef svgalib
#include <vga.h>
#endif

#if defined x11 || defined xf86_dga || defined xgl || defined xfx

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#ifdef X11_JOYSTICK
#include <X11/extensions/XI.h>
#include <X11/extensions/XInput.h>
/* event types returned by XSelecExtensionEvent() */
int num_x_buttons;
int devicebuttonpress;
int devicebuttonrelease;
int devicemotionnotify;
int devicebuttonmotion;
#endif /* ifdef X11_JOYSTICK */

#endif /* if defined x11 || defined xf86_dga */


#ifdef x11

#ifdef USE_MITSHM
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#endif

#ifdef HAS_XPM
#include <X11/xpm.h>
#endif

#endif /* ifdef x11 */

#include "osdepend.h"

#ifdef MAME_NET
/* Network */
 
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#endif /* MAME_NET */

/*
 * Definitions.
 */

#ifndef TRUE
#define	TRUE			(1)
#endif

#ifndef FALSE
#define FALSE			(0)
#endif

#define OSD_OK			(0)
#define OSD_NOT_OK		(1)

#define DEBUG(x)

#define MAXPATHC 20 /* at most 20 path entries */
#define MAXPATHL 512 /* at most 511 character path length */

#ifdef  HAVE_GETTIMEOFDAY

clock_t uclock(void);
#define UCLOCKS_PER_SEC 1000000

#else

#if (CLOCKS_PER_SEC < 1000)
/* the resolution of the normal clock() call isn't good enough, unless the
   framerate is a division of 100, so we fake a higher resolution */
#define uclock() (clock() << 5)
#define UCLOCKS_PER_SEC (CLOCKS_PER_SEC << 5)
#else
#define UCLOCKS_PER_SEC CLOCKS_PER_SEC
#define uclock() clock()
#endif

#endif

enum { LIST_LIST = 1, LIST_FULL, LIST_GAMES, LIST_CLONES,
   LIST_DETAILS, LIST_ROMS, LIST_SAMPLES, LIST_SAMDIR, LIST_CRC, LIST_DUPCRC,
   LIST_COLORS, LIST_LMR, LIST_WRONGORIENTATION, VERIFY_ROMS, VERIFY_SAMPLES };

/*
 * Global variables.
 */

#if defined x11 || defined xf86_dga || defined xgl || defined xfx
EXTERN Display 		*display;
EXTERN Window		window;
/*
 * Workaround: in DO$, the Allegro library maintains this array.
 * In X, we'll have to do it ourselves. Bummer.
 */
EXTERN char	 	xkey[128];
#endif 

#if defined x11 || defined xgl || defined xfx

#ifdef x11
struct dirty_line {
	int x;
	char *start;
	char *end;
};

#ifdef USE_MITSHM
EXTERN XShmSegmentInfo 	shm_info;
#endif
#endif /* ifdef x11 */
EXTERN Screen 		*screen;
EXTERN Colormap		colormap;
EXTERN XImage		*image;
EXTERN GC		gc;
EXTERN int		eval_update_display_func(void);
EXTERN char  		*scaled_buffer_ptr ;
EXTERN unsigned long 	xpixel[256];           /* Pixel index values */
EXTERN char		xpixel_allocated[256];
EXTERN struct dirty_line *dirty_lines;
EXTERN struct dirty_line *old_dirty_lines;
EXTERN void		(*update_display_func)(void);
EXTERN void		(*dirty_update_display_func)(void);
EXTERN char		*copybuffer;
EXTERN int		x_palette_dirty;
#endif /* ifdef x11 */

#ifdef MAME_NET
/* Network Variables */
EXTERN int socks[4];
EXTERN struct sockaddr_in names[4];
EXTERN int syncsocks[4];
EXTERN struct sockaddr_in syncnames[4];
EXTERN int netstate;
EXTERN int netkeymap;
EXTERN int players;
EXTERN char *mastername;
EXTERN int slaves;
EXTERN char netkey[OSD_MAX_KEY+1];
#endif

/* global variables and miscellaneous flags */

EXTERN int              root_window_id; /* root window id (for swallowing the mame window) */
EXTERN int	 	widthscale;     /* X scale */
EXTERN int	 	heightscale;    /* Y SCALE */
EXTERN char 		*displayname;   /* default is use local */
EXTERN char		rompath[MAXPATHL];
EXTERN char		*spooldir;      /* directory to store high scores */
EXTERN char		*home_dir;
EXTERN char		*towns_pad_dev; /* name of FM-TOWNS device */
EXTERN char 		*x11joyname;
EXTERN char             *audiodevice;   /* /dev/dsp or /dev/audio */
EXTERN char		*key;
EXTERN char		No_FM;
EXTERN char		title[50]; 
EXTERN int		swapjoyaxis;
EXTERN int		analogstick;
EXTERN int		use_joystick;
EXTERN int		use_mouse;
EXTERN int		use_dirty;
EXTERN int		use_layer;
EXTERN int		use_profiler;
EXTERN int		play_sound;
EXTERN int		fake_sound;
EXTERN int		use_private_cmap;
EXTERN int		use_xsync;
EXTERN int		video_mode;
EXTERN int		force_truecolor;
EXTERN int		throttle;
EXTERN int 		snapshot_no;
EXTERN int		game_index;
EXTERN struct osd_bitmap *bitmap;
EXTERN int		frag_size;
EXTERN int		num_frags;
EXTERN int 		mit_shm_avail;  /* use mitshm if available */
EXTERN float		gamma_correction;
EXTERN int		brightness;
EXTERN int		totalcolors;
EXTERN int		attenuation;

/* visual is the visual part of the bitmap */
EXTERN int 		visual_width;
EXTERN int		visual_height;
EXTERN struct rectangle	visual;

/* platform independent options go here */
EXTERN struct GameOptions options;

/* File descripters for stdout / stderr redirection, without svgalib inter
   fering */
EXTERN FILE *stdout_file;
EXTERN FILE *stderr_file;

/* system dependent functions */
int sysdep_init(void);
void sysdep_exit(void);
int sysdep_create_display(void);
void sysdep_alloc_palette(void);
void sysdep_modify_pen(int pen, unsigned char red,unsigned char green,unsigned char blue);
void sysdep_update_display(void);
void sysdep_clear_screen(void);

/* audio related */
int start_timer();
int sysdep_audio_initvars(void);
void sysdep_audio_close(void);
long sysdep_get_audio_freespace(void);
int sysdep_play_audio(byte *buf, int size);
void sysdep_fill_audio_buffer(long *in,char *out,int start,int end);

/* keyboard related */
int sysdep_keyboard_init(void);
void sysdep_keyboard_close(void);
void sysdep_update_keyboard (void);
int sysdep_mapkey(int from, int to);
int key_to_pseudo_code(int k);

/* mouse related */
int sysdep_mouse_init(void);
void sysdep_mouse_close(void);

/* joystick related */
int sysdep_joy_initvars(void);
int x11_joystick_init(void);
void sysdep_joy_close(void);

/* miscelaneous */
int get_config (int argc, char *argv[]);
int frontend_list(int list, char *gamename, int showclones);
int frontend_list_clones(char *gamename);
int xf86_init(void);
void init_rom_path(void);
void romident(const char* name, int enter_dirs);
#if defined x11 || defined xf86_dga || defined xgl || defined xfx
void process_mouse_event(XEvent *event);
void process_x11_joy_event(XEvent *event);
#endif

/* dirty functions */
void osd_mark_dirty(int sx,int sy, int ex, int ey, int ui);
void merge_dirty(void);
void copy_dirty_layer_to_dirty(void);

/* profiler functions */
void osd_profiler_init(void);
void osd_profiler_display(void);

#ifdef x11
/* X-update functions, for all the special cases */
void osd_refresh_screen(void);
void osd_refresh_dirty_screen(void);

/* 8bpp pseudocolor functions */
void do_update_pseudo_generic(void);
void do_update_pseudo_scale1(void);
void do_update_pseudo_scale2(void);
void do_update_pseudo_scale3(void);
void do_update_pseudo_dirty_generic(void);
void do_update_pseudo_dirty_scale1(void);
void do_update_pseudo_dirty_scale2(void);
void do_update_pseudo_dirty_scale3(void);

/* truecolor functions */
void do_update_truec_generic(void);
void do_update_truec_scale1(void);
void do_update_truec_scale2(void);
void do_update_truec_scale3(void);
void do_update_truec_dirty_generic(void);
void do_update_truec_dirty_scale1(void);
void do_update_truec_dirty_scale2(void);
void do_update_truec_dirty_scale3(void);

#endif /* ifdef x11 */

#undef EXTERN
#endif
