/* 
 * update_display.c
 *
 * routines to perform the refresh of an XImage
 * they are put in a separate file due to very special ones: most of them are
 * a collection of special cases in order to get most accuracy
 *
 */

#ifdef x11
#define __UPDATE_DSP_C_

#include "xmame.h"

/* used when expose events received */
void osd_refresh_screen(void)
{

#ifdef USE_MITSHM
    if (mit_shm_avail)
    {
	XShmPutImage (display, window, gc, image, 0, 0, 0, 0, image->width, image->height, FALSE);
    } 
    else /* no shm: just use XPutImage */
#endif
        XPutImage (display, window, gc, image, 0, 0, 0, 0, image->width, image->height);

   /* some games "flickers" with XFlush, so command line option is provided */
   if(use_xsync) XSync (display,False); /* be sure to get request processed */
   else XFlush (display); 		/* flush buffer to server */
}

void osd_refresh_dirty_screen(void) {
    int line,lineto;
#ifdef USE_MITSHM
    if (mit_shm_avail) {
	/* just parse every dirty lines and send it to X-Server */
	for (line=0; line<visual_height; line++) {
	    if (!dirty_lines[line].start) continue;
	    /* go till next non-dirty line */
	    for(lineto=line; dirty_lines[lineto].start; lineto++);
	    XShmPutImage (display, window, gc, image, 
			0, line*heightscale, 0, line*heightscale , 
			image->width, (lineto-line)*heightscale, FALSE);
	    /* now mark parsed lines as clean */
	    memset((void *)&dirty_lines[line], 0, (lineto-line)*sizeof(struct dirty_line) );
	    line=lineto;
	}
    } else { /* no shm: just use XPutImage */
#endif
	for (line=0; line<visual_height; line++) {
	    if (!dirty_lines[line].start) continue; 
	    /* go till next non-dirty line */
	    for(lineto=line; dirty_lines[lineto].start; lineto++);
            XPutImage (display, window, gc, image, 
			0, line*heightscale, 0, line*heightscale, 
			image->width, (lineto-line)*heightscale);
	    /* now mark parsed lines as clean */
	   memset((void *)&dirty_lines[line], 0, (lineto-line)*sizeof(struct dirty_line) );
	   line=lineto;
	}
#ifdef USE_MITSHM
    }
#endif

   /* some games "flickers" with XFlush, so command line option is provided */
   if(use_xsync) XSync (display,False); /* be sure to get request processed */
   else XFlush (display); 		/* flush buffer to server */
}

/* invoked by main tree code to update bitmap into screen */
void sysdep_update_display(void)
{
    int old_use_dirty=use_dirty;
    int old_use_layer=use_layer;
    
    if (use_dirty && !use_layer) merge_dirty();
    if (use_dirty &&  use_layer) copy_dirty_layer_to_dirty();
    
    if (x_palette_dirty)
    {
       /* trick make this a dirty update and mark everything dirty, to make
          sure the entire screen is updated since the palette has changed */
       use_dirty=TRUE;
       use_layer=FALSE;
       osd_mark_dirty(0, 0, bitmap->width - 1, bitmap->height - 1, 0);
       /* update copybuffer if we're normally not using dirty code */
       if (old_use_dirty==0) 
       {
          int line;
          char *dst_pt = copybuffer;
          for (line=visual.min_y; line<visual.max_y; line++, dst_pt+=visual_width)
              memcpy( (void*)dst_pt, (void *)(bitmap->line[line]+visual.min_x), visual_width ); 
       }
    }
    
    /* call propper update routine */
    if (use_dirty)
       (*dirty_update_display_func)();
     else
       (*update_display_func)();
       
    use_dirty=old_use_dirty;
    use_layer=old_use_layer;
    x_palette_dirty=FALSE;
}

#define DSP_SCALE_GENERIC 	0
#define DSP_SCALE_1	      	1
#define DSP_SCALE_2		2
#define DSP_SCALE_3		3

#define DSP_USE_TRUECOLOR	4
#define DSP_USE_DIRTY    	8

void (*update_funcs[])(void) = {
/* normal ( parsing image bitmap strategy */
	 do_update_pseudo_generic,
	 do_update_pseudo_scale1,
	 do_update_pseudo_scale2,
	 do_update_pseudo_scale3,
	 do_update_truec_generic,
	 do_update_truec_scale1,
	 do_update_truec_scale2,
	 do_update_truec_scale3,
/* dirty_lines strategy */
	 do_update_pseudo_dirty_generic,
	 do_update_pseudo_dirty_scale1,
	 do_update_pseudo_dirty_scale2,
	 do_update_pseudo_dirty_scale3,
	 do_update_truec_dirty_generic,
	 do_update_truec_dirty_scale1,
	 do_update_truec_dirty_scale2,
	 do_update_truec_dirty_scale3,
};

int eval_update_display_func(void)
{
	int index=0;
	
	if (force_truecolor)	     index |= DSP_USE_TRUECOLOR;
	if (heightscale!=widthscale) index |= DSP_SCALE_GENERIC;
	else {
	    if (heightscale > 3)     index |= DSP_SCALE_GENERIC;
	    else                     index |= heightscale;
	}
	
	/* now set update_display pointers */
	update_display_func       = update_funcs[index];
	dirty_update_display_func = update_funcs[index+DSP_USE_DIRTY];

	/* the non-dirty code uses a copy to determine which parts of the
	   screen need to be updated */	
	if (!use_dirty)
	{
	   copybuffer=(char *)malloc( visual_width * visual_height * sizeof(char) );
	   if (!copybuffer)
	   {
	      fprintf(stderr_file,"Cannot allocate space for copybuffer\n");
	      return OSD_NOT_OK;
	   }
	}
	
	/* init dirty, this is done always, since x uses dirty_lines even in
	   nodirty mode, to work around palette-cycling  */
	/* alloc lines + 1, dirty_lines must always end with empty line !! */
	dirty_lines=(struct dirty_line *)malloc(sizeof(struct dirty_line)*(visual_height+1));
	if (!dirty_lines)
	{
	   fprintf(stderr_file,"Cannot allocate space for dirtybuffer\n");
	   return OSD_NOT_OK;
	}
	memset((void *)dirty_lines, 0, sizeof(struct dirty_line)*(visual_height+1));
	
	/* secondary dirty buffer is only used when doing real dirty */
	if (use_dirty && !use_layer)
	{
	   /* alloc lines + 1, dirty_lines must always end with empty line !! */
	   old_dirty_lines=(struct dirty_line *)malloc(sizeof(struct dirty_line)*(visual_height+1));
	   if (!old_dirty_lines)
	   {
	      fprintf(stderr_file,"Cannot allocate space for dirtybuffer\n");
	      return OSD_NOT_OK;
	   }
	   memset((void *)old_dirty_lines, 0, sizeof(struct dirty_line)*(visual_height+1));
	}

	return OSD_OK;
}

#endif /* ifdef x11 */
