/*
 * X-Mame keyboard specifics code
 *
 */
#define __KEYBOARD_C_

/*
 * Include files.
 */
#include "xmame.h"
 
#ifndef ggi

#ifdef svgalib
#include <vgakeyboard.h>
#define sysdep_update_keyboard keyboard_update
#endif

/*
 * Wait until a key is pressed and return its code.
 */
int osd_read_key(int translate)
{
	int i;

	/* wait for all keys to be released */
	do
	{
	      sysdep_update_keyboard();
	      for (i = 127;i >= 0; i--)
	          if (key[i]) break;
	} while (i >= 0);

	/* wait for a key press */
	for(;;)
	{
	      sysdep_update_keyboard();
	      for (i = 127;i >= 0;i--)
	          if (key[i])
	          {
#ifdef svgalib
	             if (i==SCANCODE_RIGHTCONTROL) i = OSD_KEY_RCONTROL;
	             if (i==SCANCODE_RIGHTALT)     i = OSD_KEY_ALTGR;
#endif
		     if(translate)
		        return key_to_pseudo_code(i);
		      else
		        return i;
	          }
	}
}

int osd_read_keyrepeat(int translate) 
{
	int i;
	memset((void *)&key[0], FALSE, 128*sizeof(byte) );
	/* wait for a key press */
	for(;;)
	{
	      sysdep_update_keyboard();
	      for (i = 127;i >= 0;i--)
	          if (key[i])
	          {
#ifdef svgalib
	             if (i==SCANCODE_RIGHTCONTROL) i = OSD_KEY_RCONTROL;
	             if (i==SCANCODE_RIGHTALT)     i = OSD_KEY_ALTGR;
#endif
		     if (translate)
		        return key_to_pseudo_code(i);
		      else
		        return i;
	          }
	}
}

/* check if a key is pressed. The keycode is the standard PC keyboard code, as */
/* defined in osdepend.h. Return 0 if the key is not pressed, nonzero otherwise. */
int osd_key_pressed(int keycode)
{
   /* blames to the dos-people who want to check key states before
      the display (and under X thus the keyboard) is initialised */
   if (!key) return 0;

   sysdep_update_keyboard();

   if (keycode > 127)
   {
	switch (keycode)
	{
		case OSD_KEY_RESET_MACHINE:
			return key[OSD_KEY_F3];
		case OSD_KEY_SHOW_GFX:
			return key[OSD_KEY_F4];
		case OSD_KEY_JOY_CALIBRATE:
			return key[OSD_KEY_F7];
		case OSD_KEY_FRAMESKIP:
			return key[OSD_KEY_F8];
		case OSD_KEY_THROTTLE:
			return key[OSD_KEY_F10];
		case OSD_KEY_SHOW_FPS:
			return key[OSD_KEY_F11] && !key[OSD_KEY_LSHIFT];
		case OSD_KEY_SHOW_PROFILE:
			return key[OSD_KEY_F11] && key[OSD_KEY_LSHIFT];
		case OSD_KEY_SNAPSHOT:
			return key[OSD_KEY_F12];
			
		case OSD_KEY_FAST_EXIT:
		case OSD_KEY_UNPAUSE:
			return key[OSD_KEY_ESC];
		case OSD_KEY_PAUSE:
			return key[OSD_KEY_P];
		case OSD_KEY_CONFIGURE:
			return key[OSD_KEY_TAB];
		case OSD_KEY_ON_SCREEN_DISPLAY:
			{
				extern int mame_debug;
				return (key[OSD_KEY_TILDE] && !mame_debug);
			}
	}
   }
   
#ifdef svgalib
   if (keycode == OSD_KEY_RCONTROL) keycode = SCANCODE_RIGHTCONTROL;
   if (keycode == OSD_KEY_ALTGR) keycode = SCANCODE_RIGHTALT;
#endif

   return key[keycode];
}

#endif /* #ifndef ggi */

static char memory[256];

/* Report a key as pressed only when the user hits it, not while it is */
/* being kept pressed. */
int osd_key_pressed_memory(int keycode)
{
	int res = 0;

	if (osd_key_pressed(keycode))
	{
		if (memory[keycode] == 0) res = 1;
		memory[keycode] = 1;
	}
	else
		memory[keycode] = 0;

	return res;
}

/* report key as pulsing while it is pressed */
int osd_key_pressed_memory_repeat(int keycode,int speed)
{
	static int counter;
	int res = 0;

	if (osd_key_pressed(keycode))
	{
		if (memory[keycode] == 0 || ++counter > speed * Machine->drv->frames_per_second / 60)
		{
			counter = 0;
			res = 1;
		}
		memory[keycode] = 1;
	}
	else
		memory[keycode] = 0;

	return res;
}


/* If the user presses a key return it, otherwise return OSD_KEY_NONE. */
/* DO NOT wait for the user to press a key */
int osd_read_key_immediate(void)
{
	int res;


	/* first of all, record keys which are NOT pressed */
	for (res = 127;res >= 0;res--)
	{
		if (!osd_key_pressed(res))
		{
			memory[res] = 0;
			memory[key_to_pseudo_code(res)] = 0;
		}
	}

	for (res = 127;res >= 0;res--)
	{
		if (osd_key_pressed(res))
		{
			if (memory[res] == 0)
			{
				memory[res] = 1;
				memory[key_to_pseudo_code(res)] = 1;
			}
			else res = OSD_KEY_NONE;
			return res;
		}
	}

	return OSD_KEY_NONE;
}


/* return the name of a key */
const char *osd_key_name(int keycode)
{
  static char *unknown = "Unknown";
  static char *keynames[128] =
  {
    "None", "ESC", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-",
    "=", "BKSPACE", "TAB", "Q", "W", "E", "R", "T", "Y", "U", "I", "O",
    "P", "[", "]", "ENTER", "LCONTROL", "A", "S", "D",
    "F", "G", "H", "J", "K", "L", ";", "'", "`", "LSHIFT",
    "Unknown", "Z", "X", "C", "V", "B", "N", "M", "COMMA", ".", "/",
    "RSHIFT", "*", "ALT", "SPACE", "CAPSLOCK", "F1", "F2", "F3",
    "F4", "F5", "F6", "F7", "F8", "F9", "F10", "NUMLOCK", "SCRLOCK", "HOME",
    "UP", "PGUP", "- PAD", "LEFT", "5 PAD", "RIGHT", "+ PAD", "END",
    "DOWN", "PGDN", "INS", "DEL", "RCONTROL", "ALTGR", "Unknown",
    "F11", "F12", "Unknown", "Unknown",
    "Unknown", "Unknown", "Unknown", "Unknown", "Unknown",
    "Unknown", "Unknown", "Unknown", "Unknown", "Unknown",
    "1 PAD", "2 PAD", "3 PAD", "4 PAD", "Unknown",
    "6 PAD", "7 PAD", "8 PAD", "9 PAD", "0 PAD",
    ". PAD", "= PAD", "/ PAD", "* PAD", "ENTER PAD",
    "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown",
    "\\", "PAUSE", "Unknown", "Unknown", "Unknown", "Unknown"
  };

  if (keycode < 128) return (char*)keynames[keycode];
  return (char *)unknown;
}

/* dummy functions we will probably never be able to blink the keyb-leds 
   under unix anyway */
void osd_led_w(int led,int on) 
{
	return;
}

int key_to_pseudo_code(int k)
{
    switch (k)
    {
        case OSD_KEY_F3:
            return OSD_KEY_RESET_MACHINE;
        case OSD_KEY_F4:
            return OSD_KEY_SHOW_GFX;
	case OSD_KEY_F7:
	    return OSD_KEY_JOY_CALIBRATE;
        case OSD_KEY_F8:
            return OSD_KEY_FRAMESKIP;
        case OSD_KEY_F10:
            return OSD_KEY_THROTTLE;
        case OSD_KEY_F11:
	    if (key[OSD_KEY_LSHIFT])
		return OSD_KEY_SHOW_PROFILE;
	    return OSD_KEY_SHOW_FPS;
        case OSD_KEY_F12:
	    return OSD_KEY_SNAPSHOT;
	    
	case OSD_KEY_ESC:
	    return OSD_KEY_FAST_EXIT;
        case OSD_KEY_P:
            return OSD_KEY_PAUSE;
	case OSD_KEY_TAB:
            return OSD_KEY_CONFIGURE;
	case OSD_KEY_TILDE:
	    return OSD_KEY_ON_SCREEN_DISPLAY;
    }
    return k;
}
