/*
 * Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.
 *
 * (c) Copyright 1996, 1997, 1998 Gary Henderson (gary@daniver.demon.co.uk) and
 *                                Jerremy Koot (jkoot@snes9x.com)
 *
 * Super FX C emulator code 
 * (c) Copyright 1997, 1998 Ivar (Ivar@snes9x.com) and
 *                          Gary Henderson.
 * Super FX assembler emulator code (c) Copyright 1998 zsKnight and _Demo_.
 *
 * DSP1 emulator code (c) Copyright 1998 Ivar, _Demo_ and Gary Henderson.
 * DOS port code contains the works of other authors. See headers in
 * individual files.
 *
 * Snes9x homepage: www.snes9x.com
 *
 * Permission to use, copy, modify and distribute Snes9x in both binary and
 * source form, for non-commercial purposes, is hereby granted without fee,
 * providing that this license information and copyright notice appear with
 * all copies and any derived work.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event shall the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Snes9x is freeware for PERSONAL USE only. Commercial users should
 * seek permission of the copyright holders first. Commercial use includes
 * charging money for Snes9x or software derived from Snes9x.
 *
 * The copyright holders request that bug fixes and improvements to the code
 * should be forwarded to them so everyone can benefit from the modifications
 * in future versions.
 *
 * Super NES and Super Nintendo Entertainment System are trademarks of
 * Nintendo Co., Limited and its subsidiary companies.
 */

#include "snes9x.h"
#include "65c816.h"
#include "memmap.h"
#include "ppu.h"
#include "apu.h"
#include "cpuexec.h"

#define OFFSET(N,F) \
printf ("#define " #N " CPU + %d\n", &((struct SCPUState *) 0)->F);
#define OFFSET2(N,F) \
printf ("#define " #N " Registers + %d\n", &((struct SRegisters *) 0)->F);
#define OFFSET3(F) \
printf ("#define " #F " Memory + %d\n", &((class CMemory *) 0)->F);
#define OFFSET4(N,F) \
printf ("#define " #N " APU + %d\n", &((struct SAPU *) 0)->F);
#define OFFSET5(N,F) \
printf ("#define " #N " IAPU + %d\n", &((struct SIAPU *) 0)->F);
#define OFFSET6(N,F) \
printf ("#define " #N " ICPU + %d\n", &((struct SICPU *) 0)->F);
#define OFFSET7(F) \
printf ("#define " #F " Settings + %d\n", &((struct SSettings *) 0)->F);
#define OFFSET8(N, F) \
printf ("#define " #N " APURegisters + %d\n", &((struct SAPURegisters *) 0)->F);

#define OFFSET9(N, F) \
printf ("#define " #N " PPU + %d\n", &((struct SPPU *) 0)->F);
#define OFFSET10(N, F) \
printf ("#define " #N " IPPU + %d\n", &((struct InternalPPU *) 0)->F);

int main (int argc, char **argv)
{
    OFFSET(Flags,Flags)
    OFFSET(BranchSkip,BranchSkip)
    OFFSET(NMIActive,NMIActive)
    OFFSET(IRQActive,IRQActive)
    OFFSET(WaitingForInterrupt,WaitingForInterrupt)
    OFFSET(InDMA,InDMA)
    OFFSET(WhichEvent,WhichEvent)
    OFFSET(PCS,PC)
    OFFSET(PCBase,PCBase)
    OFFSET(PCAtOpcodeStart,PCAtOpcodeStart)
    OFFSET(WaitAddress,WaitAddress)
    OFFSET(WaitCounter,WaitCounter)
    OFFSET(Cycles,Cycles)
    OFFSET(NextEvent,NextEvent)
    OFFSET(V_Counter,V_Counter)
    OFFSET(MemSpeed,MemSpeed)
    OFFSET(MemSpeedx2,MemSpeedx2)
    OFFSET(FastROMSpeed,FastROMSpeed)

    OFFSET2(PB,PB)
    OFFSET2(DB,DB)
    OFFSET2(PP,P.W)
    OFFSET2(PL,P.W)
    printf ("#define PH PL + 1\n");
    OFFSET2(AA,A.W)
    OFFSET2(AL,A.W)
    printf ("#define AH AL + 1\n");
    OFFSET2(DD,D.W)
    OFFSET2(DL,D.W)
    printf ("#define DH DL + 1\n");
    OFFSET2(SS,S.W)
    OFFSET2(SL,S.W)
    printf ("#define SH SL + 1\n");
    OFFSET2(XX,X.W)
    OFFSET2(XL,X.W)
    printf ("#define XH XL + 1\n");
    OFFSET2(YY,Y.W)
    OFFSET2(YL,Y.W)
    printf ("#define YH YL + 1\n");
    OFFSET2(PCR, PC)

    OFFSET3(RAM)
    OFFSET3(ROM)
    OFFSET3(VRAM)
    OFFSET3(SRAM)
    OFFSET3(FillRAM)
    OFFSET3(HiROM)
    OFFSET3(LoROM)
    OFFSET3(SRAMMask)
    OFFSET3(SRAMSize)
    OFFSET3(Map)
    OFFSET3(WriteMap)
    OFFSET3(MemorySpeed)
    OFFSET3(BlockIsRAM)
    OFFSET3(BlockIsROM)
    OFFSET3(ROMFilename)

    OFFSET5(APUPCS,PC)
    OFFSET5(APURAM,RAM)
    OFFSET5(APUExecuting,APUExecuting)
    OFFSET5(APUDirectPage,DirectPage)
    OFFSET5(APUBit,Bit)
    OFFSET5(APUAddress,Address)
    OFFSET5(APUWaitAddress1,WaitAddress1)
    OFFSET5(APUWaitAddress2,WaitAddress2)
    OFFSET5(APUWaitCounter,WaitCounter)
    OFFSET5(APUShadowRAM,ShadowRAM)
    OFFSET5(APUCachedSamples,CachedSamples)
    OFFSET5(APU_Carry,_Carry)
    OFFSET5(APU_Zero,_Zero)
    OFFSET5(APU_Overflow,_Overflow)
    OFFSET5(APUTimerErrorCounter,TimerErrorCounter)

    OFFSET4(APUCycles,Cycles)
    OFFSET4(APUShowROM,ShowROM)
    OFFSET4(APUFlags,Flags)
    OFFSET4(APUKeyedChannels,KeyedChannels)
    OFFSET4(APUOutPorts,OutPorts)
    OFFSET4(APUDSP,DSP)
    OFFSET4(APUExtraRAM,ExtraRAM)
    OFFSET4(APUTimer,Timer)
    OFFSET4(APUTimerTarget,TimerTarget)
    OFFSET4(APUTimerEnabled,TimerEnabled)
    OFFSET4(TimerValueWritten,TimerValueWritten)

    OFFSET6(CPUSpeed,Speed)
    OFFSET6(CPUOpcodes,S9xOpcodes)
    OFFSET6(_Carry,_Carry)
    OFFSET6(_Zero,_Zero)
    OFFSET6(_Negative,_Negative)
    OFFSET6(_Overflow,_Overflow)
    OFFSET6(ShiftedDB,ShiftedDB)
    OFFSET6(ShiftedPB,ShiftedPB)
    OFFSET6(CPUExecuting,CPUExecuting)

    OFFSET7(APUEnabled)
    OFFSET7(Shutdown)
    OFFSET7(SoundSkipMethod)
    OFFSET7(H_Max)
    OFFSET7(HBlankStart)
    OFFSET7(SPCTo65c816Ratio)
    OFFSET7(DisableIRQ)
    OFFSET7(Paused)
    OFFSET7(BattleToadsNMIHack)
    OFFSET7(PAL)

    OFFSET8(ApuP,P)
    OFFSET8(ApuYA,YA.W)
    OFFSET8(ApuA,YA.B.A)
    OFFSET8(ApuY,YA.B.Y)
    OFFSET8(ApuX,X)
    OFFSET8(ApuS,S)
    OFFSET8(ApuPC,PC)
    OFFSET8(APUPCR,PC)

    OFFSET9(BGMode,BGMode)
    OFFSET9(BG3Priority,BG3Priority)
    OFFSET9(Brightness,Brightness)
    OFFSET9(GHight,VMA.High)
    OFFSET9(GInc,VMA.Increment)
    OFFSET9(GAddress,VMA.Address)
    OFFSET9(GMask1,VMA.Mask1)
    OFFSET9(GFullGraphicCount,VMA.FullGraphicCount)
    OFFSET9(GShift,VMA.Shift)
    OFFSET9(CGFLIP,CGFLIP)
    OFFSET9(CGDATA,CGDATA)
    OFFSET9(FirstSprite,FirstSprite)
    OFFSET9(LastSprite,LastSprite)
    OFFSET9(OBJ,OBJ)
    OFFSET9(OAMPriorityRotation,OAMPriorityRotation)
    OFFSET9(OAMAddr,OAMAddr)
    OFFSET9(OAMFlip,OAMFlip)
    OFFSET9(OAMTileAddress,OAMTileAddress)
    OFFSET9(IRQVBeamPos,IRQVBeamPos)
    OFFSET9(IRQHBeamPos,IRQHBeamPos)
    OFFSET9(VBeamPosLatched,VBeamPosLatched)
    OFFSET9(HBeamPosLatched,HBeamPosLatched)
    OFFSET9(HBeamFlip,HBeamFlip)
    OFFSET9(VBeamFlip,VBeamFlip)
    OFFSET9(HVBeamCounterLatched,HVBeamCounterLatched)
    OFFSET9(MatrixA,MatrixA)
    OFFSET9(MatrixB,MatrixB)
    OFFSET9(MatrixC,MatrixC)
    OFFSET9(MatrixD,MatrixD)
    OFFSET9(CentreX,CentreX)
    OFFSET9(CentreY,CentreY)
    OFFSET9(Joypad1ButtonReadPos,Joypad1ButtonReadPos)
    OFFSET9(Joypad2ButtonReadPos,Joypad2ButtonReadPos)
    OFFSET9(CGADD,CGADD)
    OFFSET9(FixedColourGreen,FixedColourGreen)
    OFFSET9(FixedColourRed,FixedColourRed)
    OFFSET9(FixedColourBlue,FixedColourBlue)
    OFFSET9(SavedOAMAddr,SavedOAMAddr)
    OFFSET9(ScreenHeight,ScreenHeight)
    OFFSET9(WRAM,WRAM)
    OFFSET9(BG_Forced,BG_Forced)
    OFFSET9(ForcedBlanking,ForcedBlanking)
    OFFSET9(OBJThroughMain,OBJThroughMain)
    OFFSET9(OBJThroughSub,OBJThroughSub)
    OFFSET9(OBJSizeSelect,OBJSizeSelect)
    OFFSET9(OBJNameBase,OBJNameBase)
    OFFSET9(OAMReadFlip,OAMReadFlip)
    OFFSET9(OAMData,OAMData)
    OFFSET9(VTimerEnabled,VTimerEnabled)
    OFFSET9(HTimerEnabled,HTimerEnabled)
    OFFSET9(HTimerPosition,HTimerPosition)
    OFFSET9(Mosaic,Mosaic)
    OFFSET9(BGMosaic,BGMosaic)
    OFFSET9(Mode7HFlip,Mode7HFlip)
    OFFSET9(Mode7VFlip,Mode7VFlip)
    OFFSET9(Mode7Repeat,Mode7Repeat)
    OFFSET9(Window1Left,Window1Left)
    OFFSET9(Window1Right,Window1Right)
    OFFSET9(Window2Left,Window2Left)
    OFFSET9(Window2Right,Window2Right)
    OFFSET9(ClipWindowOverlapLogic,ClipWindowOverlapLogic)
    OFFSET9(ClipWindow1Enable,ClipWindow1Enable)
    OFFSET9(ClipWindow2Enable,ClipWindow2Enable)
    OFFSET9(ClipWindow1Inside,ClipWindow1Inside)
    OFFSET9(ClipWindow2Inside,ClipWindow2Inside)
    OFFSET9(RecomputeClipWindows,RecomputeClipWindows)
    OFFSET9(CGFLIPRead,CGFLIPRead)
    OFFSET9(OBJNameSelect,OBJNameSelect)
    OFFSET9(Need16x8Mulitply,Need16x8Mulitply)
    OFFSET9(Joypad3ButtonReadPos,Joypad3ButtonReadPos)
    OFFSET9(MouseSpeed,MouseSpeed)

    OFFSET10(ColorsChanged,ColorsChanged)
    OFFSET10(HDMA,HDMA)
    OFFSET10(HDMAStarted,HDMAStarted)
    OFFSET10(MaxBrightness,MaxBrightness)
    OFFSET10(LatchedBlanking,LatchedBlanking)
    OFFSET10(OBJChanged,OBJChanged)
    OFFSET10(RenderThisFrame,RenderThisFrame)
    OFFSET10(SkippedFrames,SkippedFrames)
    OFFSET10(FrameSkip,FrameSkip)
    OFFSET10(TileCache,TileCache)
    OFFSET10(TileCached,TileCached)
    OFFSET10(FirstVRAMRead,FirstVRAMRead)
    OFFSET10(LatchedInterlace,LatchedInterlace)
    OFFSET10(DoubleWidthPixels,DoubleWidthPixels)
    OFFSET10(RenderedScreenHeight,RenderedScreenHeight)
    OFFSET10(RenderedScreenWidth,RenderedScreenWidth)
    OFFSET10(Red,Red)
    OFFSET10(Green,Green)
    OFFSET10(Blue,Blue)
    OFFSET10(XB,XB)
    OFFSET10(ScreenColors,ScreenColors)
    OFFSET10(PreviousLine,PreviousLine)
    OFFSET10(CurrentLine,CurrentLine)
    OFFSET10(Joypads,Joypads)
    OFFSET10(SuperScope,SuperScope)
    OFFSET10(Mouse,Mouse)
    OFFSET10(PrevMouseX,PrevMouseX)
    OFFSET10(PrevMouseY,PrevMouseY)
    OFFSET10(Clip,Clip)

    return (0);
}
