/* log.c:
 * Encompases the old way of logfiles, and the new way.
 * The "OLDLOG" method writes out to a file immediately when you make a
 *  mistake, IF you started with "-logfile filename".
 * The new way writes a snapshot of your currently unatoned mistakes to
 * the resoruce-defined logfile, on the fly.
 */

#include <stdio.h>
#include <Xatom.h>
#include <Xos.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Shell.h>
#include <Xaw/Command.h>

#include "defs.h"
#include "externs.h"
#include "game.h"

static char logfilename[200];


#ifdef OLDLOG
FILE *logfile;

/* initlog
 *	sets up ongoing logfile, if "-logfile filename" option is used
 */

void initlog(){
	char logname[200];

	logfile = NULL;

	GetXtString("logfile","Logfile",logname);
	if(strcmp(logname,"none") != 0){
		if(strcmp(logname,"NOT SET") == 0){
			fprintf(stderr,"logname not set?\n");
			return;
		}
		logfile = fopen(logname,"w");
		if(logfile == NULL){
			fprintf(stderr,"Could not open logfile %s\n",logname);
		} else {
			fprintf(logfile,"#\n#Logfile of mistakes made in kdrill\n");
			fprintf(logfile,"#   This file can be used directly as a usefile\n");
			fprintf(logfile,"#        (provided there are more than 8 different first numbers)\n");
			fprintf(logfile,"#   Lines with same first numbers only count as one entry\n");
			fprintf(logfile,"#   Syntax of logfile is:\n");
			fprintf(logfile,"# Realkanji -> Guessedkanji\n");			
		}
	}
}
#else

/* initlog()
 *	Checks for existance of logfile, and reads in previously missed
 *	count from that if possible.
 */
void initlog(){
	FILE *oldlogfile;
	char inbuf[100];

	GetXtString("logfile","Logfile",logfilename);
	
	if(access("kdrill.log",R_OK) != 0)
		return;
	oldlogfile = fopen(logfilename,"r");
	if(oldlogfile == NULL){
		printf("kdrill: Error... cannot open file %s\n",logfilename);
		return;
	} else {
		printf("Reading in %s for previously missed kanji\n",
		       logfilename);
	}

	while(fgets(inbuf,99,oldlogfile) != NULL){
		int kindex;
		kindex = xtoi(inbuf);
		if( kindex<MAXKANJIALLOWED){
			if(translations[kindex] != NULL){
				translations[kindex]->incorrect +=1;
				if(translations[kindex]->incorrect == 1)
					numberincorrect +=1;
			}
		}
	}
	printf("Restored a total of %d incorrect kanji\n",numberincorrect);
	fclose(oldlogfile);

}


#endif /* OLDLOG */

/* MakeLog dumps our error table out to the logfile.
 * Do it in a "usefile"-compatible format, in case the player wants _extra_
 * drilling on the chars missed.
 */
void MakeLog(Widget w,XtPointer client_data, XtPointer call_data){
	int kcounter;
	char statbuf[200];
	int errors=0;
	static clearlog=0;
	FILE *logfile;

	if(numberincorrect == 0){
		if(clearlog==0){
			setstatus("No error to log!");
			clearlog=1;
			return;
		} else {
			sprintf("Clearing log file \"%.190s\"",logfilename);
			setstatus(statbuf);
		}
	}
	clearlog=0;

	logfile = fopen(logfilename,"w");
	if(logfile == NULL){
		sprintf(statbuf,"Error.. cannot open \"%.190s\"",logfilename);
		setstatus(statbuf);
		return;
	}
	for(kcounter=lowestkanji;kcounter <=highestkanji;kcounter++){
		if(translations[kcounter] == NULL)
			continue;
		if(translations[kcounter]->incorrect >0){
			int loop=translations[kcounter]->incorrect;
			while(loop-- > 0){
				fprintf(logfile,"%x \n",kcounter);
			}
			errors++;
		}

	}

	fclose(logfile);
	if(errors>0){
		sprintf(statbuf,"Saved %d kanji to \"%.190s\"",errors,logfilename);
		setstatus(statbuf);
	}
}
