;;;
;;; $Id: tm-setup.el,v 7.1 1995/12/20 15:27:35 morioka Exp $
;;;

(require 'tl-misc)


;;; @ for tm-view
;;;

(call-after-loaded
 'tm-view
 (function
  (lambda ()
    ;; for message/partial
    (require 'tm-partial)
    
    ;; for anonymous ftp
    (set-atype 'mime/content-decoding-condition
	       '((type . "message/external-body")
		 ("access-type" . "anon-ftp")
		 (method . mime/decode-message/external-ftp)
		 ))
    (autoload 'mime/decode-message/external-ftp "tm-ftp")

    ;; for text/richtext
    (set-alist 'mime-viewer/content-filter-alist
	       "text/richtext" (function mime-viewer/filter-text/richtext))
    (autoload 'mime-viewer/filter-text/richtext "tm-rich")

    ;; for text/enriched
    (set-alist 'mime-viewer/content-filter-alist
	       "text/enriched" (function mime-viewer/filter-text/enriched))
    (autoload 'mime-viewer/filter-text/enriched "tm-rich")

    ;; for image/*
    (if (string-match "XEmacs" emacs-version)
	(require 'tm-image)
      )
    
    ;; for LaTeX
    (set-atype 'mime/content-decoding-condition
	       '((type . "text/x-latex")
		 (method . mime/decode-text/latex)
		 ))
    (set-atype 'mime/content-decoding-condition
	       '((type . "application/x-latex")
		 (method . mime/decode-text/latex)
		 ))
    ;;(set-atype 'mime/content-decoding-condition
    ;; 	'((type . "application/octet-stream")
    ;;		  ("type" . "latex")
    ;;		  (method . mime/decode-text/latex)
    ;;		  ))
    (autoload 'mime/decode-text/latex "tm-latex")
    )))


;;; @ for RMAIL
;;;

(call-after-loaded 'rmail
		   (function
		    (lambda ()
		      (require 'tm-rmail)
		      ))
		   'rmail-mode-hook)


;;; @ for mh-e
;;;

(let ((le (function
	   (lambda ()
	     (require 'tm-mh-e)
	     ))
	  ))
  (call-after-loaded 'mh-e le 'mh-folder-mode-hook)
  (if (not (featurep 'mh-e))
      (add-hook 'mh-letter-mode-hook le)
    ))


;;; @ for GNUS
;;;

(defvar tm-setup/use-gnusutil nil)

(let ((le (function
	   (lambda ()
	     (require 'tm-gnus)
	     ))
	  ))
  (if (and (boundp 'MULE) tm-setup/use-gnusutil)
      (progn
	(add-hook 'gnus-Group-mode-hook (function gnusutil-initialize))
	(add-hook 'gnus-group-mode-hook (function gnusutil-initialize))
	(autoload 'gnusutil-initialize "gnusutil")
	(autoload 'gnusutil-add-group "gnusutil")
	(add-hook 'gnusutil-initialize-hook le)
	)
    (progn
      (add-hook 'gnus-Startup-hook le 'append)
      (add-hook 'gnus-startup-hook le 'append)
      )))


;;; @ end
;;;

(provide 'tm-setup)

;;; Local Variables:
;;; mode: emacs-lisp
;;; mode: outline-minor
;;; outline-regexp: ";;; @+\\|(......"
;;; End:
