;==============================================================================

; file: "_kernel.scm"

; Copyright (C) 1994-1998 by Marc Feeley, All Rights Reserved.

(##include "header.scm")

(##declare
  (multilisp)
  (standard-bindings)
  (extended-bindings)
  (block)
  (fixnum)
)

(c-declare "

/*---------------------------------------------------------------------------*/

#include \"os.h\"
#include \"setup.h\"
#include \"mem.h\"
#include \"c_intf.h\"

___NEED_GLO(___G__23__23_exception_2e_stack_2d_overflow)
___NEED_GLO(___G__23__23_exception_2e_heap_2d_overflow)
___NEED_GLO(___G__23__23_interrupt_2d_handler)
___NEED_GLO(___G__23__23_exception_2e_wrong_2d_nb_2d_arg)
___NEED_GLO(___G__23__23_exception_2e_unknown_2d_keyword_2d_arg)
___NEED_GLO(___G__23__23_exception_2e_keyword_2d_expected)
___NEED_GLO(___G__23__23_exception_2e_clam_2d_conv_2d_error)
___NEED_GLO(___G__23__23_exception_2e_cdef_2d_conv_2d_error)
___NEED_GLO(___G__23__23_exception_2e_non_2d_proc_2d_jump)
___NEED_GLO(___G__23__23_exception_2e_global_2d_jump)
___NEED_GLO(___G__23__23_rest_2d_param_2d_heap_2d_overflow)
___NEED_GLO(___G__23__23_exception_2e_apply_2d_arg_2d_limit)
___NEED_GLO(___G__23__23_exception_2e_multiple_2d_c_2d_return)

/*---------------------------------------------------------------------------*/

#ifndef ___CC_CMD
#define ___CC_CMD 0
#endif

#ifndef ___LD_CMD
#define ___LD_CMD 0
#endif

")

;------------------------------------------------------------------------------

; The procedure "##initial-continuation" is only a container for the
; kernel handlers.  It must never be called.  The function "___setup"
; in the file "setup.c" is responsible for setting up the kernel handlers.

(define ##initial-continuation
  (let () (##declare (not inline) (not interrupts-enabled)) (lambda ()

(##c-code
"
/*
 * ___LBL(1)
 *
 * This is the internal-return handler.  It is invoked when an
 * internal return point is returned to.
 */

___ps->temp2 = ___R1; /* for return from ##force-undetermined */
___temp = ___POP;
___POP_REGS
___JUMPEXTPRM(___NOTHING,___temp)
" (0))

(##c-code
"
/*
 * ___LBL(2)
 *
 * This is the break handler.  It is invoked when a function
 * attempts to return to its caller and the caller's stack frame
 * is not on top of the stack because it has been captured.
 *
 * At this point the callee will have cleaned up the stack so
 * that the frame pointer (___fp) points to the break frame.
 * The break frame contains the address in the caller where
 * control will return (the return address) and a pointer to
 * the caller's continuation frame, which can either be in the
 * stack or in the heap.  The two situations are depicted below:
 *
 *              STACK                        STACK              HEAP
 *          |            |               |            |                caller's
 *          +------------+               +------------+                frame
 * ___fp -->|  ret adr   |      ___fp -->|  ret adr   |    +------------+
 *          | call frame ---+            | call frame ---->|    HEAD    |
 *          +------------+  |            +------------+    | next frame ---+
 *          |     .      |  |            |     .      |    |  slot fs   |  |
 *          |     .      |  |            |     .      |    |    ...     |  |
 *          +------------+  |            |            |    |  slot 1    |  |
 * caller's |  slot fs   |<-+            |            |    +------------+  |
 * frame    |    ...     |               |            |                    |
 *          |  slot 1    |               |            |    +------------+  |
 *          +------------+               |            |    |    HEAD    |<-+
 *          |     .      |               |     .      |    | next frame ---+
 *          |     .      |               |     .      |    |    ...     |  |
 *          +------------+               +------------+    +------------+  V
 *                                                                        ...
 *
 * These cases are distinguished by the tag on the pointer to the
 * caller's frame.
 *
 * The break handler puts a copy of the caller's frame on the
 * top of the stack, saves the return address it contains into
 * the break frame and replaces it with the address of the
 * break handler.  The frame pointer in the break frame is made
 * to point to the frame of the caller's caller.  Finally a jump
 * to the return address that was originally in the break frame
 * is performed.  At that point the stack will be in the following
 * state respectively:
 *
 *              STACK                        STACK              HEAP
 *          |            |               |            |
 *          +------------+               +------------+
 * ___fp -->|  slot fs   |      ___fp -->|  slot fs   |
 *          |    ...     |               |    ...     |
 *          |  slot 1    |               |  slot 1    |
 *          +------------+               +------------+
 *          |new ret adr |               |new ret adr |    +------------+
 *          |new call fr.---+            |new call fr.--+  |    HEAD    |
 *          +------------+  |            +------------+ |  | next frame ---+
 *          |     .      |  |            |     .      | |  |  slot fs   |  |
 *          |     .      |  |            |     .      | |  |    ...     |  |
 *          +------------+  |            |            | |  |  slot 1    |  |
 *          |  slot fs   |  |            |            | |  +------------+  |
 *          |    ...     |  |            |            | |                  |
 *          |  slot 1    |  |            |            | |  +------------+  |
 *          +------------+  |            |            | +->|    HEAD    |<-+
 *          |     .      |<-+            |     .      |    | next frame ---+
 *          |     .      | (see note)    |     .      |    |    ...     |  |
 *          +------------+               +------------+    +------------+  V
 *                                                                        ...
 *
 * Note: In the first case, the pointer to the caller's frame
 * is normally advanced to the frame following the caller's frame.
 * However, if the frame following the caller's frame is a break
 * frame, then the content of that break frame is copied to the
 * topmost break frame.  This ensures that break frames never
 * contain pointers to other break frames which is needed to
 * properly implement tail-recursion.
 */

{
  ___WORD ora = ___fp[0]; /* original return address            */
  ___WORD ocf = ___fp[1]; /* original pointer to caller's frame */

  if (___TYP(ocf) == ___tSUBTYPED)
    {
      /* caller's frame is in the heap */

      int fs, link, i;

      ___WORD *fp = ___BODY_AS(ocf,___tSUBTYPED); /* get pointer to frame */

      if (ora == ___internal_return)
        {
          ___WORD fs_link = ((___label_struct*)(fp[1]-___tSUBTYPED))->flags;
          fs = ___RETI_INFO_FS(fs_link);
          link = ___RETI_INFO_LINK(fs_link);
        }
      else
        {
          ___WORD fs_link = ((___label_struct*)(ora-___tSUBTYPED))->flags;
          fs = ___RETN_INFO_FS(fs_link);
          link = ___RETN_INFO_LINK(fs_link);
        }
      fp += fs+1;

      ___fp[0] = fp[-link-1];
      ___fp[1] = fp[-fs-1];

      for (i=-fs; i<0; i++)
        ___fp[i] = fp[i];

      ___fp[-link-1] = ___ps->handler_break;
      ___fp -= fs;

      ___JUMPEXTPRM(___NOTHING,ora)
    }
  else if (ocf == 0)
    {
      ___fatal_error (\"No continuation to return to\");
    }
  else
    {
      /* continuation's frame is in the stack */

      ___WORD *fp, frame_ra;
      int fs, link, i;

      if (ora == ___internal_return)
        {
          ___WORD fs_link = ((___label_struct*)(((___WORD*)ocf)[0]-___tSUBTYPED))->flags;
          fs = ___RETI_INFO_FS(fs_link);
          link = ___RETI_INFO_LINK(fs_link);
        }
      else
        {
          ___WORD fs_link = ((___label_struct*)(ora-___tSUBTYPED))->flags;
          fs = ___RETN_INFO_FS(fs_link);
          link = ___RETN_INFO_LINK(fs_link);
        }
      fp = ((___WORD*)ocf)+fs;
      frame_ra = fp[-link-1];

      if (frame_ra == ___ps->handler_break)
        {
          /* first frame of that section */

          ___fp[0] = fp[0];
          ___fp[1] = fp[1];

          for (i=-fs; i<0; i++)
            ___fp[i] = fp[i];

          ___fp -= fs;

          ___JUMPEXTPRM(___NOTHING,ora)
        }
      else
        {
          /* not the first frame of that section */

          ___fp[0] = frame_ra;
          ___fp[1] = (___WORD)fp;

          for (i=-fs; i<0; i++)
            ___fp[i] = fp[i];

          ___fp[-link-1] = ___ps->handler_break;
          ___fp -= fs;

          ___JUMPEXTPRM(___NOTHING,ora)
        }
    }
}" (0))

(##c-code
"
/*
 * ___LBL(3)
 *
 * This is the stack-limit handler.  It is invoked when the stack
 * overflows and when an interrupt is received.
 *
 * This handler checks for which reason it was invoked and dispatches
 * to one of the following procedures:
 *
 *  ##interrupt-handler
 *  ##exception.stack-overflow
 */

{
  ___WORD *stack_trip;

  ___PUSH_REGS                  /* setup internal-return stack frame */
  ___PUSH(___ps->temp1)         /* return address in caller */
  ___SET_R0(___internal_return) /* change return address */

  stack_trip = ___ps->stack_trip; /* get stack trip */

  if (___fp < ___ps->stack_limit) /* stack overflow? */
    {
      int overflow;

      ___fp[-1] = (___WORD)___fp;
      ___fp[-2] = ___R0;
      ___fp -= 2;
      ___ps->stack_break = ___fp;
      ___R0 = ___ps->handler_break;

      ___W_ALL
      overflow = ___gc ();
      ___R_ALL

      if (overflow)
        ___JUMPEXT(___SET_NARGS(0),___G__23__23_exception_2e_stack_2d_overflow.val)
      else
        ___JUMPEXTPRM(___NOTHING,___R0)
    }

  ___ps->stack_trip = ___ps->stack_limit; /* prepare for next intr */

  if (___ps->intr_enabled)
    {
      int i;

      for (i=0; i<___NB_INTRS; i++)
        if (___ps->intr_flag[i])
          break;

      if (i < ___NB_INTRS)
        {
          ___SET_R1(___FIX(i))
          ___ps->intr_flag[i] = 0; /* lower flag */
          for (i=i+1; i<___NB_INTRS; i++)
            if (___ps->intr_flag[i]) /* make sure other intr is not ignored */
              {
                ___ps->stack_trip = ___ps->stack_base;
                break;
              }
          ___JUMPEXT(___SET_NARGS(1),___G__23__23_interrupt_2d_handler.val)
        }
    }

  ___JUMPEXTPRM(___NOTHING,___ps->temp1)
}" (0))

(##c-code
"
/*
 * ___LBL(4)
 *
 * This is the heap-limit handler.  It is invoked when the heap
 * pointer reaches the end of the current msection.
 *
 * This handler simply calls ##check-heap.
 */

{
  ___PUSH_REGS                  /* setup internal-return stack frame */
  ___PUSH(___ps->temp1)         /* return address in caller */
  ___SET_R0(___internal_return) /* change return address */
  ___JUMPEXT(___SET_NARGS(0),___G__23__23_check_2d_heap.val)
}" (0))

(##c-code
"
/*
 * ___LBL(5)
 *
 * This is the call to non-procedure handler.  It is invoked when
 * there is an attempt to call an object that is not a procedure.
 *
 * This handler simply tail calls ##exception.non-proc-jump (i.e.
 * the continuation will be the same as that of the faulty call).  The
 * arguments are the object that was in operator position followed by
 * the arguments of the faulty call.
 */

{
  int na = ___ps->na;
  int i;

  ___PUSH_ARGS_IN_REGS(na)  /* save all arguments that are in registers */
  ___PUSH(0)                /* make space for operator */

  for (i=0; i<na; i++)
    ___fp[i] = ___fp[i+1];  /* shift arguments up by one */
  ___fp[na] = ___ps->temp1; /* set operator argument */

  ___POP_ARGS_IN_REGS(na+1) /* prepare call to error handler */

  ___JUMPEXT(___SET_NARGS(na+1),___G__23__23_exception_2e_non_2d_proc_2d_jump.val)
}
" (0))

(##c-code
"
/*
 * ___LBL(6)
 *
 * This is the call to global non-procedure handler.  It is invoked
 * when there is an attempt to call an object that is not a procedure
 * that is bound to a global variable.
 *
 * This handler simply tail calls ##exception.global-jump or
 * ##exception.non-proc-jump (i.e. the continuation will be the same as
 * that of the faulty call).  ##exception.global-jump is called
 * when the global variable's name is known (in this case the
 * arguments are the variable's name followed by the arguments of the
 * faulty call).  Otherwise, ##exception.non-proc-jump is called
 * and the arguments are the object that was in operator position
 * followed by the arguments of the faulty call.
 */

{
  int na = ___ps->na;
  int i;
  ___WORD sym, probe, result, fn;

  ___PUSH_ARGS_IN_REGS(na)

  ___PUSH(0)

  for (i=0; i<na; i++)
    ___fp[i] = ___fp[i+1];

  result = ((___glo_struct*)___ps->temp4)->val;
  fn = ___G__23__23_exception_2e_non_2d_proc_2d_jump.val;

  i = ___INT(___VECTORLENGTH(___symbol_table)) - 1;

  while (i>=0)
    {
      probe = ___VECTORREF(___symbol_table,___FIX(i));

      while (probe != ___NUL)
        {
          sym = ___CAR(probe);
          if (___ps->temp4 == ___VECTORREF(sym,___FIX(2)))
            {
              result = sym;
              fn = ___G__23__23_exception_2e_global_2d_jump.val;
              break;
            }
          probe = ___CDR(probe);
        }
      i--;
    }

  ___fp[na] = result;

  ___POP_ARGS_IN_REGS(na+1)

  ___JUMPEXT(___SET_NARGS(na+1),fn)
}" (0))

(##c-code
"
/*
 * ___LBL(7)
 *
 * This is the wrong number of arguments handler.  It is invoked when
 * a procedure is called with a number of arguments that it does not
 * accept.
 *
 * This handler simply tail calls ##exception.non-proc-jump (i.e.
 * the continuation will be the same as that of the faulty call).  The
 * arguments are the object that was in operator position followed by
 * the arguments of the faulty call.
 */

{
  int na = ___ps->na;
  int i;

  ___PUSH_ARGS_IN_REGS(na)

  ___PUSH(0)

  for (i=0; i<na; i++)
    ___fp[i] = ___fp[i+1];

  if (___RETN_INFO_LINK(((___label_struct*)(___ps->temp1-___tSUBTYPED))->flags) == 0)
    ___fp[na] = ___ps->temp1;
  else
    ___fp[na] = ___SELF;

  ___POP_ARGS_IN_REGS(na+1)

  ___JUMPEXT(___SET_NARGS(na+1),___G__23__23_exception_2e_wrong_2d_nb_2d_arg.val)
}" (0))

(##c-code
"
/*
 * ___LBL(8)
 *
 * This is the rest parameter handler.  It is invoked when a non-null
 * rest parameter must be constructed.
 *
 */

{
  int n;
  ___WORD z = ((___label_struct*)(___ps->temp1-___tSUBTYPED))->flags;
  int nb_parms = (z>>3)&((1<<14)-1);

  ___PUSH_ARGS_IN_REGS(___ps->na)

  if (___ps->na < nb_parms)
    {
      int na = ___ps->na;
      int i;
      ___PUSH(0)

      for (i=0; i<na; i++)
        ___fp[i] = ___fp[i+1];
      ___fp[na] = ___ps->temp1;

      ___POP_ARGS_IN_REGS(na+1)

      ___JUMPEXT(___SET_NARGS(na+1),___G__23__23_exception_2e_wrong_2d_nb_2d_arg.val)
    }

  ___SET_R1(___NUL)
  n = ___ps->na - nb_parms + 1;
  while (n > 0)
    {
      ___SET_R1(___CONS(___POP,___R1))
      n--;
    }

  if (___hp > ___ps->heap_limit)
    {
      int overflow;
      ___W_ALL
      overflow = ___heap_limit ();
      ___R_ALL
      if (overflow)
        {
          n = nb_parms - 1;
          while (n > 0)
            {
              ___SET_R1(___CONS(___POP,___R1))
              n--;
            }
          ___PUSH(___SELF)
          ___PUSH(___R1)
          ___POP_ARGS_IN_REGS(2)
          ___JUMPEXT(___SET_NARGS(2),___G__23__23_rest_2d_param_2d_heap_2d_overflow.val)
        }
    }

  ___PUSH(___R1)

  ___POP_ARGS_IN_REGS(nb_parms)

  ___JUMPEXTPRM(___SET_NARGS(-1),___ps->temp1)
}" (0))

(##c-code
"
/*
 * ___LBL(9)
 *
 * This is the keyword parameter handler.  It is invoked when keyword
 * parameters must be processed.
 *
 */

{
  ___WORD z = ((___label_struct*)(___ps->temp1-___tSUBTYPED))->flags;
  int nb_parms = (z>>3)&((1<<14)-1);
  ___WORD key_descr = ___ps->temp3;
  int nb_req_opt = ___ps->temp2;
  int nb_key = nb_parms-nb_req_opt;
  int i, j, k;

  ___PUSH_ARGS_IN_REGS(___ps->na)

  k = ___ps->na-nb_req_opt;

  if (___ps->na < nb_req_opt)
    goto wrong_nb_args1;

  for (j=nb_key-1; j>=0; j--)
    ___fp[-1-j] = ___FIELD(key_descr,j*2+1);

  for (i=1; i<=k; i+=2)
    {
      ___WORD key = ___fp[i];
      for (j=nb_key-1; j>=0; j--)
        if (key==___FIELD(key_descr,j*2))
          {
            ___fp[-1-j] = ___fp[i-1];
            goto continue_i1;
          }
      {
        int na = ___ps->na;
        int i;
        ___PUSH(0)

        for (i=0; i<na; i++)
          ___fp[i] = ___fp[i+1];
        ___fp[na] = ___ps->temp1;

        ___POP_ARGS_IN_REGS(na+1)

        if (!___KEYWORDP(key))
          ___JUMPEXT(___SET_NARGS(na+1),___G__23__23_exception_2e_keyword_2d_expected.val)
        else
          ___JUMPEXT(___SET_NARGS(na+1),___G__23__23_exception_2e_unknown_2d_keyword_2d_arg.val)
      }
      continue_i1:;
    }

  if (k & 1) /* keyword arguments must come in pairs */
    wrong_nb_args1:
    {
      int na = ___ps->na;
      int i;
      ___PUSH(0)

      for (i=0; i<na; i++)
        ___fp[i] = ___fp[i+1];
      ___fp[na] = ___ps->temp1;

      ___POP_ARGS_IN_REGS(na+1)

      ___JUMPEXT(___SET_NARGS(na+1),___G__23__23_exception_2e_wrong_2d_nb_2d_arg.val)
    }

  ___fp += k;
  for (i=0; i<nb_key; i++)
    {
      ___fp--;
      *___fp = *(___fp-k);
    }

  ___POP_ARGS_IN_REGS(nb_parms)

  ___JUMPEXTPRM(___SET_NARGS(-1),___ps->temp1)
}" (0))

(##c-code
"
/*
 * ___LBL(10)
 *
 * This is the keyword and rest parameter handler.  It is invoked when
 * keyword parameters must be processed and a rest parameter must be
 * constructed.
 *
 */

{
  ___WORD z = ((___label_struct*)(___ps->temp1-___tSUBTYPED))->flags;
  int nb_parms = (z>>3)&((1<<14)-1);
  ___WORD key_descr = ___ps->temp3;
  int nb_req_opt = ___ps->temp2;
  int nb_key = nb_parms-1-nb_req_opt;
  int i, j, k, n;

  ___PUSH_ARGS_IN_REGS(___ps->na)

  k = ___ps->na-nb_req_opt;

  if (___ps->na < nb_req_opt)
    goto wrong_nb_args2;

  for (j=nb_key-1; j>=0; j--)
    ___fp[-1-j] = ___FIELD(key_descr,j*2+1);

  for (i=1; i<=k; i+=2)
    {
      ___WORD key = ___fp[i];
      for (j=nb_key-1; j>=0; j--)
        if (key==___FIELD(key_descr,j*2))
          {
            ___fp[-1-j] = ___fp[i-1];
            goto continue_i2;
          }
      if (!___KEYWORDP(key))
        {
          int na = ___ps->na;
          int i;
          ___PUSH(0)

          for (i=0; i<na; i++)
            ___fp[i] = ___fp[i+1];
          ___fp[na] = ___ps->temp1;

          ___POP_ARGS_IN_REGS(na+1)

          ___JUMPEXT(___SET_NARGS(na+1),___G__23__23_exception_2e_keyword_2d_expected.val)
        }
      continue_i2:;
    }

  if (k & 1) /* keyword arguments must come in pairs */
    wrong_nb_args2:
    {
      int na = ___ps->na;
      int i;
      ___PUSH(0)

      for (i=0; i<na; i++)
        ___fp[i] = ___fp[i+1];
      ___fp[na] = ___ps->temp1;

      ___POP_ARGS_IN_REGS(na+1)

      ___JUMPEXT(___SET_NARGS(na+1),___G__23__23_exception_2e_wrong_2d_nb_2d_arg.val)
    }

  ___SET_R1(___NUL)
  i = k;
  while (i > 0)
    {
      ___SET_R1(___CONS(___POP,___R1))
      i--;
    }

  if (___hp > ___ps->heap_limit)
    {
      int overflow;
      ___W_ALL
      overflow = ___heap_limit ();
      ___R_ALL
      if (overflow)
        {
          n = nb_req_opt;
          while (n > 0)
            {
              ___SET_R1(___CONS(___POP,___R1))
              n--;
            }
          ___PUSH(___SELF)
          ___PUSH(___R1)
          ___POP_ARGS_IN_REGS(2)
          ___JUMPEXT(___SET_NARGS(2),___G__23__23_rest_2d_param_2d_heap_2d_overflow.val)
        }
    }

  for (i=0; i<nb_key; i++)
    {
      ___fp--;
      *___fp = *(___fp-k);
    }

  ___PUSH(___R1)

  ___POP_ARGS_IN_REGS(nb_parms)

  ___JUMPEXTPRM(___SET_NARGS(-1),___ps->temp1)
}" (0))

(##c-code
"
/*
 * ___LBL(11)
 *
 * This is the force handler.  It is invoked when a promise is forced.
 */

{
  ___WORD x = ___ps->temp2;
  ___WORD y = ___UNTAG_AS(x,___tSUBTYPED)[2];
  if (x != y)
    {
      ___ps->temp2 = y;
      ___JUMPEXTPRM(___NOTHING,___ps->temp1)
    }
  else
    {
      ___WORD z = ___UNTAG_AS(x,___tSUBTYPED)[1];
      ___PUSH_REGS
      ___PUSH(___ps->temp1)
      ___PUSH(x)
      ___PUSH(z)
      ___POP_ARGS_IN_REGS(2)
      ___SET_R0(___internal_return)
      ___JUMPEXT(___SET_NARGS(2),___G__23__23_force_2d_undetermined.val)
    }
}" (0))

(##c-code
"
/*
 * ___LBL(12)
 *
 * This is the 'c-lambda' conversion error handler.  It is invoked
 * when an error is detected by the C-interface in a 'c-lambda' during
 * a data representation conversion between Scheme and C.
 */

{
  int na = ___ps->na;
  int i;

  ___POP; /* discard stack marker */
  ___SET_R0(___POP) /* get return address */

  ___PUSH(0) /* make space for 2 new arguments */
  ___PUSH(0)

  for (i=0; i<na; i++)
    ___fp[i] = ___fp[i+2];
  ___fp[na] = ___ps->temp1;
  ___fp[na+1] = ___ps->temp2;

  ___POP_ARGS_IN_REGS(na+2)

  ___JUMPEXT(___SET_NARGS(na+2),___G__23__23_exception_2e_clam_2d_conv_2d_error.val)
}" (0))

(##c-code
"
/*
 * ___LBL(13)
 *
 * This is the 'c-define' conversion error handler.  It is invoked
 * when an error is detected by the C-interface in a 'c-define' during
 * a data representation conversion between Scheme and C.
 */

___PUSH(___ps->temp1)
___PUSH(___ps->temp2)

___POP_ARGS_IN_REGS(2)

___JUMPEXT(___SET_NARGS(2),___G__23__23_exception_2e_cdef_2d_conv_2d_error.val)
" (0))

(##c-code
"
/*
 * ___LBL(14)
 *
 * This is the return to C handler.  It is invoked when control
 * must return to C (i.e. back from the call to ___call).
 */

{
  ___WORD unwind_destination = ___STK(0);
  if (___FIELD(unwind_destination,0) == ___TRU) /* first return? */
    {
      ___W_ALL
      ___propagate_error (___UNWIND_C_STACK);
    }
  else
    ___JUMPEXT(___SET_NARGS(0),___G__23__23_exception_2e_multiple_2d_c_2d_return.val)
}
" (0))

(let ((dummy (##first-argument 0))) (##c-code
"
/*
 * ___LBL(15)
 *
 * This is the initial continuation.  It is invoked when control
 * must return from the initial call to ___call.
 */

{
  ___WORD unwind_destination = ___STK(0);
  ___SET_R0(___ps->initial_continuation);
  if (___FIELD(unwind_destination,0) == ___TRU) /* first return? */
    {
      ___W_ALL
      ___propagate_error (___UNWIND_C_STACK);
    }
  else
    ___JUMPEXT(___SET_NARGS(0),___G__23__23_exception_2e_multiple_2d_c_2d_return.val)
}
" (0)) dummy))))

;------------------------------------------------------------------------------

; Memory allocation

(define (##make-vector n init)
  (let ((v (##c-code "
{
long i;
long n = ___INT(___ARG1);
long words = n + 1;
___WORD result;
if (n > (___LMASK>>(___LF+___LWS)))
  result = ___FAL; /* abort if requested object is too big */
else if (words > ___MSECTION_BIGGEST)
  {
    ___W_ALL
    result = ___alloc_scmobj (___sVECTOR, n<<___LWS, ___STILL);
    ___R_ALL
    if (result != ___FAL)
      ___still_obj_refcount_dec (result);
  }
else
  {
    int overflow = 0;
    ___hp += words;
    if (___hp > ___ps->heap_limit)
      {
        ___W_ALL
        overflow = ___heap_limit ();
        ___R_ALL
      }
    else
      ___hp -= words;
    if (overflow)
      result = ___FAL;
    else
      {
        result = ___TAG(___hp, ___tSUBTYPED);
        ___HEADER(result) = ___MAKE_HD_WORDS(n, ___sVECTOR);
        ___hp += words;
      }
  }
if (result != ___FAL)
  {
    for (i=0; i<n; i++)
      ___VECTORSET(result,___FIX(i),___ARG2)
  }
___RESULT = result;
}
" n init)))
    (or v
        (begin
          (##exception.heap-overflow)
          (##make-vector n init)))))

(define (##make-string n init)
  (let ((s (##c-code "
{
long i;
long n = ___INT(___ARG1);
long words = ___WORDS((n<<___LCS)) + 1;
___WORD result;
if (n > (___LMASK>>(___LF+___LCS)))
  result = ___FAL; /* abort if requested object is too big */
else if (words > ___MSECTION_BIGGEST)
  {
    ___W_ALL
    result = ___alloc_scmobj (___sSTRING, n<<___LCS, ___STILL);
    ___R_ALL
    if (result != ___FAL)
      ___still_obj_refcount_dec (result);
  }
else
  {
    int overflow = 0;
    ___hp += words;
    if (___hp > ___ps->heap_limit)
      {
        ___W_ALL
        overflow = ___heap_limit ();
        ___R_ALL
      }
    else
      ___hp -= words;
    if (overflow)
      result = ___FAL;
    else
      {
        result = ___TAG(___hp, ___tSUBTYPED);
        ___HEADER(result) = ___MAKE_HD_BYTES((n<<___LCS), ___sSTRING);
        ___hp += words;
      }
  }
if (result != ___FAL)
  {
    for (i=0; i<n; i++)
      ___STRINGSET(result,___FIX(i),___ARG2);
  }
___RESULT = result;
}
" n init)))
    (or s
        (begin
          (##exception.heap-overflow)
          (##make-string n init)))))

(define (##make-u8vector n init)
  (let ((v (##c-code "
{
long i;
long n = ___INT(___ARG1);
long words = ___WORDS(n) + 1;
___WORD result;
if (n > (___LMASK>>___LF))
  result = ___FAL; /* abort if requested object is too big */
else if (words > ___MSECTION_BIGGEST)
  {
    ___W_ALL
    result = ___alloc_scmobj (___sU8VECTOR, n, ___STILL);
    ___R_ALL
    if (result != ___FAL)
      ___still_obj_refcount_dec (result);
  }
else
  {
    int overflow = 0;
    ___hp += words;
    if (___hp > ___ps->heap_limit)
      {
        ___W_ALL
        overflow = ___heap_limit ();
        ___R_ALL
      }
    else
      ___hp -= words;
    if (overflow)
      result = ___FAL;
    else
      {
        result = ___TAG(___hp, ___tSUBTYPED);
        ___HEADER(result) = ___MAKE_HD_BYTES(n, ___sU8VECTOR);
        ___hp += words;
      }
  }
if (result != ___FAL)
  {
    for (i=0; i<n; i++)
      ___U8VECTORSET(result,___FIX(i),___ARG2)
  }
___RESULT = result;
}
" n init)))
    (or v
        (begin
          (##exception.heap-overflow)
          (##make-u8vector n init)))))

(define (##make-u16vector n init)
  (let ((v (##c-code "
{
long i;
long n = ___INT(___ARG1);
long words = ___WORDS((n<<1)) + 1;
___WORD result;
if (n > (___LMASK>>(___LF+1)))
  result = ___FAL; /* abort if requested object is too big */
else if (words > ___MSECTION_BIGGEST)
  {
    ___W_ALL
    result = ___alloc_scmobj (___sU16VECTOR, n<<1, ___STILL);
    ___R_ALL
    if (result != ___FAL)
      ___still_obj_refcount_dec (result);
  }
else
  {
    int overflow = 0;
    ___hp += words;
    if (___hp > ___ps->heap_limit)
      {
        ___W_ALL
        overflow = ___heap_limit ();
        ___R_ALL
      }
    else
      ___hp -= words;
    if (overflow)
      result = ___FAL;
    else
      {
        result = ___TAG(___hp, ___tSUBTYPED);
        ___HEADER(result) = ___MAKE_HD_BYTES((n<<1), ___sU16VECTOR);
        ___hp += words;
      }
  }
if (result != ___FAL)
  {
    for (i=0; i<n; i++)
      ___U16VECTORSET(result,___FIX(i),___ARG2)
  }
___RESULT = result;
}
" n init)))
    (or v
        (begin
          (##exception.heap-overflow)
          (##make-u16vector n init)))))

(define (##make-u32vector n init)
  (let ((v (##c-code "
{
long i;
long n = ___INT(___ARG1);
long words = ___WORDS((n<<2)) + 1;
___WORD result;
if (n > (___LMASK>>(___LF+2)))
  result = ___FAL; /* abort if requested object is too big */
else if (words > ___MSECTION_BIGGEST)
  {
    ___W_ALL
    result = ___alloc_scmobj (___sU32VECTOR, n<<2, ___STILL);
    ___R_ALL
    if (result != ___FAL)
      ___still_obj_refcount_dec (result);
  }
else
  {
    int overflow = 0;
    ___hp += words;
    if (___hp > ___ps->heap_limit)
      {
        ___W_ALL
        overflow = ___heap_limit ();
        ___R_ALL
      }
    else
      ___hp -= words;
    if (overflow)
      result = ___FAL;
    else
      {
        result = ___TAG(___hp, ___tSUBTYPED);
        ___HEADER(result) = ___MAKE_HD_BYTES((n<<2), ___sU32VECTOR);
        ___hp += words;
      }
  }
if (result != ___FAL)
  {
    for (i=0; i<n; i++)
      ___U32VECTORSET(result,___FIX(i),___ARG2)
  }
___RESULT = result;
}
" n init)))
    (or v
        (begin
          (##exception.heap-overflow)
          (##make-u32vector n init)))))

(define (##make-f32vector n init)
  (let ((v (##c-code "
{
long i;
long n = ___INT(___ARG1);
long words = ___WORDS((n<<2)) + 1;
___WORD result;
if (n > (___LMASK>>(___LF+2)))
  result = ___FAL; /* abort if requested object is too big */
else if (words > ___MSECTION_BIGGEST)
  {
    ___W_ALL
    result = ___alloc_scmobj (___sF32VECTOR, n<<2, ___STILL);
    ___R_ALL
    if (result != ___FAL)
      ___still_obj_refcount_dec (result);
  }
else
  {
    int overflow = 0;
    ___hp += words;
    if (___hp > ___ps->heap_limit)
      {
        ___W_ALL
        overflow = ___heap_limit ();
        ___R_ALL
      }
    else
      ___hp -= words;
    if (overflow)
      result = ___FAL;
    else
      {
        result = ___TAG(___hp, ___tSUBTYPED);
        ___HEADER(result) = ___MAKE_HD_BYTES((n<<2), ___sF32VECTOR);
        ___hp += words;
      }
  }
if (result != ___FAL)
  {
    ___F64 init = ___F64UNBOX(___ARG2);
    for (i=0; i<n; i++)
      ___F32VECTORSET(result,___FIX(i),init)
  }
___RESULT = result;
}
" n init)))
    (or v
        (begin
          (##exception.heap-overflow)
          (##make-f32vector n init)))))

(define (##make-f64vector n init)
  (let ((v (##c-code "
{
long i;
long n = ___INT(___ARG1);
#if ___WS == 4
long words = ___WORDS((n<<3)) + 2;
#else
long words = ___WORDS((n<<3)) + 1;
#endif
___WORD result;
if (n > (___LMASK>>(___LF+3)))
  result = ___FAL; /* abort if requested object is too big */
else if (words > ___MSECTION_BIGGEST)
  {
    ___W_ALL
    result = ___alloc_scmobj (___sF64VECTOR, n<<3, ___STILL);
    ___R_ALL
    if (result != ___FAL)
      ___still_obj_refcount_dec (result);
  }
else
  {
    int overflow = 0;
    ___hp += words;
    if (___hp > ___ps->heap_limit)
      {
        ___W_ALL
        overflow = ___heap_limit ();
        ___R_ALL
      }
    else
      ___hp -= words;
    if (overflow)
      result = ___FAL;
    else
      {
#if ___WS == 4
        result = ___TAG(((___WORD*)((___WORD)(___hp+2)&~7)-1), ___tSUBTYPED);
#else
        result = ___TAG(___hp, ___tSUBTYPED);
#endif
        ___HEADER(result) = ___MAKE_HD_BYTES((n<<3), ___sF64VECTOR);
        ___hp += words;
      }
  }
if (result != ___FAL)
  {
    ___F64 init = ___F64UNBOX(___ARG2);
    for (i=0; i<n; i++)
      ___F64VECTORSET(result,___FIX(i),init)
  }
___RESULT = result;
}
" n init)))
    (or v
        (begin
          (##exception.heap-overflow)
          (##make-f64vector n init)))))

;------------------------------------------------------------------------------

; Procedure application and continuations

(define ##apply
  (let ()
    (##declare (not inline))
    (lambda (proc args)
      (define (apply proc args) ; to make sure stack overflow is checked
        (##c-code "
{
  ___WORD proc = ___ARG1; /* procedure to call   */
  ___WORD args = ___ARG2; /* arguments to pass   */
  int n = 0;              /* number of arguments */

  while (___PAIRP(args))
    {
      ___PUSH(___CAR(args))
      args = ___CDR(args);
      n++;
      if (n > ___MAX_NB_ARGS)
        {
          ___ADJFP(-n); /* remove pushed arguments */
          ___PUSH(___ARG1)
          ___PUSH(___ARG2)
          ___POP_ARGS_IN_REGS(2)
          ___JUMPEXT(___SET_NARGS(2),___G__23__23_exception_2e_apply_2d_arg_2d_limit.val)
        }
    }

  ___POP_ARGS_IN_REGS(n)

  ___JUMPEXT(___SET_NARGS(n),proc)
}"
          proc
          args))
      (apply proc args))))

(define ##call-with-current-continuation
  (let ()
    (##declare (not inline))
    (lambda (p)
      (let ((v (##c-code "
{
  ___WORD frame, ra;

  if (___R0 == ___ps->handler_break)
    {
      frame = ___fp[1];
      ra    = ___fp[0];
    }
  else
    {
      frame = (___WORD)___fp;
      ra    = ___R0;
      ___fp[-1] = frame;
      ___fp[-2] = ra;
      ___fp -= 2;
      ___ps->stack_break = ___fp;
      ___R0 = ___ps->handler_break;
    }

  ___hp[0]=___MAKE_HD_WORDS(___CONTINUATION_SIZE,___sCONTINUATION);
  ___ADD_VECTOR_ELEM(0,frame)
  ___ADD_VECTOR_ELEM(1,ra)
  ___ADD_VECTOR_ELEM(2,___ARG1)
  ___hp+=___CONTINUATION_SIZE+1;
  ___RESULT = ___GET_VECTOR(___CONTINUATION_SIZE);
}" ##dynamic-environment)))
        (p
          (lambda (x)
            (##c-code "
{
  ___WORD v = ___ARG1;
  ___WORD x = ___ARG2;
  ___fp = ___ps->stack_break;
  ___fp[1] = ___VECTORREF(v,___FIX(0));
  ___fp[0] = ___VECTORREF(v,___FIX(1));
  ___G__23__23_dynamic_2d_environment.val = ___VECTORREF(v,___FIX(2));
  ___SET_R1(x)
  ___JUMPEXTPRM(___NOTHING,___ps->handler_break)
}" v x)))))))

(define (##continuation->frame c)
  (##closure-ref c 1))

(define (##frame-ret f)
  (##c-code "
{
  ___WORD f = ___ARG1;
  ___WORD frame = ___VECTORREF(f,___FIX(0));
  ___WORD ra    = ___VECTORREF(f,___FIX(1));

  if (___TYP(frame)==___tSUBTYPED)
    {
      /* continuation's frame is in the heap */

      if (ra == ___internal_return)
        ___RESULT = ___BODY_AS(frame,___tSUBTYPED)[1];
      else
        ___RESULT = ra;
    }
  else
    {
      /* continuation's frame is in the stack */

      if (ra == ___internal_return)
        ___RESULT = ((___WORD*)frame)[0];
      else
        ___RESULT = ra;
    }
}" f))

(define (##frame-dyn-env f)
  (##vector-ref f 2))

(define (##frame-fs f)
  (##c-code "
{
  ___WORD f = ___ARG1;
  ___WORD frame = ___VECTORREF(f,___FIX(0));
  ___WORD ra    = ___VECTORREF(f,___FIX(1));
  int fs;

  if (___TYP(frame)==___tSUBTYPED)
    {
      /* continuation's frame is in the heap */

      if (ra == ___internal_return)
        {
          ___WORD fs_link = ((___label_struct*)(___BODY_AS(frame,___tSUBTYPED)[1]-___tSUBTYPED))->flags;
          fs = (fs_link>>3)&((1<<14)-1);
        }
      else
        {
          ___WORD fs_link = ((___label_struct*)(ra-___tSUBTYPED))->flags;
          fs = (fs_link>>3)&((1<<14)-1);
        }
    }
  else
    {
      /* continuation's frame is in the stack */

      if (ra == ___internal_return)
        {
          ___WORD fs_link = ((___label_struct*)(((___WORD*)frame)[0]-___tSUBTYPED))->flags;
          fs = (fs_link>>3)&((1<<14)-1);
        }
      else
        {
          ___WORD fs_link = ((___label_struct*)(ra-___tSUBTYPED))->flags;
          fs = (fs_link>>3)&((1<<14)-1);
        }
    }

  ___RESULT = ___FIX(fs);
}" f))

(define (##frame-stk-ref f i)
  (##c-code "
{
  ___WORD f = ___ARG1;
  int i = ___INT(___ARG2);
  ___WORD frame = ___VECTORREF(f,___FIX(0));
  ___WORD ra    = ___VECTORREF(f,___FIX(1));
  int fs;

  if (___TYP(frame)==___tSUBTYPED)
    {
      /* continuation's frame is in the heap */

      if (ra == ___internal_return)
        {
          ___WORD fs_link = ((___label_struct*)(___BODY_AS(frame,___tSUBTYPED)[1]-___tSUBTYPED))->flags;
          fs = (fs_link>>3)&((1<<14)-1);
        }
      else
        {
          ___WORD fs_link = ((___label_struct*)(ra-___tSUBTYPED))->flags;
          fs = (fs_link>>3)&((1<<14)-1);
        }
      ___RESULT = ___BODY_AS(frame,___tSUBTYPED)[fs-i+1];  /* what if i==link and frame is first in section???? */
    }
  else
    {
      /* continuation's frame is in the stack */

      if (ra == ___internal_return)
        {
          ___WORD fs_link = ((___label_struct*)(((___WORD*)frame)[0]-___tSUBTYPED))->flags;
          fs = (fs_link>>3)&((1<<14)-1);
        }
      else
        {
          ___WORD fs_link = ((___label_struct*)(ra-___tSUBTYPED))->flags;
          fs = (fs_link>>3)&((1<<14)-1);
        }
      ___RESULT = ((___WORD*)frame)[fs-i];  /* what if i==link and frame is first in section???? */
    }

}" f i))

(define (##frame-next f)
  (let ((next (##c-code "
{
  ___WORD f = ___ARG1;
  ___WORD frame = ___VECTORREF(f,___FIX(0));
  ___WORD ra    = ___VECTORREF(f,___FIX(1));
  ___WORD denv  = ___VECTORREF(f,___FIX(2));
  ___WORD *fp, frame_ra, next_ra, next_frame;
  int fs, link;

  if (___TYP(frame)==___tSUBTYPED)
    {
      /* continuation's frame is in the heap */

      fp = ___BODY_AS(frame,___tSUBTYPED);

      if (ra == ___internal_return)
        {
          ___WORD fs_link = ((___label_struct*)(fp[1]-___tSUBTYPED))->flags;
          fs = ___RETI_INFO_FS(fs_link);
          link = ___RETI_INFO_LINK(fs_link);
        }
      else
        {
          ___WORD fs_link = ((___label_struct*)(ra-___tSUBTYPED))->flags;
          fs = ___RETN_INFO_FS(fs_link);
          link = ___RETN_INFO_LINK(fs_link);
        }
      fp += fs+1;

      next_ra = fp[-link-1];
      next_frame = fp[-fs-1];

      if (next_frame == 0)
        ___RESULT = ___FAL;
      else
        {
          ___hp[0]=___MAKE_HD_WORDS(___CONTINUATION_SIZE,___sCONTINUATION);
          ___ADD_VECTOR_ELEM(0,next_frame)
          ___ADD_VECTOR_ELEM(1,next_ra)
          ___ADD_VECTOR_ELEM(2,denv)
          ___hp+=___CONTINUATION_SIZE+1;
          ___RESULT = ___GET_VECTOR(___CONTINUATION_SIZE);
        }
    }
  else
    {
      /* continuation's frame is in the stack */

      if (ra == ___internal_return)
        {
          ___WORD fs_link = ((___label_struct*)(((___WORD*)frame)[0]-___tSUBTYPED))->flags;
          fs = ___RETI_INFO_FS(fs_link);
          link = ___RETI_INFO_LINK(fs_link);
        }
      else
        {
          ___WORD fs_link = ((___label_struct*)(ra-___tSUBTYPED))->flags;
          fs = ___RETN_INFO_FS(fs_link);
          link = ___RETN_INFO_LINK(fs_link);
        }
      fp = ((___WORD*)frame)+fs;
      frame_ra = fp[-link-1];

      if (frame_ra == ___ps->handler_break)
        {
          /* first frame of that section */

          next_ra    = fp[0];
          next_frame = fp[1];
        }
      else
        {
          /* not the first frame of that section */

          next_ra    = frame_ra;
          next_frame = (___WORD)fp;
        }

      if (next_frame == 0)
        ___RESULT = ___FAL;
      else
        {
          ___hp[0]=___MAKE_HD_WORDS(___CONTINUATION_SIZE,___sCONTINUATION);
          ___ADD_VECTOR_ELEM(0,next_frame)
          ___ADD_VECTOR_ELEM(1,next_ra)
          ___ADD_VECTOR_ELEM(2,denv)
          ___hp+=___CONTINUATION_SIZE+1;
          ___RESULT = ___GET_VECTOR(___CONTINUATION_SIZE);
        }
    }
}" f)))
    (##check-heap)
    next))

(define (##closure? x)
  (##c-code "
{
  if (___TYP(___ARG1) == ___tSUBTYPED &&
      ((___label_struct*)(___ARG1-___tSUBTYPED))->entry != ___ARG1)
    ___RESULT = ___TRU;
  else
    ___RESULT = ___FAL;
}" x))

(define (##subprocedure? x)
  (##c-code "
{
  if (___TYP(___ARG1) == ___tSUBTYPED &&
      ((___label_struct*)(___ARG1-___tSUBTYPED))->entry == ___ARG1 &&
      ((___WORD *)(___ARG1-___tSUBTYPED))[-___LS] != ___MAKE_HD((___INTRO_SIZE<<___LWS),___sVECTOR,___PERM))
    ___RESULT = ___TRU;
  else
    ___RESULT = ___FAL;
}" x))

(define (##subprocedure-id x)
  (##c-code "
{
  if (___TYP(___ARG1) == ___tSUBTYPED)
  {
    ___WORD *start = ((___WORD *)(___ARG1-___tSUBTYPED));
    ___WORD *ptr = start;
    while (*ptr != ___MAKE_HD((___INTRO_SIZE<<___LWS),___sVECTOR,___PERM)) ptr -= ___LS;
    ptr += ___LS;
    ___RESULT = ___FIX( (start-ptr)/___LS );
  }
  else
    ___RESULT = ___FIX(0);
}" x))

(define (##subprocedure-parent x)
  (##c-code "
{
  if (___TYP(___ARG1) == ___tSUBTYPED)
  {
    ___WORD *start = ((___WORD *)(___ARG1-___tSUBTYPED));
    ___WORD *ptr = start;
    while (*ptr != ___MAKE_HD((___INTRO_SIZE<<___LWS),___sVECTOR,___PERM)) ptr -= ___LS;
    ptr += ___LS;
   ___RESULT = ___TAG(ptr,___tSUBTYPED);
  }
  else
    ___RESULT = ___FAL;
}" x))

(define (##procedure-info x)
  (##c-code "
{
  if (___TYP(___ARG1) == ___tSUBTYPED)
  {
    ___WORD *start = ((___WORD *)(___ARG1-___tSUBTYPED));
    ___WORD *ptr = start;
    while (*ptr != ___MAKE_HD((___INTRO_SIZE<<___LWS),___sVECTOR,___PERM)) ptr -= ___LS;
   ___RESULT = ptr[1];
  }
  else
    ___RESULT = ___FAL;
}" x))

(define ##dynamic-environment '())

(define (##dynamic-env-bind dyn-env thunk)
  (let ((env ##dynamic-environment))
    (set! ##dynamic-environment dyn-env)
    (let ((val (thunk)))
      (set! ##dynamic-environment env)
      val)))

(define (##dynamic-env-ref)
  ##dynamic-environment)

;------------------------------------------------------------------------------

; Global variables

(define (##make-global-var id)
  (##c-code "
if (___VECTORREF(___ARG1,___FIX(2)) == 0)
{
___glo_struct *p = ___alloc_global_var ();
if (p == 0)
  ___RESULT = ___FAL;
else
  {
    p->val = ___UNB1;
    p->prm = ___FAL;
    p->next = 0;
    if (___ps->glo_list_head == 0)
      ___ps->glo_list_head = (___WORD)p;
    else
      ((___glo_struct*)___ps->glo_list_tail)->next = (___WORD)p;
    ___ps->glo_list_tail = (___WORD)p;
    ___VECTORSET(___ARG1,___FIX(2),(___WORD)p)
    ___RESULT = ___ARG1;
  }
}
else
  ___RESULT = ___ARG1;
" id))

(define (##object->global-var->identifier val)
  (##c-code
"
{
  ___WORD p = ___ps->glo_list_head;
  while (p != 0 && ((___glo_struct*)p)->val != ___ARG1)
    p = ((___glo_struct*)p)->next;
  ___RESULT = ___FAL;
  if (p != 0)
    {
      int i, len = ___INT(___VECTORLENGTH(___symbol_table));
      for (i=0; i<len; i++)
        {
          ___WORD probe = ___FIELD(___symbol_table,i);

          while (probe != ___NUL)
            {
              ___WORD obj = ___CAR(probe);
              if (___FIELD(obj,2) == p)
                {
                  ___RESULT = obj;
                  goto end_search;
                }
              probe = ___CDR(probe);
            }
        }
      end_search:;
    }
}
" val))

(define (##global-var->identifier gv)
  gv)

(define (##make-interned-symbol name)
  (##make-interned-symkey name #t))

(define (##make-interned-keyword name)
  (##make-interned-symkey name #f))

(define (##make-interned-symkey name symbol?)
  (let ((obj ((c-lambda (scheme-object bool) scheme-object "
{
  unsigned int subtype = ___arg2 ? ___sSYMBOL : ___sKEYWORD;
  ___WORD obj = ___find_symkey_from_schemestring (___arg1, subtype);
  if (obj == ___FAL)
    {
      unsigned long n = ___INT(___STRINGLENGTH(___arg1));
      obj = ___alloc_scmobj (___sSTRING, n<<___LCS, ___PERM);
      if (obj != ___FAL)
        {
          memcpy (___BODY_AS(obj,___tSUBTYPED),
                  ___BODY_AS(___arg1,___tSUBTYPED),
                  n<<___LCS);
          obj = ___new_symkey (obj, subtype);
        }
    }
  ___result = obj;
}
") name symbol?)))
    (or obj
        (begin
          (##exception.heap-overflow)
          (##make-interned-symkey name symbol?)))))

(define ##symbol-hash-counter 0)

(define (##make-uninterned-symbol name) ; name must be a non-mutable string
  (let ((i ##symbol-hash-counter))
    (set! ##symbol-hash-counter
      (if (##fixnum.= i (max-fixnum32)) 0 (##fixnum.+ i 1)))
    (##subtype-set! (##vector name i 0) (subtype-symbol))))

;------------------------------------------------------------------------------

; Miscellaneous

(define ##max-unicode
  (##c-code "___RESULT = ___FIX(___MAX_CHR);"))

(define ##symbol-table
  (c-lambda () scheme-object "___result = ___symbol_table;"))

(define ##keyword-table
  (c-lambda () scheme-object "___result = ___keyword_table;"))

(define ##argv
  (c-lambda () scheme-object "___result = ___arguments;"))

(define ##processed-argv '())
(set! ##processed-argv (##argv))

(define (##cpu-time)
  (let ((v
         (##vector (bignum-make (max-length-for-64bit))
                   (bignum-make (max-length-for-64bit)))))
    (##c-code "
{
  ___U64 user, sys;
  ___cpu_time (&user, &sys);
  ___U64_copy_to_scmobj (user, &___FIELD(___ARG1,0));
  ___U64_copy_to_scmobj (sys, &___FIELD(___ARG1,1));
  ___RESULT = ___ARG1;
}
" v)))

(define (##real-time)
  (##c-code "
{
  ___WORD result = ___ARG1;
  ___U64 rt;
  ___real_time (&rt);
  ___U64_copy_to_scmobj (rt, &result);
  ___RESULT = result;
}" (bignum-make (max-length-for-64bit))))

(define (##process-statistics)
  (let ((v
         (##vector (bignum-make (max-length-for-64bit))
                   (bignum-make (max-length-for-64bit))
                   (bignum-make (max-length-for-64bit))
                   (bignum-make (max-length-for-64bit))
                   (bignum-make (max-length-for-64bit))
                   (bignum-make (max-length-for-64bit))
                   (bignum-make (max-length-for-64bit))
                   0
                   0
                   0
                   0)))
    (##c-code "
{
  int n;
  ___U64 rt, user, sys;
  long minflt, majflt;
  ___W_ALL
  ___real_time (&rt);
  ___cpu_time (&user, &sys);
  ___vm_stats (&minflt, &majflt);
  ___U64_copy_to_scmobj (rt, &___FIELD(___ARG1,0));
  ___U64_copy_to_scmobj (user, &___FIELD(___ARG1,1));
  ___U64_copy_to_scmobj (sys, &___FIELD(___ARG1,2));
  ___U64_copy_to_scmobj (___GSTATE->gc_user_nsecs, &___FIELD(___ARG1,3));
  ___U64_copy_to_scmobj (___GSTATE->gc_sys_nsecs, &___FIELD(___ARG1,4));
  ___U64_copy_to_scmobj (___GSTATE->nb_gcs, &___FIELD(___ARG1,5));
  ___U64_copy_to_scmobj (___bytes_allocated (), &___FIELD(___ARG1,6));
  ___FIELD(___ARG1,7) = ___FIX((2*(1+2)<<___LWS));
  n = (1+___HD_WORDS(___BODY_AS(___ARG1,___tSUBTYPED)[-1])) +
      7*(1+___HD_WORDS(___BODY_AS(___FIELD(___ARG1,0),___tSUBTYPED)[-1]));
  ___FIELD(___ARG1,8) = ___FIX(((2*n)<<___LWS));
  ___FIELD(___ARG1,9) = ___FIX((minflt<<___LWS));
  ___FIELD(___ARG1,10) = ___FIX((majflt<<___LWS));
  ___R_ALL
  ___RESULT = ___ARG1;
}
" v)))

(define (##check-heap)
  (let ((x (##c-code "
if (___hp > ___ps->heap_limit)
  {
    int overflow;
    ___W_ALL
    overflow = ___heap_limit ();
    ___R_ALL
    if (overflow)
      ___RESULT = ___TRU;
    else
      ___RESULT = ___FAL;
  }
else
  ___RESULT = ___FAL;
")))
    (if x
      (begin
        (##exception.heap-overflow)
        (##check-heap)))))

(define (##rest-param-heap-overflow proc args)
  (##exception.heap-overflow)
  (##apply proc args))

(define (##force-undetermined ph thunk)
  (let ((val (##force (thunk))))
    (##c-code "
if (___UNTAG_AS(___ARG1,___tSUBTYPED)[2] == ___ARG1)
  ___UNTAG_AS(___ARG1,___tSUBTYPED)[2] = ___ARG2;
___RESULT = ___UNTAG_AS(___ARG1,___tSUBTYPED)[2];
" ph val)))

(define (##exit #!optional (status 0))
  (##c-code "___cleanup (); exit (___INT(___ARG1));" status))

(define (##sequentially thunk)
  (thunk))

(define ##os-event-get
  (c-lambda () scheme-object "___os_event_get"))

(define ##os-event-handler
  (c-lambda (scheme-object) scheme-object "___os_event_handler"))

(define ##getenv
  (c-lambda (char-string) char-string "___getenv"))

(define ##shell-command
  (c-lambda (char-string) int "___shell_command"))

(define (##path-expand path format)
  ((c-lambda (char-string int) char-string "
char path[___PATH_MAX_LENGTH+1];
if (___path_expand (___arg1, path, ___PATH_MAX_LENGTH, ___arg2))
  ___result = path;
else
  ___result = 0;
") path (case format ((relative) 1) ((shortest) -1) (else 0))))

(define ##path-absolute?
  (c-lambda (char-string) bool "___path_absolute"))

(define ##path-extension
  (c-lambda (char-string) char-string "
char path[___PATH_MAX_LENGTH+1];
if (___path_extension (___arg1, path, ___PATH_MAX_LENGTH))
  ___result = path;
else
  ___result = 0;
"))

(define ##path-strip-extension
  (c-lambda (char-string) char-string "
char path[___PATH_MAX_LENGTH+1];
if (___path_strip_extension (___arg1, path, ___PATH_MAX_LENGTH))
  ___result = path;
else
  ___result = 0;
"))

(define ##path-directory
  (c-lambda (char-string) char-string "
char path[___PATH_MAX_LENGTH+1];
if (___path_directory (___arg1, path, ___PATH_MAX_LENGTH))
  ___result = path;
else
  ___result = 0;
"))

(define ##path-strip-directory
  (c-lambda (char-string) char-string "
char path[___PATH_MAX_LENGTH+1];
if (___path_strip_directory (___arg1, path, ___PATH_MAX_LENGTH))
  ___result = path;
else
  ___result = 0;
"))

(define ##path-drive
  (c-lambda (char-string) char-string "
char path[___PATH_MAX_LENGTH+1];
if (___path_drive (___arg1, path, ___PATH_MAX_LENGTH))
  ___result = path;
else
  ___result = 0;
"))

(define ##path-strip-drive
  (c-lambda (char-string) char-string "
char path[___PATH_MAX_LENGTH+1];
if (___path_strip_drive (___arg1, path, ___PATH_MAX_LENGTH))
  ___result = path;
else
  ___result = 0;
"))

(define (##load-object-file name)
  (let ((vect ((c-lambda (char-string) scheme-object "
{
  char *errmsg;
#if 0
  if (___gc ()) /* to prevent gc while loading */
    ___result = ___FAL;
  else
#endif
    {
      ___WORD result = ___load_object_file (___arg1, &errmsg);
      if (result == ___FAL)
        {
          ___err = ___charstring_to_scmobj (errmsg, &result, 0);
          ___release_scmobj (result);
        }
      ___result = result;
    }
}
") name)))
    (cond ((##vector? vect)
           (lambda ()
             (let ((len (##vector-length vect)))
               (let loop ((i 0))
                 (if (##fixnum.< i len)
                   (if (##fixnum.= i (##fixnum.- len 1))
                     ((##vector-ref vect i))
                     (begin
                       ((##vector-ref vect i))
                       (loop (##fixnum.+ i 1)))))))))
          ((##string? vect)
           vect)
          (else
           (##exception.heap-overflow)
           (##load-object-file name)))))

(define ##cc-cmd
  ((c-lambda () char-string "___result = ___CC_CMD;")))

(define ##ld-cmd
  ((c-lambda () char-string "___result = ___LD_CMD;")))

(define ##ld-flip
  ((c-lambda () bool "
#ifdef ___LD_FLIP
  ___result = 1;
#else
  ___result = 0;
#endif
")))

(define ##dynamic-cc #f)

(if ##cc-cmd
  (set! ##dynamic-cc
    (lambda (root-path output-path)
      ((c-lambda (char-string char-string char-string char-string bool)
                 char-string
"
char *errmsg;
if (___dynamic_cc (___arg1, ___arg2, ___arg3, ___arg4, ___arg5, &errmsg))
  ___result = errmsg;
else
  ___result = 0;
") ##cc-cmd ##ld-cmd root-path output-path ##ld-flip))))

(define ##format-filepos
  (c-lambda (char-string long bool) char-string "___format_filepos"))

(##declare (separate))

(define (##comply-to-standard-scheme?)
  (##c-code "___RESULT = ___BOOLEAN(___comply_to_standard_scheme);"))

(define ##gc-report #f)

(define (##gc)
  (let ((result (##c-code "
{
  int overflow;
  ___W_ALL
  overflow = ___gc ();
  ___R_ALL
  ___RESULT = ___BOOLEAN(overflow);
}
")))
    (if result
      (begin
        (##exception.heap-overflow)
        (##gc))
      (##void))))

(define (##gc-finalization)
  (##declare (not interrupts-enabled))
  (let ((action (##c-code "
{
  ___WORD will = ___ps->executable_wills;
  if (___UNTAG(will) == 0) /* end of list? */
    ___RESULT = ___FAL;
  else
    {
      ___ps->executable_wills = ___BODY(will)[0];
      ___RESULT = ___BODY(will)[2];
      ___BODY(will)[2] = ___FAL; /* zap action procedure */
    }
}")))
    (if action
      (begin
        (action)
        (##gc-finalization)))))

; execute each module in sequence

(define ##module-sequencer
  (let ()
    (##declare (not inline))
    (lambda ()
      (let loop ((i 1))
        (let ((ev (##c-code "___RESULT = ___exec_vector;")))
          (let ((len (##vector-length ev)))
            (cond ((##fixnum.= i (##fixnum.- len 1))
                   ((##vector-ref ev i)))
                  ((##fixnum.< i len)
                   ((##vector-ref ev i))
                    (loop (##fixnum.+ i 1))))))))))

(##module-sequencer)
