/* File: "client.c" */

#include <stdio.h>
#include <stdlib.h>

/* 
 * ___VERSION must match the version number of the Gambit header file.
 */

#define ___VERSION 21
#include "gambit.h"

/*
 * Include declarations exported by server.
 */

#include "server.h"

/* 
 * Define SCHEME_LIBRARY_LINKER as the name of the Scheme library
 * prefixed with "____20_" and suffixed with "__".  This is the
 * function that initializes the Scheme library.
 */

#define SCHEME_LIBRARY_LINKER ____20_server__

extern ___mod_or_lnk SCHEME_LIBRARY_LINKER ();

int main (argc, argv)
int argc;
char **argv;
{
  char *temp;

  /* 
   * Setup the Scheme library by calling "___setup" with appropriate
   * parameters.  The parameters set to zero will use the system
   * default.
   */

  ___setup_params_struct setup_params;

  setup_params.argc                = argc;
  setup_params.argv                = argv;
  setup_params.stack_cache         = 0;
  setup_params.min_heap            = 0;
  setup_params.max_heap            = 0;
  setup_params.live_percent        = 0;
  setup_params.gc_hook             = 0;
  setup_params.fatal_error         = 0;
  setup_params.standard            = 0;
  setup_params.debug_level         = 0;
  setup_params.default_io_encoding = ___IO_CHAR_ENCODING; /* native encoding */
  setup_params.force_tty           = 0;
  setup_params.force_unbuffered_io = 0;
  setup_params.linker              = SCHEME_LIBRARY_LINKER;

  ___setup (&setup_params);

  /* Main part of program: call Scheme functions */

  temp = eval_string ("(define x 200)");
  if (temp != 0)
    {
      printf ("result = %s\n", temp);
      ___free_string (temp); /* don't forget to reclaim string */
    }

  temp = eval_string ("(expt 2 x)");
  if (temp != 0)
    {
      printf ("result = %s\n", temp);
      ___free_string (temp);
    }

  temp = eval_string ("(+ 1 2"); /* note: missing closing parenthesis */
  if (temp != 0)
    {
      printf ("result = %s\n", temp);
      ___free_string (temp);
    }

  temp = eval_string ("(+ x y)"); /* note: y is unbound */
  if (temp != 0)
    {
      printf ("result = %s\n", temp);
      ___free_string (temp);
    }

  /* Cleanup the Scheme library (required before terminating) */

  ___cleanup ();

  /* Terminate program */

  exit (0);
}
