package biss.jde;

import biss.Queue;
import biss.awt.LineBuffer;
import biss.awt.PaneDrawer;
import biss.awt.TextArea;
import java.awt.Color;
import java.util.Observable;
import java.util.Observer;

/**
 * asynchronous (Text)pane drawer used to syntax colorize Java sources
 * (not capable of handling multi line comment yet)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
class JavaColorizer
  implements Observer
{
	TextArea Pane;
	Queue FormatQueue = new Queue( 40);
	JavaScanner Scan = new JavaScanner( null);
	byte[] Buf = new byte[256];
	boolean IsEnabled = true;
	PaneDrawer Drawer;

JavaColorizer ( TextArea p ) {
	Pane = p;

	Drawer = new PaneDrawer( Pane, FormatQueue);
	Pane.OsDrawPane.addObserver( this);
	Pane.OsFormatLine.addObserver( this);
}

void colorizeLines () {
	LineBuffer lb, lbLast = null;

	while ( !FormatQueue.empty() ) {
		int i, tok;
		lb = (LineBuffer) FormatQueue.getNext();

		if ( lb == lbLast || !IsEnabled ) continue;

		int n = Math.min( lb.Len, Buf.length);
		for ( i=0; i<n; i++ ) Buf[i] = (byte)lb.Text[i];
		Buf[n] = Scan.EOT;  // to mark end of scan buffer data

		lbLast = lb;
		Scan.reset( Buf);

		while ( (tok = Scan.nextToken()) != 0 ) {
			if ( Scan.isKeyword(tok) )
				Pane.colorizeLine( lb, Scan.I0, Scan.I, Jde.KeywordClr);
			else if ( tok == Scan.SCONST || tok == Scan.CCONST )
				Pane.colorizeLine( lb, Scan.I0, Scan.I, Jde.LiteralClr);
		}

		if ( Scan.CEnd > Scan.CStart ){
			Pane.colorizeLine( lb, Scan.CStart, Scan.CEnd, Jde.CommentClr);
		}
	}
}

public void enable ( boolean setEnabled ) {
	IsEnabled = setEnabled;
}

public void stop () {
	Drawer.stopIt();
}

public void update ( Observable obs, Object arg ) {
	if ( obs == Pane.OsDrawPane ) {
		colorizeLines();
	}
	else if ( obs == Pane.OsFormatLine ) {
		if ( IsEnabled ) {
			LineBuffer lb = (LineBuffer) arg;
			if ( lb.Len > 0 )
				FormatQueue.appendNotifyUnique( lb);
		}
	}
}
}
