package biss.awt;

import biss.ObserverSocket;
import java.awt.Graphics;
import java.awt.Rectangle;

/**
 * class to implement page oriented PS printing of pane contents
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class PanePrinter
{
	ScrollableCanvas Pane;
	public Rectangle FooterRect;
	public Rectangle HeaderRect;
	public int CurrentPage;
	public int ItemsPerPage;
	public ObserverSocket OsDrawHeader = new ObserverSocket( this);
	public ObserverSocket OsDrawFooter = new ObserverSocket( this);
	public int TotalPages;
	public PostGraphics PostGr;

public PanePrinter ( ScrollablePane sp, int mmHeaderHeight, int mmFooterHeight) {
	Pane = sp.BaseCv;

	int rh = (int)( 2.835 * mmHeaderHeight / PostGraphics.ScaleY);
	HeaderRect = new Rectangle( 0, 0, PostGraphics.MaxWidth, rh );

	rh = (int)( 2.835 * mmFooterHeight / PostGraphics.ScaleY);
	FooterRect = new Rectangle( 0, PostGraphics.MaxHeight - rh, 
	                            PostGraphics.MaxWidth, rh );

	ItemsPerPage = (PostGraphics.MaxHeight - HeaderRect.height
	                - FooterRect.height ) / Pane.LineHeight;
	TotalPages = Pane.Lines.size() / ItemsPerPage + 1;

}

public boolean printTo ( String pathName) {

	int h   = Pane.Height;
	int w   = Pane.Width;
	int idx = Pane.IdxTop;
	int isz = Pane.Lines.size();

	CurrentPage = 1;

	Graphics      sgr  = Pane.ResGraph;
	ListCanvas    opc  = null;
	Object        ssel = null;
	PostGraphics  psgr = null;

	try {
		PostGr = new PostGraphics( pathName, sgr);
	}
	catch( Exception e) {
		e.printStackTrace();
		return false;
	}

	Pane.ResGraph = PostGr;
	Pane.Height   = isz * Pane.LineHeight;
	Pane.Width    = PostGraphics.MaxWidth;
	Pane.IdxTop   = 0;

	if ( Pane instanceof ListCanvas){
		opc = (ListCanvas) Pane;
		ssel = opc.Selection;
		opc.Selection = null;
	}

	OsDrawHeader.notifyObservers();
	PostGr.translate( 0, -(HeaderRect.height+1));

	for ( int i=0; i<isz; i++){
		if ( (i > 0) && ((i % ItemsPerPage) == 0)) {
			PostGr.translate( 0, HeaderRect.height+1);
			OsDrawFooter.notifyObservers();
			PostGr.newPage();
			CurrentPage ++;
			Pane.IdxTop = i;
			OsDrawHeader.notifyObservers();
			PostGr.translate( 0, -(HeaderRect.height+1));
		}
		Pane.redrawLine( i);
	}

	PostGr.translate( 0, HeaderRect.height+1);
	OsDrawFooter.notifyObservers();
	PostGr.endDoc();

	PostGr.dispose();

	if ( (opc != null) && (ssel != null) )
		opc.Selection = ssel;

	Pane.Height = h;
	Pane.Width  = w;
	Pane.IdxTop = idx;
	Pane.ResGraph = sgr;

	return true;
}
}
