package biss.awt;

import biss.awt.Button;
import biss.awt.DecoText;
import biss.awt.Layouter;
import biss.awt.TextField;
import biss.awt.TopWindow;
import java.awt.Rectangle;

/**
 * physical view of the standard biss.awt.TextArea replace dialog
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class TextReplaceViewer
  extends DialogWindow
{
	Layouter Lo = new Layouter( this);
	Button CRep = new Button("~Replace");
	Button CExit = new Button("~Exit");
	TextField CRepTxt = new TextField();
	TextField CFindTxt = new TextField();
	Button CFind = new Button("~Find");
	DecoText TFind = new DecoText("Find");
	DecoText TRep = new DecoText("Replace");

public TextReplaceViewer( TopWindow owner) {
	super( "Find/Replace", owner);
	open();
}

public void init() {
	Bounds = centeredBoundsFromDlgExtent( 1406, 806);
	DefComponent = CFindTxt;
}

public static void main( String[] args) {
	new TextReplaceViewer( null);
}

public void open() {
	Lo.add( CFindTxt, 0, 0, 1000, 0, true, 380, 20, -20, 200, 0);
	Lo.add( CRepTxt, 0, 0, 1000, 0, true, 380, 220, -20, 400, 0);
	Lo.add( CFind, 0, 0, 0, 0, true, 20, 420, 440, 600, 0);
	Lo.add( CRep, 0, 0, 1000, 0, true, 460, 420, -460, 600, 0);
	Lo.add( CExit, 1000, 0, 1000, 0, true, -440, 420, -20, 600, 0);
	Lo.add( TFind, 0, 0, 0, 0, true, 20, 20, 380, 200, 0);
	Lo.add( TRep, 0, 0, 0, 0, true, 20, 220, 380, 400, 0);

	init();
	if ( Bounds != null)
		openIn( Bounds);
	else
		openInDlgUnits( 0, 0, 1406, 806);
}
}
