package biss.awt;

import java.awt.Color;
import java.awt.Graphics;

/**
 * auxiliary class to implement a configurable TextArea cursor
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class TextCursor
{
	int Height;
	int Width;
	int XIdx = 0;
	int XPos = 0;
	int YIdx = 0;
	int YPos = 0;
	Color ClrFore;
	Color ClrBack;

public TextCursor ( Color cb) {
	this( 0, Awt.CursorWidth, Awt.CursorClr, cb);
}

public TextCursor ( int h, int w, Color cf, Color cb) {
	Height  = h;
	Width   = w;
	ClrFore = cf;
	ClrBack = cb;
	XPos    = 0;
	YPos    = 0;
}

public void addX( int x) {
	XPos+=x;
}

public void clearAtOffs ( Graphics g, int xOffs, int yOffs ) {
	int x = XPos + xOffs;
	int y = YPos + yOffs - 1;

	g.setColor( ClrBack);

	for ( int i=0; i<Width; i++, x++)
		g.drawLine( x, y, x, y - Height);

}

public void drawAtOffs( Graphics g, int xOffs, int yOffs) {
	int x = XPos + xOffs;
	int y = YPos + yOffs - 1;

	g.setColor( ClrFore);

	for ( int i=0; i<Width; i++, x++) {
		g.drawLine( x, y, x, y - Height);
	}
}

public void setBackground( Color c) {
	ClrBack = c;
}

public void setForeground( Color c) {
	ClrFore = c;
}

public void setHeight( int h) {
	Height = h;
}

public void setWidth( int w) {
	Width = w;
}

public void setXPos( int x) {
	XPos = x;
}

public void setYPos( int y) {
	YPos = y;
}

public void subX( int x) {
	XPos-=x;
}
}
