package biss.awt;

import java.awt.Event;

/**
 * class to implement function keys (both topwindow global and widget local)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class HotKey
{
	final public static int Alt = Event.META_MASK;
	final public static int Control = Event.CTRL_MASK;
	final public static int Lone = 0;
	final public static int Shift = Event.SHIFT_MASK;
	int Key;
	Integer HashCode;
	int Mods;
	Object Selector = null;
	HotKeyProcessor Proc = null;

public HotKey ( int key, int mods, HotKeyProcessor p, Object sel) {  
	Key = key;
	Mods = mods;
	HashCode = new Integer( key + mods * 256);
	Selector = sel;
	Proc = p;
}

public HotKeyProcessor getProcessor(){
	return Proc;
}

public Object getSelector() {
	return Selector;
}

public int key() {
	return Key;
}

public int mods() {
	return Mods;
}

public boolean process(){
	if ( Proc == null)
		return false;
	Proc.processKey( Selector);
	return true;
}

public void setProcessor( HotKeyProcessor p){
	Proc = p;
}
}
