package biss.awt;

import java.awt.Color;
import java.awt.Decoration;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

/**
 * static decoration text
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class DecoText
  extends DecoBox
{
	String Text = "";
	FontMetrics Fm = Awt.DefToolkit.getFontMetrics( Awt.StaticFont);
	boolean Carved;
	final public static int DTA_LEFT = 1;
	final public static int DTA_CENTER = 2;
	final public static int DTA_RIGHT = 3;
	int TAlign = DTA_LEFT;
	Font TFont = Awt.StaticFont;
	public static boolean DefaultCarved = true;
	static FontMetrics DefFm;

static {
	DefFm = Awt.getFontMetrics( Awt.StaticFont);
}

public DecoText () {
	super( Border.BS_NONE);
	setForeground( Awt.StaticForeClr);
	setCarved( DefaultCarved);
	setFont( null);
}

public DecoText (String text) {
	this();
	Text = text;
}

public DecoText (String text, int align) {
	this( text);
	TAlign = align;
}

public void blank (Graphics g, Color cb) {
	g.setColor( cb);
	g.fillRect( X, Y, Width+1, Height+1);
}

public String getContents () {
	return Text;
}

public void paint (Graphics g) {
	int x0=X;
	int y0=Y+Height-(Height-Fm.getHeight())/2-Fm.getDescent();

	if ( ! isShowing() )
		return;

	switch ( TAlign) {
	case DTA_CENTER:
		x0+=(Width-Fm.stringWidth( Text))/2;
		break;
	case DTA_RIGHT:
		x0+=Width-Fm.stringWidth( Text);
		break;
	}

	g.setFont( TFont);
	//  g.clipRect( X, Y, Width, Height);

	if ( Carved) {
		g.setColor( Color.white);
		g.drawString( Text, x0+1, y0+1);
	}
	g.setColor( getForeground() );
	g.drawString( Text, x0, y0);
	drawBorder( g);
}

public void setAlign (int align ) {
	switch( align) {
	case DTA_CENTER:
		TAlign = align;
		break;
	case DTA_RIGHT:
		TAlign = align;
		break;
	default:
		TAlign = DTA_RIGHT;
		break;
	}

	updateContents();

}

public void setCarved (boolean c ) {
	Carved = c;
	updateContents();
}

public void setContents (String text) {
	Text = text;
	updateContents();
}

public static void setDefaultCarved (boolean c) {
	DefaultCarved = c;
}

public void setFont (Font fnt) {
	Font uf = fnt != null ? fnt : Awt.StaticFont;
	TFont = uf;

	if ( uf.equals( Awt.StaticFont))
		Fm = DefFm;
	else
		Fm=Awt.getFontMetrics( TFont);

	updateContents();
}

void updateContents () {
	if ( isShowing() ){
		Graphics g = getGraphics();
		if ( g != null ) {
			blank( g, getParent().getBackground());
			paint( g);
			g.dispose();
		}
	}
}
}
