package biss.awt;

import java.awt.Color;
import java.awt.Decoration;
import java.awt.Graphics;

/**
 * static decoration line
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class DecoLine
  extends Decoration
{
	int Direction = DLD_HORZ;
	int LineWidth = 1;
	final public static int DLD_HORZ = 1;
	final public static int DLD_VERT = 2;

public DecoLine () {
	setForeground( Awt.StaticForeClr);
}

public DecoLine (int w) {
	this();
	LineWidth = w;
}

public void blank( Graphics g, Color cb) {
	drawLine( g, getParent().getBackground() );
}

public void drawLine( Graphics g, Color c) {
	int x0, y0;

	g.setColor( c);

	switch( Direction) {
	case DLD_HORZ:
		y0 = Y+Height-(Height-LineWidth)/2;
		for ( int i=0; i<LineWidth; i++)
			g.drawLine( X, y0-i, X+Width, y0-i);
		break;
	case DLD_VERT:
		x0 = X+Width-(Width-LineWidth)/2;
		for ( int i=0; i<LineWidth; i++)
			g.drawLine( x0-i, Y, x0-i, Y+Height);
	}
}

public void paint( Graphics g) {
	if ( isShowing() )
		drawLine( g, getForeground() );
}

public void setDirection( int dir) {
	if ( dir == DLD_VERT)
		Direction = DLD_VERT;
	else
		Direction = DLD_HORZ;
	updateContents();
}

public void setLineWidth( int w) {
	LineWidth = w;
	updateContents();
}

public void updateContents() {
	if ( isShowing() ) {
		Graphics g = getGraphics();
		blank( g, getParent().getBackground() );
		paint( g);
		g.dispose();
	}
}
}
