;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.9/Ieee/vector.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jul  6 14:18:49 1992                          */
;*    Last change :  Fri Aug 16 08:17:28 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.8. Vectors (page 26, r4)                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_vectors_6_8

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")

	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro bool c-vector?           (obj)            "VECTORP")
	    (vector     c-make-vector       (long obj)       "make_vector")
	    (vector     c-create-vector     (long)           "create_vector")
	    (macro vector c-make-s-vector   (long obj)       "MAKE_S_VECTOR")
	    (macro vector c-create-s-vector (long)           "CREATE_S_VECTOR")
	    (obj        c-vector-fill!     (vector long obj) "fill_vector")
	    (macro long c-vector-length    (vector)          "VECTOR_LENGTH")
	    (macro obj  c-vector-ref       (vector long)     "VECTOR_REF")
	    (macro obj  c-vector-set!      (vector long obj) "VECTOR_SET")
	    (macro bool vector-bound-check? (long long)      "BOUND_CHECK")
	    (macro obj  c-vector-tag-set!  (vector long)     "VECTOR_TAG_SET")
	    (macro long c-vector-tag       (vector)          "VECTOR_TAG"))
   
   (export  (inline vector?::bool          obj)
	    (inline make-vector::vector    ::long . obj)
	    (inline vector::vector         . args)
	    (inline vector-length::long    ::vector)
	    (inline vector-ref             ::vector ::long)
	    (inline vector-set!            ::vector ::long obj) 
	    (inline vector-ref-ur          ::vector ::long) 
	    (inline vector-set-ur!         ::vector ::long obj)
	    (vector->list::obj             ::vector)
	    (list->vector::vector          ::obj)
	    (vector-fill!                  ::vector fill)
	    (inline vector-tag::long       ::vector)
	    (inline vector-tag-set!        ::vector ::long))

   (pragma  (c-make-vector   (stack-alloc c-make-s-vector) no-cfa-top)
	    (c-create-vector (stack-alloc c-create-s-vector) no-cfa-top)
	    (c-vector?       (predicate-of vector) no-cfa-top)
	    (vector?         (predicate-of vector))
	    (c-vector-length side-effect-free no-cfa-top)
	    (vector-length   side-effect-free)
	    (c-vector-ref    side-effect-free no-cfa-top)
	    (vector-ref      side-effect-free)
	    (vector-ref-ur   side-effect-free)
	    (vector-tag      side-effect-free no-cfa-top)))

;*---------------------------------------------------------------------*/
;*    vector? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (vector? obj)
   (c-vector? obj))

;*---------------------------------------------------------------------*/
;*    make-vector ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (make-vector int . fill)
   (if (null? fill)
       (c-make-vector int #unspecified)
       (c-make-vector int (car fill))))

;*---------------------------------------------------------------------*/
;*    vector . args ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (vector . args)
   (list->vector args))

;*---------------------------------------------------------------------*/
;*    vector-length ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (vector-length vector)
   (c-vector-length vector))

;*---------------------------------------------------------------------*/
;*    vector-ref ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (vector-ref vector k)
   (if (vector-bound-check? k (vector-length vector))
       (c-vector-ref vector k)
       (error "vector-ref" "index out of range" k)))

;*---------------------------------------------------------------------*/
;*    vector-set! ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (vector-set! vector k obj)
   (if (vector-bound-check? k (vector-length vector))
       (c-vector-set! vector k obj)
       (error "vector-set!" "index out of range" k)))

;*---------------------------------------------------------------------*/
;*    vector-ref-ur ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (vector-ref-ur vector k)
   (c-vector-ref vector k))

;*---------------------------------------------------------------------*/
;*    vector-set-ur! ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (vector-set-ur! vector k obj)
   (c-vector-set! vector k obj))

;*---------------------------------------------------------------------*/
;*    vector->list ...                                                 */
;*---------------------------------------------------------------------*/
(define (vector->list vector)
   (let ((vlen (vector-length vector)))
      (if (=fx vlen 0)
	  '()
	  (let loop ((i   (-fx vlen 1))
		     (acc '()))
	     (if (=fx i 0)
		 (cons (vector-ref-ur vector i) acc)
		 (loop (-fx i 1) (cons (vector-ref-ur vector i) acc)))))))

;*---------------------------------------------------------------------*/
;*    list->vector ...                                                 */
;*---------------------------------------------------------------------*/
(define (list->vector list)
   (let* ((len (length list))
	  (vec (make-vector len '())))
      (let loop ((i 0)
		 (l list))
	 (if (=fx i len)
	     vec
	     (begin
		(vector-set-ur! vec i (car l))
		(loop (+fx i 1) (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    vector-fill! ...                                                 */
;*---------------------------------------------------------------------*/
(define (vector-fill! vector fill)
   (c-vector-fill! vector (vector-length vector) fill))

;*---------------------------------------------------------------------*/
;*    vector-tag ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (vector-tag vector)
   (c-vector-tag vector))

;*---------------------------------------------------------------------*/
;*    vector-tag-set! ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (vector-tag-set! vector tag)
   (c-vector-tag-set! vector tag))
