;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/cse.scm                      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr 29 17:25:53 1993                          */
;*    Last change :  Mon Aug 18 16:17:21 1997 (serrano)                */
;*                                                                     */
;*    On test l'elimination de sous expression commune.                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cse
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-cse)))

;*---------------------------------------------------------------------*/
;*    foo ...                                                          */
;*---------------------------------------------------------------------*/
(define (foo x)
   (let ((y (car x)))
      (set-car! x 3)
      (let ((z (car x)))
	 z)))

;*---------------------------------------------------------------------*/
;*    bar ...                                                          */
;*---------------------------------------------------------------------*/
(define (bar x)
   (let ((y (car x)))
      (foo x)
      (let ((z (car x)))
	 z)))

;*---------------------------------------------------------------------*/
;*    gee ...                                                          */
;*---------------------------------------------------------------------*/
(define (gee l::pair)
   ;; this function was badly compiled due to a bug in the cse
   ;; that propagate the binding (a (c-car l)) into the loop.
   (let ((a (c-car l)))
      (let loop ((a a))
	 (if (c-pair? a)
	     (begin
		(c-set-car! l '(3))
		(loop (c-cdr a)))
	     (let ((a (c-car l)))
		(c-set-cdr! a 4)
		a))))) 

;*---------------------------------------------------------------------*/
;*    test-cse ...                                                     */
;*---------------------------------------------------------------------*/
(define (test-cse)
   (test-module "cse" "cse.scm" #f)
   (test "cse" (foo '(1 2)) 3)
   (test "cse" (bar '(1 2)) 3)
   (test "cse" (gee '((1))) '(3 . 4)))

