;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Type/type.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu May 30 16:38:54 1996                          */
;*    Last change :  Wed Sep 25 17:27:38 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The type class definition                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module type_type

   (import tools_location)
   
   (export (final-class type::object
	      ;; the type identifier
	      (id::symbol read-only (default '_))
	      ;; the target type name
	      (name (default #unspecified))
	      ;; the expression used by sizeof
	      (size (default #unspecified))
	      ;; the kind of type
	      (class (default 'bigloo)
		 [assert (class) (memq class '(_ bigloo C))])
	      ;; the coercion-to list
	      (coerce-to::obj (default '()))
	      ;; its parents
	      (parents::obj (default '()))
	      ;; initialized ? (a type can be only declared (use-type))
	      init?::bool
	      ;; is this type can be converted into every thing ?
	      (magic?::bool (default #f))
	      ;; is the type name containing a `$' ?
	      ($ (default #t))
	      ;; a type than self is aliasing
	      (alias (default #f))
	      ;; a type that points to self
	      (pointed-to-by (default #f))
	      ;; a tvector associated to this type
	      ;; (only used by the cfa but much easier to make it general)
	      (tvector (default #unspecified)))

	   (get-aliased-type::type ::type)))

;*---------------------------------------------------------------------*/
;*    get-aliased-type ...                                             */
;*---------------------------------------------------------------------*/
(define (get-aliased-type type)
   (let loop ((type type))
      (if (type? (type-alias type))
	  (loop (type-alias type))
	  type)))
			  

   

