;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Tools/trace.sch          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 31 08:56:22 1993                          */
;*    Last change :  Mon Jul  8 10:49:42 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The tracing macro.                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Les imports indispensables pour pouvoir tracer                   */
;*---------------------------------------------------------------------*/
(directives
   (import tools_trace))

;*---------------------------------------------------------------------*/
;*    trace ...                                                        */
;*---------------------------------------------------------------------*/
(define-macro (trace mask . forms)
   (let ((*debug-mode* #t))
      (let ((*pass-names* '(ast heap inline cfa cc effect expand
			    globalize integrate coerce cnst cgen reduce
			    recovery)))
	 (if *debug-mode*
	     (match-case mask
		((? symbol?)
		 (if (eq? mask 'get-pass-names)
		     `',*pass-names*
		     (if (memq mask *pass-names*)
			 `(if (trace-satisfy? ',mask 0)
			      (print-trace ,@forms))
			 (error #f "Illegal `trace' expression" mask))))
		(((and ?pass (? symbol?)) (and ?level (? integer?)))
		 (if (memq pass *pass-names*)
		     `(if (trace-satisfy? ',pass ,level)
			  (print-trace ,@forms))
		     (error #f "Illegal `trace' expression" mask)))
		(else
		 (error #f "Illegal `trace' expression" mask)))))))
