;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Reduce/1occ.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 13 10:29:17 1995                          */
;*    Last change :  Wed Mar  4 11:26:24 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The removal of the local variables appearing just once.          */
;*    The only goal of this pass is to prune the ast.                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module reduce_1occ
   (include "Tools/trace.sch")
   (import  tools_shape
	    tools_speek
	    tools_error
	    type_type
	    type_cache
	    coerce_typeof
	    coerce_coerce
	    effect_effect
	    ast_var
	    ast_node
	    ast_lvtype
	    ast_occur)
   (export  (reduce-1occ! globals)))

;*---------------------------------------------------------------------*/
;*    reduce-1occ! ...                                                 */
;*---------------------------------------------------------------------*/
(define (reduce-1occ! globals)
   (verbose 2 #"      single occurrence      ")
   ;; we have to recompute the occurrences because both `copy-propagation
   ;; and `cse' have changed the number of occurrence (in two directions).
   (occur-var globals)
   ;; then we start the 1-occurrence reduction. 
   (set! *variable-removed* 0)
   (for-each (lambda (global)
		(let* ((fun  (global-value global))
		       (node (sfun-body fun))) 
		   (sfun-body-set! fun (multiple-value-bind (_ node)
					  (node-1occ! node '())
					  node))
		   #unspecified))
	     globals)
   (verbose 2 "(removed : " *variable-removed* #\) #\newline)
   globals)


;*---------------------------------------------------------------------*/
;*    Statitics ...                                                    */
;*---------------------------------------------------------------------*/
(define *variable-removed* 0)

;*---------------------------------------------------------------------*/
;*    node-1occ! ...                                                   */
;*    -------------------------------------------------------------    */
;*    1-exp* is a list of expressions bound to a 1 occurrence read     */
;*    variable. This list is reset when a call to a function           */
;*    performing a side effect is encountered.                         */
;*---------------------------------------------------------------------*/
(define-generic (node-1occ! node::node 1-exp*))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::atom ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::atom 1-exp*)
   (values #f node))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::kwote ...                                           */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::kwote 1-exp*)
   (values #f node))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::var ...                                             */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::var 1-exp*)
   (let ((v (var-variable node)))
      (let ((falpha (assq v 1-exp*)))
	 (if (pair? falpha)
	     (begin
		(variable-occurrence-set! v (-fx (variable-occurrence v) 1))
		(set! *variable-removed* (+fx *variable-removed* 1))
		(node-1occ! (cdr falpha) 1-exp*))
	     (values #f node)))))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::closure ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::closure 1-exp*)
   (values #f node))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::sequence ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::sequence 1-exp*)
   (with-access::sequence node (nodes)
      (values (node-1occ*! nodes 1-exp*) node)))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::app-ly ...                                          */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::app-ly 1-exp*)
   (with-access::app-ly node (fun arg)
      (multiple-value-bind (reset nfun)
	 (node-1occ! fun 1-exp*)
	 (set! fun nfun)
	 (multiple-value-bind (reset' narg)
	    (node-1occ! arg (if reset '() 1-exp*))
	    (set! arg narg)
	    (values (or reset reset') node)))))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::funcall ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::funcall 1-exp*)
   (with-access::funcall node (args)
      (let ((reset' (node-1occ*! args 1-exp*)))
	 (values reset' node))))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::pragma ...                                          */
;*    -------------------------------------------------------------    */
;*    We don't remove single occurrences for pragma constructions      */
;*    because it may introduce typing pbm.                             */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::pragma 1-exp*)
   (with-access::pragma node (args)
      (values (side-effect? node) node)))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::cast ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::cast 1-exp*)
   (with-access::cast node (arg)
      (multiple-value-bind (reset narg)
	 (node-1occ! arg 1-exp*)
	 (set! arg narg)
	 (values reset node))))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::setq ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::setq 1-exp*)
   (with-access::setq node (var value)
      (multiple-value-bind (reset nvalue)
	 (node-1occ! value 1-exp*)
	 (set! value nvalue)
	 (values reset node))))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::conditional ...                                     */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::conditional 1-exp*)
   (with-access::conditional node (test true false)
      (multiple-value-bind (reset ntest)
	 (node-1occ! test 1-exp*)
	 (set! test ntest)
	 (let ((1-exp*' (if reset '() 1-exp*)))
	    (multiple-value-bind (reset' ntrue)
	       (node-1occ! true 1-exp*')
	       (set! true ntrue)
	       (multiple-value-bind (reset'' nfalse)
		  (node-1occ! false 1-exp*')
		  (set! false nfalse)
		  (values (or reset reset' reset'') node)))))))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::fail ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::fail 1-exp*)
   (with-access::fail node (proc msg obj)
      (multiple-value-bind (reset nproc)
	 (node-1occ! proc 1-exp*)
	 (set! proc nproc)
	 (let ((1-exp*' (if reset '() 1-exp*)))
	    (multiple-value-bind (reset' nmsg)
	       (node-1occ! msg 1-exp*')
	       (set! msg nmsg)
	       (let ((1-exp*'' (if reset' '() 1-exp*')))
		  (multiple-value-bind (reset'' nobj)
		     (node-1occ! obj 1-exp*'')
		     (set! obj nobj)
		     (values (or reset reset' reset'') node))))))))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::select ...                                          */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::select 1-exp*)
   (with-access::select node (clauses test)
      (multiple-value-bind (reset ntest)
	 (node-1occ! test 1-exp*)
	 (set! test ntest)
	 (let ((1-exp*' (if reset '() 1-exp*)))
	    (let loop ((clauses clauses)
		       (reset   reset))
	       (if (null? clauses)
		   (values reset node)
		   (let ((clause (car clauses)))
		      (multiple-value-bind (reset' nclause)
			 (node-1occ! (cdr clause) 1-exp*)
			 (set-cdr! clause nclause)
			 (loop (cdr clauses) (or reset reset'))))))))))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::let-fun ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::let-fun 1-exp*)
   (with-access::let-fun node (body locals)
      (multiple-value-bind (reset nbody)
	 (node-1occ! body 1-exp*)
	 (set! body nbody)
	 (let loop ((locals locals)
		    (reset  reset))
	    (if (null? locals)
		(values reset node)
		(let* ((local (car locals))
		       (sfun  (local-value local)))
		   (multiple-value-bind (reset' nbody)
		      (node-1occ! (sfun-body sfun) '())
		      (sfun-body-set! sfun nbody)
		      (loop (cdr locals) (or reset reset')))))))))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::let-var ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::let-var 1-exp*)
   (with-access::let-var node (body bindings loc type removable?)
      (let loop ((obindings bindings)
		 (reset     #f)
		 (extend    '()))
	 (if (null? obindings)
	     (if reset
		 (multiple-value-bind (reset' nbody)
		    (node-1occ! body '())
		    (set! body nbody)
		    (values #t node))
		 (let ((1-exp*' (append extend 1-exp*)))
		    (multiple-value-bind (reset' nbody)
		       (node-1occ! body 1-exp*')
		       (set! body nbody)
		       ;; we computed the new body, we now have to remove
		       ;; bindings which have been inlined
		       (let loop ((obindings bindings)
				  (nbindings '()))
			  (cond
			     ((null? obindings)
			      (if (and removable? (null? nbindings))
				  (begin
				     (trace (reduce 3)
					    "***1occ: removing bindings: "
					    (shape body)
					    #\Newline)
				     (values reset' body))
				  (begin
				     (set! bindings (reverse! nbindings))
				     (values reset' node))))
			     ((let ((var (car (car obindings)))
				    (val (cdr (car obindings))))
				 (and (=fx (local-occurrence var) 0)
				      (not (side-effect? val))))
			      (trace (reduce 3)
				     "***1occ: removing: "
				     (shape (car obindings))
				     #\Newline)
			      (loop (cdr obindings) nbindings))
			     (else
			      (loop (cdr obindings)
				    (cons (car obindings) nbindings))))))))
	     (let ((binding (car obindings)))
		(let ((var (car binding))
		      (val (cdr binding)))
		   (multiple-value-bind (reset' nval)
		      (node-1occ! val 1-exp*)
		      (set-cdr! binding nval)
		      (cond
			 ((or reset reset')
			  (loop (cdr obindings)
				#t
				'()))
			 ((not (eq? (local-access var) 'read))
			  (loop (cdr obindings)
				#f
				extend))
			 ((and (=fx (local-occurrence var) 1)
			       (eq? (local-access var) 'read)
			       (not (side-effect? val)))
			  (trace (reduce 3)
				 "***1occ: applying: "
				 (shape var)
				 " "
				 (shape val)
				 #\Newline)
			  (loop (cdr obindings)
				#f
				(cons binding extend)))
			 (else
			  (if (and (=fx (local-occurrence var) 1)
				   (eq? (local-access var) 'read)
				   (side-effect? val))
			      (trace (reduce 3)
				     "***1occ: NOT applying: "
				     (shape var)
				     " "
				     (shape val)
				     #\Newline))
			  (loop (cdr obindings)
				#f
				extend))))))))))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::set-ex-it ...                                       */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::set-ex-it 1-exp*)
   (with-access::set-ex-it node (var body)
      (multiple-value-bind (reset nbody)
	 (node-1occ! body 1-exp*)
	 (set! body nbody)
	 (values reset node))))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::jump-ex-it ...                                      */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::jump-ex-it 1-exp*)
   (with-access::jump-ex-it node (exit value)
      (multiple-value-bind (reset nexit)
	 (node-1occ! exit 1-exp*)
	 (set! exit nexit)
	 (let ((1-exp*' (if reset '() 1-exp*)))
	    (multiple-value-bind (reset' nvalue)
	       (node-1occ! value 1-exp*')
	       (set! value nvalue)
	       (values (or reset reset') node))))))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::make-box ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::make-box 1-exp*)
   (with-access::make-box node (value)
      (multiple-value-bind (reset nvalue)
	 (node-1occ! value 1-exp*)
	 (set! value nvalue)
	 (values reset node))))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::box-set! ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::box-set! 1-exp*)
   (with-access::box-set! node (var value)
      (multiple-value-bind (reset nvalue)
	 (node-1occ! value 1-exp*)
	 (set! value nvalue)
	 (values reset node))))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::box-ref ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::box-ref 1-exp*)
   (values #f node))

;*---------------------------------------------------------------------*/
;*    node-1occ! ::app ...                                             */
;*---------------------------------------------------------------------*/
(define-method (node-1occ! node::app 1-exp*)
   (with-access::app node (fun args loc type)
      (let ((reset (node-1occ*! args 1-exp*)))
	 (if (or reset (side-effect? node))
	     (begin
		(trace (reduce 2)
		       "***1occ: side-effect?: " (shape node) #\Newline)
		(values #t node))
	     (values #f node)))))

;*---------------------------------------------------------------------*/
;*    node-1occ*! ...                                                  */
;*---------------------------------------------------------------------*/
(define (node-1occ*! node* 1-exp*)
   (let loop ((node*  node*)
	      (reset  #f)
	      (1-exp* 1-exp*))
      (cond
	 ((null? node*)
	  reset)
	 ((null? (cdr node*))
	  (multiple-value-bind (reset' node)
	     (node-1occ! (car node*) 1-exp*)
	     (set-car! node* node)
	     (or reset reset')))
	 (else
	  (multiple-value-bind (reset' node)
	     (node-1occ! (car node*) 1-exp*)
	     (set-car! node* node)
	     (if (or reset reset')
		 (loop (cdr node*) #t '())
		 (loop (cdr node*) #f 1-exp*)))))))
