;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Read/src.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 26 10:44:03 1994                          */
;*    Last change :  Tue Sep 17 11:55:14 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We read the source file                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module read_src
   (import  engine_param
	    engine_engine
 	    init_main
	    tools_file)
   (export  (read-src)))

;*---------------------------------------------------------------------*/
;*    read-src ...                                                     */
;*    -------------------------------------------------------------    */
;*    If the first source file start by an expression like             */
;*    #!...                                                            */
;*    we must evaluate the file rather than compile it. Hence,         */
;*    read_src returns `#f' to the compiler which means that the       */
;*    compiler will stop and jump to the interpreter.                  */
;*---------------------------------------------------------------------*/
(define (read-src)
   [assert (*src-files*) (pair? *src-files*)]
   ;; we read the first source file (which must be containing the
   ;; module clause).
   (let ((module (read-module-clause)))
      (if (not (pair? module))
	  module
	  (let loop ((src    (read-src/port))
		     (sfiles (cdr *src-files*)))
	     (if (null? sfiles)
		 (cons module (reverse! src))
		 (loop (read-src-file (car sfiles)) (cdr sfiles)))))))

;*---------------------------------------------------------------------*/
;*    read-handler ...                                                 */
;*---------------------------------------------------------------------*/
(define read-handler
   (lambda (escape proc mes obj)
      ;; before producing the error, we display the
      ;; source file name
      (hello-world)
      ;; then we display the error.
      (notify-error proc mes obj)
      (close-src-port)
      (exit-bigloo -3)))

;*---------------------------------------------------------------------*/
;*    read-module-clause ...                                           */
;*---------------------------------------------------------------------*/
(define (read-module-clause)
   (open-src-file (car *src-files*))
   (let ((module (try (read *port* #t)
		      read-handler)))
      (if *bigloo-interpreter*
	  ;; the `*bigloo-interpreter* variable is setted by the
	  ;; reader when it seees a #!... expression
	  #f
	  module)))

;*---------------------------------------------------------------------*/
;*    read-src/port ...                                                */
;*---------------------------------------------------------------------*/
(define (read-src/port)
   (let ((port *port*))
      (try (let loop ((r   (read port #t))
		      (acc '()))
	      (if (eof-object? r)
		  (begin
		     (close-src-port)
		     acc)
		  (loop (read port #t)
			(cons r acc))))
	   read-handler)))

;*---------------------------------------------------------------------*/
;*    read-src-file ...                                                */
;*---------------------------------------------------------------------*/
(define (read-src-file sfile)
   (open-src-file (find-file/path sfile *load-path*))
   (read-src/port))

;*---------------------------------------------------------------------*/
;*    *port* ...                                                       */
;*---------------------------------------------------------------------*/
(define *port* #f)
		  
;*---------------------------------------------------------------------*/
;*    open-src-file ...                                                */
;*---------------------------------------------------------------------*/
(define (open-src-file sfile)
   (set! *port* (if (string? sfile)
		    (if (file-exists? sfile)
			(let ((port (open-input-file sfile)))
			   (if (input-port? port)
			       port
			       (error "src-file->memory"
				      "Can't open such file"
				      sfile)))
			(error "src-file->memory"
			       "Can't find such file"
			       sfile))
		    (current-input-port))))

;*---------------------------------------------------------------------*/
;*    close-src-port ...                                               */
;*---------------------------------------------------------------------*/
(define (close-src-port)
   (if (and (input-port? *port*)
	    (not (eq? *port* (current-input-port))))
       (close-input-port *port*)))

   
