;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Read/load.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec 29 10:30:51 1994                          */
;*    Last change :  Tue Sep 17 11:54:33 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We scan files in order to find `inline' definitions.             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module read_load
   (include "Tools/trace.sch")
   (import  tools_error
	    tools_speek
	    tools_file
	    type_type
	    ast_ident)
   (export  (load-module module::symbol fnames::pair)))

;*---------------------------------------------------------------------*/
;*    load-module ...                                                  */
;*---------------------------------------------------------------------*/
(define (load-module module fnames)
   (verbose 1 "      [reading loaded module " module "]" #\Newline)
   (let* ((file  (car fnames))
	  (fname (find-file/path file *load-path*)))
      (if (not (string? fname))
	  (user-error "load-module"
		      "Can't find file"
		      fname)
	  (let ((port (open-input-file fname)))
	     (if (not (input-port? port))
		 (user-error "load-module" "Can't open such file" file)
		 (unwind-protect (let ((decl (read port)))
				    (if (not (and (pair? decl)
						  (eq? (car decl) 'module)))
					(user-error
					 "load-module"
					 "Illegal module declaration"
					 decl)
					;; on verifie le nome
					(if (not (eq? (cadr decl) module))
					    (user-error
					     "load-module"
					     (string-append
					      "conflict in module's name: "
					      (symbol->string module) " vs "
					      (symbol->string (cadr decl)))
					     decl))))
				 (close-input-port port))))))
      (for-each loadq fnames))
