;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Module/option.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Feb 28 10:20:55 1998                          */
;*    Last change :  Sat Feb 28 10:24:50 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The compiler option clause compilation                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_option
   (include "Ast/unit.sch")
   (import  module_module
	    tools_error
	    engine_param)
   (export  (make-option-compiler)))

;*---------------------------------------------------------------------*/
;*    make-option-compiler ...                                         */
;*---------------------------------------------------------------------*/
(define (make-option-compiler)
   (instantiate::ccomp
      (id 'option)
      (producer option-producer)))

;*---------------------------------------------------------------------*/
;*    option-producer ...                                              */
;*---------------------------------------------------------------------*/
(define (option-producer clause)
   (match-case clause
      ((?- . ?protos)
       (for-each eval protos)
       '())
      (else
       (user-error "Parse error"
		   (string-append "Illegal `option' clause")
		   clause
		   '()))))
