;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    .../prgm/project/bigloo/comptime1.9b/Globalize/gloclo.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Feb  3 09:56:11 1995                          */
;*    Last change :  Wed Apr 16 15:05:06 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The global closure creation                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_global-closure
   (include "Tools/trace.sch")
   (import  tools_shape
	    tools_args
	    tools_error
	    engine_param
	    type_type
	    type_cache
	    ast_var
	    ast_node
	    ast_sexp
	    ast_local
	    ast_glo-def
	    module_module
	    globalize_ginfo
	    globalize_node
	    globalize_free)
    (export (global-closure::global      ::global <loc>)
	    (make-global-closure::global ::global)
	    (foreign-closures)))

;*---------------------------------------------------------------------*/
;*    global-closure ...                                               */
;*---------------------------------------------------------------------*/
(define (global-closure global loc)
   (the-global-closure global loc)
   (make-global-closure global))
      
;*---------------------------------------------------------------------*/
;*    make-global-closure ...                                          */
;*---------------------------------------------------------------------*/
(define (make-global-closure global)
   (let ((glo (global/Ginfo-global-closure global)))
      (if (global? glo)
	  glo
	  (let* ((old-fun  (global-value global))
		 (env      (let ((var (make-local-svar 'env *procedure*)))
			      (widen!::local/Ginfo var)
			      var))
		 (new-args (map (lambda (old)
				   (let ((new (make-local-svar
					       (if (local? old)
						   (local-id old)
						   (gensym))
					       *obj*)))
				      (widen!::svar/Ginfo (local-value new))
				      (widen!::local/Ginfo new)
				      new))
				(if (sfun? old-fun)
				    (sfun-args old-fun)
				    (if (cfun? old-fun)
					;; cfun-args-type is a list of type
					;; not a list of local. It doesn't
					;; matter. What is important here
					;; is just the list.
					(cfun-args-type old-fun)
					(internal-error "make-global-closure"
							"Unexpected value"
							old-fun)))))
		 (gloclo   (gloclo global env new-args))
		 (new-fun  (global-value gloclo)))
	     ;; we must set now the info slot of env
	     (widen!::svar/Ginfo (local-value env))
	     ;; we ajust the function definition
	     (widen!::global/Ginfo gloclo (escape? #t))
	     (sfun-body-set! new-fun
			     (instantiate::app
				(loc #f)
				(type *obj*)
				(fun (instantiate::var
					(loc #f)
					(type *_*)
					(variable global)))
				;; we have to ignore the addition environment
				;; parameters, so we just take the cdr of the
				;; formals list.
				(args (map (lambda (v)
					      (instantiate::var
						 (loc #f)
						 (type *obj*)
						 (variable v)))
					   new-args))))
	     (trace (globalize 2) "=======> J'ai cree le corps:"
		    (shape (sfun-body new-fun))
		    #\Newline)
	     gloclo))))

;*---------------------------------------------------------------------*/
;*    *foreign-closures* ...                                           */
;*---------------------------------------------------------------------*/
(define *foreign-closures* '())

;*---------------------------------------------------------------------*/
;*    foreign-closures ...                                             */
;*---------------------------------------------------------------------*/
(define (foreign-closures)
   (let ((res *foreign-closures*))
      (set! *foreign-closures* '())
      res))
   
;*---------------------------------------------------------------------*/
;*    gloclo ...                                                       */
;*---------------------------------------------------------------------*/
(define (gloclo global env::local args)   
   (let* ((arity  (fun-arity (global-value global)))
	  (gloclo (def-global-sfun! (symbol-append '_ (global-id global)
						   '::obj)
		     (make-n-proto (+-arity arity 1))
		     (cons env args)
		     (if (eq? (global-import global) 'foreign)
			 *module*
			 (global-module global))
		     (global-import global)
		     'sfun
		     'now
		     #unspecified)))
      (global/Ginfo-global-closure-set! global gloclo)
      (if (eq? (global-import global) 'foreign)
	  (begin
	     (set! *foreign-closures* (cons gloclo *foreign-closures*))
	     (global-import-set! gloclo 'static))
	  (global-import-set! gloclo (global-import global)))
      (fun-side-effect?-set! (global-value gloclo)
			     (fun-side-effect? (global-value global)))
      (if (not (global? gloclo))
	  (internal-error "global-closure"
			  "Can't allocate global closure"
			  gloclo)
	  gloclo)))
