;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Globalize/clocto.scm     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 23 14:03:24 1996                          */
;*    Last change :  Wed Jul 17 11:32:11 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The transitive closure of the `cto' property.                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_clocto
   (include "Tools/trace.sch")
   (import  tools_shape
	    type_type
	    ast_var
	    ast_node
	    globalize_ginfo
	    globalize_kapture)
   (export  (cto-transitive-closure! ::local)))

;*---------------------------------------------------------------------*/
;*    cto-transitive-closure ...                                       */
;*---------------------------------------------------------------------*/
(define (cto-transitive-closure! host)
   (let* ((info      (local-value host))
	  (cto       (append (sfun/Ginfo-cto info)
			     (sfun/Ginfo-cfunction info)))
	  (cto*-orig (list cto)))
      (let loop ((cto  cto)
		 (cto* cto*-orig))
	 (cond
	    ((null? cto)
	     (sfun/Ginfo-cto*-set! info
				  (if (eq? cto* cto*-orig)
				      (car cto*-orig)
				      (union cto*))))
	    ((eq? (car cto) local)
	     (loop (cdr cto) cto*))
	    ((sfun/Ginfo-G? (local-value (car cto)))
	     (loop (cdr cto) cto*))
	    (else
	     (loop (cdr cto)
		   (cons (append
			  (sfun/Ginfo-cto (local-value (car cto)))
			  (sfun/Ginfo-cfunction (local-value (car cto))))
			 cto*)))))))
	     
	     
