;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Foreign/cfun.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun  6 12:23:13 1996                          */
;*    Last change :  Thu Apr  3 14:18:35 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The C function accessors creations                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module foreign_cfunction
   (import tools_error
	   tools_misc
	   type_tools
	   type_type
	   foreign_ctype
	   foreign_access
	   module_module
	   engine_param))
   
;*---------------------------------------------------------------------*/
;*    make-ctype-accesses! ::cfunction ...                             */
;*---------------------------------------------------------------------*/
(define-method (make-ctype-accesses! what::cfunction who::type)
   (let* ((btype       (cfunction-btype what))
	  (id          (type-id who))
	  (wid         (type-id what))
	  (bid         (type-id btype))
	  (call-id     (symbol-append id '-call))
	  (id->bid     (symbol-append id '-> bid))
	  (bid->id     (symbol-append bid '-> id))
	  (bid?        (symbol-append id '?))
	  (bid?-bool   (symbol-append bid? '::bool))
	  (name        (type-name who))
	  (name-sans-$ (string-sans-$ name))
	  (type-res    (cfunction-type-res what))
	  (type-args   (cfunction-type-args what))
	  (arity       (cfunction-arity what))
	  (nb-args     (integer->string arity)))

      ;; the two conversion allocation functions (they are not
      ;; simple coercion because the first one allocate and the
      ;; second one destructurate).
      (define (mk-id->bid)
	 `(macro ,bid ,id->bid (symbol ,id) "cobj_to_foreign"))

      (define (mk-bid->id)
	 (let ((mname (string-append "(" name-sans-$ ")FOREIGN_TO_COBJ")))
	    `(macro ,id ,bid->id (,bid) ,mname)))

      ;; the predicate
      (define (mk-bid?)
	 `(define-inline (,bid?-bool o::obj)
	     (if (foreign? o)
		 (eq? (foreign-id o) ',bid)
		 #f)))
	     
      ;; equality (using ==)
      (define (mk-=id)
	 `(define-inline (,(symbol-append '= id '::bool)
			  ,(symbol-append 'o1 4dots id)
			  ,(symbol-append 'o2 4dots id))
	     (pragma::bool "($1 == $2)" o1 o2)))

      (define (mk-c-call-id)
	 (let* ((tres-id     (type-id type-res))
		(targs-id    (map type-id type-args))
		(caller-name (string-append "C_FUNCTION_CALL_" nb-args))
		(c-call-id   (symbol-append 'c- call-id)))
	    `(macro ,tres-id ,c-call-id ,(cons id targs-id) ,caller-name)))

      ;; the caller
      (define (mk-call-id)
	 (cond
	    ((>=fx arity *max-c-foreign-arity*)
	     (user-error id
			 (string-append
			  "Too large arity for a foreign function (max"
			  (integer->string *max-c-foreign-arity*)
			  ")")
			 (string-append nb-args " args provided")))
	    ((>=fx arity 0)
	     (fix-args-call-id))
	    (else
	     (user-error "bigloo"
			 "Can't manage pointers on C multiple arity function"
			 id))))

      (define (fix-args-call-id)
	 (let* ((tres-id   (type-id type-res))
		(targs-id  (map type-id type-args))
		(args      (map gensym targs-id))
		(c-call-id (symbol-append 'c- call-id)))	  
	 `(define-inline (,(symbol-append call-id 4dots tres-id)
			  ,(symbol-append 'f 4dots id)
			  ,@(map (lambda (arg type)
				    (symbol-append arg 4dots type))
				 args targs-id))
	     (,c-call-id f ,@args))))

      ;; we declare the coercion operations ...
      (produce-module-clause! `(foreign ,(mk-id->bid)
					,(mk-bid->id)
					,(mk-c-call-id)))
      ;; and the predicate
      (produce-module-clause! `(static (inline ,bid?-bool ::obj)))
      (produce-module-clause! `(pragma (,bid? (predicate-of ,wid))))

      ;; and we return the built code
      (list (mk-bid?) (mk-=id) (mk-call-id))))
      
      
   
