;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Engine/engine.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 10:13:23 1993                          */
;*    Last change :  Fri Aug  9 13:48:43 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The system's engine (some kind of dispatcher between the linker, */
;*    the interpreter and the compiler).                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module engine_engine
   (export (engine)
	   (hello-world))
   (import tools_speek
	   tools_trace
	   write_version
           engine_param
	   engine_compiler
	   engine_interp
	   engine_link))

;*---------------------------------------------------------------------*/
;*    engine ...                                                       */
;*---------------------------------------------------------------------*/
(define (engine)
   (cond
      ((and (pair? *src-files*) (not *interpreter*))
       (compiler))
      ((null? *o-files*)
       (interp version
	       *verbose*
	       *src-files*
	       *startup-file*
	       (string-append *lib-dir* "/scheme-files")
	       *bigloo-args*))
      (else
       (link))))

;*---------------------------------------------------------------------*/
;*    hello-world ...                                                  */
;*---------------------------------------------------------------------*/
(define (hello-world)
   ;; aller, on dit bonjour
   (let loop ((src (reverse! *src-files*))
	      (str ""))
      (if (null? src)
	  (begin
	     (string-set! str (-fx (string-length str) 1) #\:)
	     (verbose 0 str #\Newline))
	  (loop (cdr src) (string-append (car src) " " str)))))



	   


