;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Coerce/coerce.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jan 19 09:57:49 1995                          */
;*    Last change :  Thu Apr  3 14:17:43 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We coerce an Ast                                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module coerce_coerce
   (include "Tools/trace.sch")
   (import  tools_shape
	    tools_error
	    type_type
	    type_cache
	    type_coercion
	    ast_var
	    ast_node
	    coerce_pproto
	    coerce_convert
	    coerce_app
	    coerce_apply
	    coerce_funcall
	    coerce_typeof)
   (export  (generic coerce!::node ::node ::type)))

;*---------------------------------------------------------------------*/
;*    coerce! ...                                                      */
;*---------------------------------------------------------------------*/
(define-generic (coerce!::node node::node to::type))

;*---------------------------------------------------------------------*/
;*    coerce! ...                                                      */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::atom to)
   (convert! node (typeof node) to))
 
;*---------------------------------------------------------------------*/
;*    coerce! ...                                                      */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::kwote to)
   (convert! node (typeof node) to))

;*---------------------------------------------------------------------*/
;*    coerce! ...                                                      */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::var to)
   (with-access::var node (variable)
      (let ((type (typeof node)))
	 (convert! node type to))))

;*---------------------------------------------------------------------*/
;*    coerce! ::closure ...                                            */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::closure to)
   (internal-error "coerce!" "Unexepected `closure' node" (shape node)))

;*---------------------------------------------------------------------*/
;*    coerce! ::sequence ...                                           */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::sequence to)
   (with-access::sequence node (nodes)
      (let loop ((hook nodes))
	 (if (null? (cdr hook))
	     (begin
		(set-car! hook (coerce! (car hook) to))
		node)
	     (begin
		;; yes, it is strange, we coerce to the type of
		;; the expression !
		(set-car! hook (coerce! (car hook) (typeof (car hook))))
		(loop (cdr hook)))))))

;*---------------------------------------------------------------------*/
;*    coerce! ::pragma ...                                             */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::pragma to)
   (with-access::pragma node (args)
      (let loop ((values args))
	 (if (null? values)
	     (convert! node (typeof node) to)
	     (begin
		(set-car! values (coerce! (car values) (typeof (car values))))
		(loop (cdr values)))))))

;*---------------------------------------------------------------------*/
;*    coerce! ::cast ...                                               */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::cast to)
   (with-access::cast node (arg type)
      (set! arg (coerce! arg (typeof arg)))
      (convert! node type to)))

;*---------------------------------------------------------------------*/
;*    coerce! ::setq ...                                               */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::setq to)
   (with-access::setq node (var value)
      (set! value (coerce! value (variable-type (var-variable var))))
      (convert! node *unspec* to)))

;*---------------------------------------------------------------------*/
;*    coerce! ::conditional ...                                        */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::conditional to)
   (with-access::conditional node (test true false)
      (set! test (coerce! test *bool*))
      (set! true (coerce! true to))
      (set! false (coerce! false to))
      node))

;*---------------------------------------------------------------------*/
;*    coerce! ::fail ...                                               */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::fail to)
   (with-access::fail node (proc msg obj)
      (set! proc (coerce! proc *obj*))
      (set! msg (coerce! msg *obj*))
      (set! obj (coerce! obj *obj*)) 
      (convert! node *magic* to)))

;*---------------------------------------------------------------------*/
;*    coerce! ::select ...                                             */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::select to)
   (with-access::select node (loc clauses test)
      (let ((clauses        clauses)
	    (test-type      (select-item-type node))
	    (test-node-type (typeof test)))
	 ;; select constructions are normalized: the test should have
	 ;; been placed in a variable. That's why this test below should
	 ;; work. This test may fails (in strange cases that I'm currently
	 ;; ignoring) and then, it may happens that some `correct' select
	 ;; construction could be rejected. These forms are those where the
	 ;; else clause trap objects of different types from the one tested
	 ;; in the clauses.
	 (if (not (coercer-exists? test-node-type test-type))
	     (coerce! (runtime-type-error loc
					  (type-id test-type)
					  test)
		      to)
	     (begin
		(select-test-set! node (coerce! test test-type))
		(for-each (lambda (clause)
			     (set-cdr! clause (coerce! (cdr clause) to)))
			  clauses)
		node)))))
      
;*---------------------------------------------------------------------*/
;*    coerce! ::let-fun ...                                            */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::let-fun to)
   (with-access::let-fun node (body locals)
      (inc-ppmarge!)
      (for-each (lambda (local)
		   (let ((fun (local-value local)))
		      (pfunction-proto 3 local)
		      (sfun-body-set! fun
				      (coerce! (sfun-body fun)
					       (local-type local)))))
		locals)
      (set! body (coerce! body to))
      (dec-ppmarge!)
      node))

;*---------------------------------------------------------------------*/
;*    coerce! ::let-var ...                                            */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::let-var to)
   (with-access::let-var node (body bindings)
      (inc-ppmarge!)
      (for-each (lambda (binding)
		   (pvariable-proto 3 (car binding))
		   (set-cdr! binding (coerce! (cdr binding)
					      (local-type (car binding)))))
		bindings)
      (set! body (coerce! body to))
      (dec-ppmarge!)
      node))
 
;*---------------------------------------------------------------------*/
;*    coerce! ::set-ex-it ...                                          */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::set-ex-it to)
   (with-access::set-ex-it node (var body)
      (set! var (coerce! var *exit*))
      (pvariable-proto 3 (var-variable var))
      (set! body (coerce! body to))
      node))

;*---------------------------------------------------------------------*/
;*    coerce! ::jump-ex-it ...                                         */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::jump-ex-it to)
   (with-access::jump-ex-it node (exit value)
      (set! exit (coerce! exit *exit*))
      (set! value (coerce! value to))
      node))

;*---------------------------------------------------------------------*/
;*    coerce! ::make-box ...                                           */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::make-box to)
   (with-access::make-box node (value)
      (set! value (coerce! value *obj*))
      node))

;*---------------------------------------------------------------------*/
;*    coerce! ::box-ref ...                                            */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::box-ref to)
   (with-access::box-ref node (var)
      (convert! node *obj* to)))

;*---------------------------------------------------------------------*/
;*    coerce! ::box-set! ...                                           */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::box-set! to)
   (with-access::box-set! node (var value)
      (local-type-set! (var-variable var) *obj*)
      (set! value (coerce! value *obj*))
      (convert! node *unspec* to)))
	    




