;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Cgen/walk.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Feb 21 08:37:48 1995                          */
;*    Last change :  Thu Aug 21 14:03:55 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `C generation' pass.                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_walk
   (include "Engine/pass.sch"
	    "Ast/unit.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    tools_error
	    engine_param
	    module_module
	    module_library
	    type_type
	    ast_var
	    ast_node
	    ast_occur
	    ast_build
	    object_class
	    cgen_cop
	    cgen_emit
	    cgen_prototype
	    cgen_main
	    cgen_init
	    cgen_cgen)
   (export  (cgen-walk globals)))

;*---------------------------------------------------------------------*/
;*    cgen-walk ...                                                    */
;*---------------------------------------------------------------------*/
(define (cgen-walk globals)
   (pass-prelude "C generation" (lambda () (start-emission! ".c")))

   (trace cgen "cgen-walk: *main*: " (shape *main*) #\( *main* #\) #\Newline)
   
   (let* ((lib-unit (library-finalizer))
	  (lib-init (if (unit? lib-unit)
			(let ((vars (build-ast-sans-remove (list lib-unit))))
			   (for-each (lambda (g)
					(occur-node-in!
					 (sfun-body (global-value g))
					 g))
				     vars)
			   vars)
			'()))
	  (globals  (cons (make-module-init)
			  (if (and (or *main* (memq *pass* '(ld distrib)))
				   (not (eq? *main* 'imported)))
			      (cons (make-bigloo-main)
				    (append lib-init globals))
			      (append lib-init globals)))))
      
      ;; a very little comment 
      (emit-header)
   
      ;; emit the GC selection
      (emit-garbage-collector-selection)
   
      ;; if we are in debugging mode, we generate a maco
      (if (or (>fx *compiler-debug* 0) *c-debug*)
	  (emit-debug-activation))
   
      ;; the include (both Bigloo's and user's ones)
      (emit-include)
   
      ;; we emit the generated type for the classes
      (emit-class-types *c-port*)
   
      ;; we declare prototypes
      ;; first, we print the prototype of variables
      (emit-prototypes)

      ;; then we emit the constants values
      (emit-cnsts)
   
      ;; we print the C main...
      (if (and (or *main* (memq *pass* '(ld distrib)))
	       (not (eq? *main* 'imported)))
	  (emit-main))

      ;; we now emit the code for all the Scheme functions
      (for-each cgen globals)
      
      (stop-emission!)))
